/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.databrowser.AndroidDeviceException;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.utility.AdbRunnerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class AndroidABIDetector {
    private static final String NO_TERMINAL_WRAPPER_ERROR = "Could not find terminal wrapper on device.\n\nPlease unplug and reconnect the device.";
    private static final String TERMINAL_WRAPPER_PATH = "/data/local/tmp/terminal_wrapper";

    public static @NonNull AndroidDeviceABI getAndroidDeviceABI(@NonNull IAdbCommandRunner commandRunner) throws IOException, AndroidDeviceException {
        AdbDeviceRootMode deviceRootMode = commandRunner.detectRootMode();
        IAdbCommandRunner.WrapMode wrapMode = IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)deviceRootMode);
        IBasicInteractiveShell.InteractiveCommandResult result = commandRunner.runCommandAndGetOutput(wrapMode, "getprop", new String[]{"ro.product.cpu.abilist"});
        if (!result.status.isSuccessful()) {
            if (!commandRunner.runCommandAndGetOutput((String)"test", (String[])new String[]{"-f /data/local/tmp/terminal_wrapper"}).status.isSuccessful()) {
                throw new AndroidDeviceException(NO_TERMINAL_WRAPPER_ERROR);
            }
            throw new AndroidDeviceException("Could not determine device abi support: " + result.errorsAndOutputJoined());
        }
        List<String> supportedAbis = Arrays.asList(result.errorsOrOutputJoined().split(","));
        for (String supportedAbi : supportedAbis) {
            if (supportedAbi.contentEquals("arm64-v8a")) {
                return AndroidDeviceABI.ARM64;
            }
            if (supportedAbi.contentEquals("armeabi-v7a")) {
                return AndroidDeviceABI.ARM32;
            }
            if (!supportedAbi.contentEquals("x86_64")) continue;
            return AndroidDeviceABI.X86_64;
        }
        return AndroidDeviceABI.UNKNOWN;
    }

    public static @NonNull AndroidDeviceABI getAndroidDeviceABI(@NonNull IAdbProcessRunner adbProcessRunner, @NonNull TargetAddressString targetAddressString) throws IOException, AndroidDeviceException {
        if (targetAddressString.isAndroid()) {
            IAdbCommandRunner adbCommandRunner = AdbRunnerFactory.SINGLETON.create(adbProcessRunner, targetAddressString.getAndroidSerialNumber());
            return AndroidABIDetector.getAndroidDeviceABI(adbCommandRunner);
        }
        return AndroidDeviceABI.UNKNOWN;
    }

    public static enum AndroidDeviceABI {
        ARM64,
        ARM32,
        X86_64,
        UNKNOWN;


        public @NonNull String toString() {
            switch (this) {
                case ARM32: {
                    return "ARM32";
                }
                case ARM64: {
                    return "ARM64";
                }
                case X86_64: {
                    return "X86_64";
                }
            }
            return "UNKNOWN";
        }
    }
}

