/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.session.IDatabaseGenerator;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.report.model.topology.IClustersInfo;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractDatabaseGenerator
implements IDatabaseGenerator {
    private boolean mDiscard = false;
    private boolean mStopRequested = false;

    @Override
    public final boolean generateDatabase(@NonNull IAnalysisInputSettings analysisSettings, @NonNull String capturePath, @NonNull ICaptureDetails captureDetails, @NonNull IClustersInfo clustersInfo, @NonNull SessionProcessor sessionProcessor, ICaptureProxy proxy, @NonNull IAnalysisHandler handler, @NonNull AttachedApkEntries attachedApkEntries) throws IOException, Exception {
        boolean result;
        this.mDiscard = sessionProcessor.isDiscard();
        try {
            this.checkError();
            result = this.processRecords(analysisSettings, analysisSettings.isGenerateSpeSampleLogEnabled(), capturePath, captureDetails, clustersInfo, sessionProcessor, proxy, handler, attachedApkEntries);
            this.checkError();
        }
        catch (Throwable t) {
            handler.cancel();
            throw t;
        }
        this.checkError();
        return result;
    }

    @Override
    public void stop() {
        this.mStopRequested = true;
    }

    protected final void checkError() throws Exception {
        if (this.mDiscard && this.mStopRequested) {
            throw new InterruptedException();
        }
    }

    protected abstract boolean processRecords(@NonNull IAnalysisInputSettings var1, boolean var2, @NonNull String var3, @NonNull ICaptureDetails var4, @NonNull IClustersInfo var5, @NonNull SessionProcessor var6, ICaptureProxy var7, @NonNull IAnalysisHandler var8, @NonNull AttachedApkEntries var9) throws Exception;
}

