/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.outline;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.CounterSet;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.outline.CategoryBaseRow;
import com.arm.streamline.counterconfig.outline.CoCategoryRow;
import com.arm.streamline.counterconfig.outline.StockCounterRow;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.NullChecking;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Image;

public class CategoryRow
extends CategoryBaseRow {
    public int imageX;
    public int imageWidth;

    public CategoryRow(@NonNull Configurations configurations, @NonNull Category category, boolean showAdvancedCounters, @NonNull Events events) {
        this(configurations, category, null, showAdvancedCounters, events);
    }

    public CategoryRow(@NonNull Configurations configurations, @NonNull Category category, Pattern filter, boolean showAdvancedCounters, @NonNull Events events) {
        super(configurations, category);
        this.setCanHaveChildren(true);
        this.setOpen(true);
        List sets = category.getCounterSets();
        if (sets.size() > 1) {
            for (CounterSet set : sets) {
                this.addChild(new CoCategoryRow(configurations, category, set));
            }
        }
        for (StockCounter counter : category) {
            if (counter.isAdvanced() && !showAdvancedCounters) continue;
            @NonNull CharSequence categoryName = (CharSequence)NullChecking.neverNull((Object)counter.getCategory().getName());
            @NonNull CharSequence counterTitle = (CharSequence)NullChecking.neverNull((Object)counter.getDisplayTitle());
            if (filter != null && !filter.matcher(counterTitle).find() && !filter.matcher(categoryName).find()) continue;
            this.addChild(new StockCounterRow(configurations, counter, events));
        }
    }

    @Override
    public String getAvailableText() {
        Category category = this.getCategory();
        List sets = category.getCounterSets();
        if (sets.isEmpty()) {
            return "";
        }
        int total = 0;
        int used = 0;
        for (CounterSet set : sets) {
            total += set.size();
            used += this.mConfigurations.getCountersInUse(set).size();
        }
        return String.format(sets.size() == 1 ? CountersMessages.X_OF_Y_AVAILABLE : CountersMessages.X_OF_Y_OVERALL, total - used, total);
    }

    @Override
    public Image getImage(SimpleColumn column) {
        if (this.mConfigurations.hasSynchronizedListener(this.getCategory())) {
            return StreamlinePlugin.getImage("Synced.gif");
        }
        return null;
    }
}

