/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.common.xml.spe.SpeFilterConfiguration;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.SpeRow;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.counterconfig.outline.CategoryRow;
import com.arm.streamline.counterconfig.outline.CounterCell;
import com.arm.streamline.counterconfig.outline.CountersOutline;
import com.arm.streamline.counterconfig.outline.IEventSelectionListener;
import com.arm.streamline.counterconfig.outline.SpeTargetDescriptionRow;
import com.arm.streamline.counterconfig.outline.StockCounterRow;
import com.arm.streamline.editortabs.warnings.WarningBadge;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FilterField;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.IOutlineModelListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.NullChecking;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CountersUiShared {
    public static final boolean ADVANCED_MODE_DEFAULT = false;
    public static final String BLANK = "";
    public final @NonNull Label label;
    public final @NonNull AvailableEventsToolbar toolbar;
    public final @NonNull CounterConfiguration config;
    public final @NonNull CountersOutline availableOutline;
    public final @NonNull Composite description;
    private final @NonNull Label descriptionTitle;
    private final @NonNull Label descriptionArea;
    final boolean isUpdateScrollBar;

    public CountersUiShared(@NonNull Composite parent, @NonNull CounterConfiguration config, @NonNull IEventSelectionListener ebsToggleHandler, boolean isDialog) {
        this.isUpdateScrollBar = isDialog;
        this.config = config;
        this.label = CountersUiShared.createAvailableEventsLabel(parent);
        this.toolbar = new AvailableEventsToolbar(parent, config, this::applyFilter);
        this.availableOutline = this.createAvailableOutline(parent, config, ebsToggleHandler);
        this.description = CountersUiShared.createBorderedComposite(parent);
        GridLayoutFactory.swtDefaults().applyTo(this.description);
        this.descriptionTitle = new Label(this.description, 16384);
        this.descriptionTitle.setFont(Fonts.getNormalStandout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.descriptionTitle);
        this.descriptionArea = new Label(this.description, 16448);
        this.descriptionArea.setFont(Fonts.getNormal());
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, FontInfo.get(this.descriptionArea.getFont()).getHeight() * 5).applyTo((Control)this.descriptionArea);
        this.availableOutline.addMouseCounterListener(this::setCounter);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void applyFilter(Pattern pattern, boolean showAdvancedCounters) {
        OutlineModel<SimpleColumn> model = this.availableOutline.getModel();
        this.availableOutline.setAllowLazyAdjust(false);
        boolean canNotify = model.getSelection().canNotify();
        model.getSelection().setNotify(false);
        model.removeAllRows();
        for (Category category : this.config.getEvents().getCategories()) {
            model.addRow(new CategoryRow(this.config.getConfigurations(), category, pattern, showAdvancedCounters, this.config.getEvents()), true);
        }
        @NonNull @NonNull Collection values = this.config.getEvents().getAvailableSpeTargetDescriptions();
        if (values.size() > 0) {
            SpeRow row = new SpeRow(values, pattern, this.config.getConfigurations());
            model.addRow(row, true);
        }
        this.availableOutline.setAllowLazyAdjust(true);
        model.getSelection().setNotify(canNotify);
        this.availableOutline.adjustScrollBarsForContent();
        this.availableOutline.redraw();
    }

    public static @NonNull Label createAvailableEventsLabel(Composite parent) {
        return CountersUiShared.makeBold(CountersUiShared.createLabel(parent, CountersMessages.AVAILABLE_EVENTS));
    }

    public static @NonNull Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    public static @NonNull Label makeBold(Label label) {
        FontDescriptor boldDesc = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDesc.createFont((Device)label.getDisplay());
        label.setFont(boldFont);
        return label;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull CountersOutline createAvailableOutline(@NonNull Composite content, final @NonNull CounterConfiguration config, final @NonNull IEventSelectionListener eventsEditorHandler) {
        final Configurations configurations = config.getConfigurations();
        final OutlineModel<SimpleColumn> model = new OutlineModel<SimpleColumn>();
        SimpleColumn column = new SimpleColumn(0, CountersMessages.AVAILABLE_EVENTS, BLANK);
        column.setPrimary(true);
        column.setRowCell(new CounterCell(configurations));
        column.setNoMaxWidth();
        model.addColumn(column);
        for (Category category : config.getEvents().getCategories()) {
            model.addRow(new CategoryRow(config.getConfigurations(), category, false, config.getEvents()), true);
        }
        @NonNull @NonNull Collection values = config.getEvents().getAvailableSpeTargetDescriptions();
        if (values.size() > 0) {
            SpeRow row = new SpeRow(values, null, config.getConfigurations());
            model.addRow(row, true);
        }
        final CountersOutline countersOutline = new CountersOutline(content, model);
        Configurations.IListener listener = () -> ((CountersOutline)countersOutline).redraw();
        configurations.addListener(listener);
        countersOutline.addDisposeListener(x -> configurations.removeListener(listener));
        countersOutline.addOutlineListener(new IOutlineListener<SimpleColumn>(){

            @Override
            public void selectionChanged(Outline<SimpleColumn> outline) {
            }

            @Override
            public void openSelectionRequested(Outline<SimpleColumn> outline) {
                @NonNull List<@NonNull StockCounter> selectedStockCounters = countersOutline.getSelectedStockCounters().stream().collect(Collectors.toList());
                @NonNull List<@NonNull SpeTargetDescription> selectedSpeTargets = countersOutline.getSelectedSpeEvents().stream().collect(Collectors.toList());
                configurations.addEvents(selectedSpeTargets, selectedStockCounters);
            }

            @Override
            public void editorChanged(Outline<SimpleColumn> outline) {
            }

            @Override
            public void deleteSelectionRequested(Outline<SimpleColumn> outline) {
                @NonNull List<@NonNull StockCounter> selectedStockCounters = countersOutline.getSelectedStockCounters().stream().collect(Collectors.toList());
                @NonNull List<@NonNull SpeTargetDescription> selectedSpeTargets = countersOutline.getSelectedSpeEvents().stream().collect(Collectors.toList());
                configurations.removeSelectedEvents(selectedSpeTargets, selectedStockCounters);
                countersOutline.getModel().deselect();
            }
        });
        configurations.addListener(new Configurations.IListener(){

            @Override
            public void handleEventsAdded(Collection<SpeFilterConfiguration> filterConfig, Collection<TargetCounter> targetCounters) {
                Row matching = null;
                if (targetCounters.isEmpty() && filterConfig.size() == 1) {
                    List rows = countersOutline.getModel().getRows();
                    for (Row row : rows) {
                        if (!(row instanceof SpeTargetDescriptionRow) || !filterConfig.iterator().next().getTargetDescription().equals(((SpeTargetDescriptionRow)row).getData())) continue;
                        matching = row;
                        break;
                    }
                }
                if (matching != null) {
                    countersOutline.getModel().deselect();
                    countersOutline.getModel().select(matching, false);
                }
            }

            @Override
            public void handleReload() {
            }
        });
        countersOutline.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CountersUiShared.this.handleSelection(config, eventsEditorHandler, countersOutline, model);
            }
        });
        countersOutline.getModel().addListener(new IOutlineModelListener<SimpleColumn>(){

            @Override
            public void sorted(OutlineModel<SimpleColumn> model, boolean restoring) {
            }

            @Override
            public void sortCleared(OutlineModel<SimpleColumn> model) {
            }

            @Override
            public void selectionWillChange(OutlineModel<SimpleColumn> model) {
            }

            @Override
            public void selectionDidChange(OutlineModel<SimpleColumn> model) {
                CountersUiShared.this.handleSelection(config, eventsEditorHandler, countersOutline, model);
            }

            @Override
            public void rowsWillBeRemoved(OutlineModel<SimpleColumn> model, Row<SimpleColumn>[] rows) {
            }

            @Override
            public void rowsWereRemoved(OutlineModel<SimpleColumn> model, Row<SimpleColumn>[] rows) {
            }

            @Override
            public void rowsAdded(OutlineModel<SimpleColumn> model, Row<SimpleColumn>[] rows) {
            }
        });
        return countersOutline;
    }

    public static @NonNull Composite createBorderedComposite(Composite parent) {
        Composite composite = new Composite(parent, 0x20000000);
        composite.addPaintListener(event -> {
            GC gc = new GC(event.gc);
            Rectangle bounds = ((Composite)event.widget).getClientArea();
            gc.setForeground(Colors.getWidgetNormalShadow());
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        });
        GridLayoutFactory.fillDefaults().margins(1, 1).applyTo(composite);
        return composite;
    }

    public void setCounter(@Nullable IAvailableEvent counter) {
        if (counter != null) {
            this.descriptionTitle.setText(counter.getTitleNameEvent());
            this.descriptionArea.setText(counter.getDescription());
        } else {
            this.descriptionTitle.setText(BLANK);
            this.descriptionArea.setText(BLANK);
        }
    }

    void handleSelection(CounterConfiguration config, IEventSelectionListener eventsEditorHandler, @NonNull CountersOutline countersOutline, OutlineModel<SimpleColumn> model) {
        List<Row<SimpleColumn>> selection = model.getSelectionAsList();
        if (selection.size() == 1) {
            Row<SimpleColumn> row = selection.get(0);
            if (row instanceof SpeTargetDescriptionRow) {
                SpeTargetDescriptionRow speRow = (SpeTargetDescriptionRow)row;
                if (config.getConfigurations().isAlreadyAddedToCollectEvents(speRow.getTargetDescription())) {
                    @Nullable SpeFilterConfiguration filterConfiguration = config.getConfigurations().getFilterConfiguration(speRow.getTargetDescription());
                    if (filterConfiguration != null) {
                        eventsEditorHandler.handleRequest(filterConfiguration);
                        if (!this.isUpdateScrollBar) {
                            countersOutline.scrollRowsIntoView(Arrays.asList(row), true);
                        }
                    } else {
                        eventsEditorHandler.handleClearRequest();
                    }
                }
            } else if (row instanceof StockCounterRow) {
                @NonNull StockCounterRow stkRow = (StockCounterRow)row;
                @NonNull List<@NonNull T> countersOf = config.getConfigurations().getCountersOf(stkRow.getCounter()).collect(Collectors.toList());
                if (countersOf.size() == 1) {
                    @NonNull TargetCounter event = (TargetCounter)countersOf.get(0);
                    boolean ebsTarget = stkRow.isEbsTarget(config.getConfigurations());
                    if (ebsTarget) {
                        eventsEditorHandler.handleRequest(event);
                        if (!this.isUpdateScrollBar) {
                            countersOutline.scrollRowsIntoView(Arrays.asList(row), true);
                        }
                    } else {
                        eventsEditorHandler.handleClearRequest();
                    }
                } else {
                    eventsEditorHandler.handleClearRequest();
                }
            }
        } else {
            eventsEditorHandler.handleClearRequest();
        }
    }

    public static class AvailableEventsToolbar
    extends Composite {
        public final @NonNull FilterField filterField;
        public final @NonNull ToolItem advancedMode;
        private final @NonNull Filter filter;

        public AvailableEventsToolbar(Composite parent, @NonNull CounterConfiguration config, @NonNull Filter filter) {
            super(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 0).spacing(2, 0).applyTo((Composite)this);
            @NonNull IWarnings warnings = config.getSetupWarnings();
            if (!warnings.isEmpty()) {
                WarningBadge badge = new WarningBadge(this, warnings);
                GridDataFactory.fillDefaults().applyTo((Control)badge);
            }
            @NonNull ToolBar availableEventsToolbar = new ToolBar((Composite)this, 0);
            GridDataFactory.fillDefaults().applyTo((Control)availableEventsToolbar);
            this.advancedMode = this.createAdvancedMode(availableEventsToolbar);
            this.filter = filter;
            this.filterField = new FilterField(this, field -> filter.applyFilter(field.getPattern(), this.advancedMode.getSelection()), CountersMessages.FILTER_WATERMARK, CountersMessages.FILTER_TOOLTIP);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.filterField);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this);
        }

        private static boolean showWarning(String message) {
            @NonNull MessageDialogWithToggle dialog = new MessageDialogWithToggle(null, CountersMessages.TITLE_DEPRECATED_SOURCES, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 1, CountersMessages.DONT_SHOW_WARNING, false);
            dialog.open();
            return dialog.getToggleState();
        }

        private @NonNull ToolItem createAdvancedMode(ToolBar availableEventsToolBar) {
            final ToolItem advancedMode = new ToolItem(availableEventsToolBar, 32);
            advancedMode.setSelection(false);
            advancedMode.setImage(AvailableEventsToolbar.advancedModeImage(false));
            advancedMode.setToolTipText(CountersMessages.ADVANCED_COUNTERS_VIEW);
            advancedMode.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    advancedMode.setImage(AvailableEventsToolbar.advancedModeImage(advancedMode.getSelection()));
                    this.toggleAdvancedViewMode();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return advancedMode;
        }

        private static Image advancedModeImage(boolean selected) {
            if (selected) {
                return StreamlinePlugin.getImage("AdvancedViewModeSelected.png");
            }
            return StreamlinePlugin.getImage("AdvancedViewMode.png");
        }

        private void toggleAdvancedViewMode() {
            this.filter.applyFilter(this.filterField.getPattern(), ((ToolItem)NullChecking.neverNull((Object)this.advancedMode)).getSelection());
        }

        public static interface Filter {
            public void applyFilter(Pattern var1, boolean var2);
        }
    }
}

