/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.cmdline;

import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.barmancfg.BarmanGenerator;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.xml.BarmanConfigurationXML;
import com.arm.streamline.cmdline.CaptureProcessor;
import com.arm.streamline.cmdline.CmdLineHelpFormatter;
import com.arm.streamline.cmdline.CmdLineMessages;
import com.arm.streamline.cmdline.CmdLineParser;
import com.arm.streamline.cmdline.OutputStreamWrappingReportPrintStream;
import com.arm.streamline.cmdline.ReportPrintStream;
import com.arm.streamline.cmdline.ReportProcessor;
import com.arm.streamline.cmdline.ValueReporting;
import com.arm.streamline.common.IErrorHandler;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.databrowser.IProgressObserver;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.browser.AdbTargetBrowser;
import com.arm.streamline.databrowser.browser.BrowseResult;
import com.arm.streamline.databrowser.browser.ConnectionType;
import com.arm.streamline.databrowser.browser.ITargetBrowserClient;
import com.arm.streamline.databrowser.browser.StdTargetBrowser;
import com.arm.streamline.databrowser.browser.TargetBrowserForwarder;
import com.arm.streamline.databrowser.trace_dump_import.TraceDumpImportClassification;
import com.arm.streamline.dataimport.IFileTypeChecker;
import com.arm.streamline.dataimport.ImportFileType;
import com.arm.streamline.dataimport.ImportJobFactory;
import com.arm.streamline.dataimport.OutputPathProvider;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbDevice;
import com.arm.streamline.deviceconn.adb.utils.AdbDeviceEnumeration;
import com.arm.streamline.deviceconn.adb.utils.AdbPackageEnumeration;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.streamline.utility.ThrowableUtils;
import com.arm.utils.IterUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CmdLine {
    private static final int EXIT_CODE_ERROR = 1;

    public static @Nullable String doCapture(CaptureProcessor capture, @NonNull List<@NonNull String> files, String configPath, @Nullable List<@NonNull String> templatePath, String outputPath, String retrieveImagesRegex, String username, String password, @Nullable String androidPackageName, @Nullable String androidActivityName, @Nullable String androidPackageFlags, boolean retrieveLibraries, boolean cleanGatord) throws Exception {
        StdLog.setBypass((boolean)true);
        capture.start(files, configPath, templatePath, outputPath, retrieveImagesRegex, retrieveLibraries, username, password, androidPackageName, androidActivityName, androidPackageFlags, cleanGatord);
        return null;
    }

    public static @Nullable String doGenerateBarmanSources(@NonNull List<@NonNull String> files, @Nullable String barmanConfigPath, @Nullable String barmanPmusXmlPath, @Nullable String barmanEventsXmlPath, @Nullable String barmanOutputPath) throws IOException, FileNotFoundException {
        if (!files.isEmpty()) {
            StdLog.setBypass((boolean)true);
            StringBuilder sb = new StringBuilder();
            for (String one : files) {
                sb.append(MessageFormat.format(CmdLineMessages.INVALID_OPTION, one));
                sb.append('\n');
            }
            sb.append(CmdLineMessages.TRY_HELP);
            return sb.toString();
        }
        if (barmanConfigPath == null) {
            StdLog.setBypass((boolean)true);
            return CmdLineMessages.MISSING_BARMAN_CONFIG_ARG;
        }
        if (barmanOutputPath == null) {
            StdLog.setBypass((boolean)true);
            return CmdLineMessages.MISSING_BARMAN_OUTPUT_ARG;
        }
        StdLog.setBypass((boolean)true);
        Map<Integer, ProcessorPmu> processorPmuConfigurations = BarmanGenerator.getProcessorPmuConfigurations(barmanConfigPath, barmanPmusXmlPath, barmanEventsXmlPath, BarmanGenerator.BARE_METAL_ALL_VALID_CLASSIFICATIONS);
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileInputStream configurationStream = new FileInputStream(barmanConfigPath);){
            BarmanConfiguration configuration = BarmanConfigurationXML.parse(configurationStream, processorPmuConfigurations, System.out::println);
            BarmanGenerator.generateBarmanFiles(true, false, configuration, new File(barmanOutputPath));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    public static @Nullable String doImport(@NonNull List<@NonNull String> files, @Nullable String outputPath, @Nullable String barmanXmlInputPath, @Nullable String agentImagePath, boolean importAsSynchronized, @NonNull ImportFileType importFileType) throws ImportJobFactory.ImportJobCreationException, InterruptedException {
        File outputFile;
        Collection importFiles;
        ImportJobFactory.IImportJobConfigurationSupplier barmanXmlSelector;
        List<Job> importJobs;
        final File barmanXmlFile = (File)NullChecking.applyIfNonNull((Object)barmanXmlInputPath, File::new);
        final File agentImageFile = (File)NullChecking.applyIfNonNull((Object)agentImagePath, File::new);
        if (agentImageFile != null) {
            boolean valid;
            boolean bl = valid = agentImageFile.exists() && agentImageFile.isFile() && FileUtils.isElfFile((File)agentImageFile);
            if (!valid) {
                return CmdLineMessages.INVALID_AGENT_IMAGE;
            }
        }
        if ((importJobs = ImportJobFactory.createImportJobs(barmanXmlSelector = new ImportJobFactory.IImportJobConfigurationSupplier(){

            @Override
            public @Nullable ImportJobFactory.ITraceDumpImportConfiguration selectTraceDumpImportConfiguration(@NonNull ITraceDumpDirectory directory, @NonNull Map<@NonNull TraceDumpImportClassification, @NonNull Collection<@NonNull ITraceSourceStreamWrapper>> classifications) throws ImportJobFactory.ImportJobCreationException {
                TraceDumpImportClassification classification;
                if (classifications.size() == 1) {
                    classification = (TraceDumpImportClassification)((Object)IterUtils.getNth(classifications.keySet(), (int)0));
                } else if (classifications.size() == 2 && classifications.containsKey((Object)TraceDumpImportClassification.BARMAN_ITM) && classifications.containsKey((Object)TraceDumpImportClassification.BARMAN_ITM_AGENTLESS_DWT)) {
                    classification = TraceDumpImportClassification.BARMAN_ITM;
                } else {
                    throw new AssertionError((Object)("Unexpected classifications: " + String.valueOf(classifications.keySet())));
                }
                switch (classification) {
                    case BARMAN_ITM: 
                    case BARMAN_ITM_AGENTLESS_DWT: 
                    case BARMAN_STM: {
                        if (barmanXmlFile != null) break;
                        return null;
                    }
                }
                return new ImportJobFactory.ITraceDumpImportConfiguration(){

                    @Override
                    public @NonNull ImportJobFactory.BarmanXmlAndAgentImage getBarmanXmlAndAgentImage() throws AssertionError {
                        return new ImportJobFactory.BarmanXmlAndAgentImage(barmanXmlFile, agentImageFile, null);
                    }

                    @Override
                    public @NonNull TraceDumpImportClassification getImportClassification() {
                        return classification;
                    }
                };
            }
        }, IFileTypeChecker.DEFAULT, importFiles = (Collection)files.stream().map(f -> new File((String)f)).collect(Collectors.toList()), outputFile = outputPath != null ? new File(outputPath) : OutputPathProvider.getApcOutputPath(), importFileType, importAsSynchronized)).isEmpty()) {
            return CmdLineMessages.MISSING_BARMAN_XML;
        }
        for (Job importJob : importJobs) {
            importJob.schedule();
            importJob.join();
            IStatus status = importJob.getResult();
            if (status.isOK()) continue;
            return status.getMessage();
        }
        return null;
    }

    public static @Nullable String doReport(@NonNull ReportProcessor report, @NonNull List<@NonNull String> files, @NonNull ValueReporting valueReporting, boolean defaultTemplate, @Nullable List<@NonNull String> templatePaths, @Nullable String outputPath, @Nullable String bookmarkStart, @Nullable String bookmarkStop, @NonNull ZoomLevel zoomLevel, double start, double stop, @NonNull Map<@NonNull String, @Nullable String> reportCallpathSourcesAndNames, @NonNull Map<@NonNull String, @Nullable String> reportFunctionSourcesAndNames, @Nullable String reportFilename_Log, @Nullable String reportFilename_Timeline, @Nullable String reportFilename_Cam, @Nullable String reportFilename_OpenCl, @Nullable String reportFilename_Bookmarks, @Nullable String reportFilename_Warnings, @NonNull Map<@NonNull String, @Nullable String> reportHeatmapSourcesAndNames, boolean averageHeatmapPerCore) throws Exception {
        boolean result;
        block16: {
            StdLog.setBypass((boolean)true);
            if (outputPath != null) {
                File outputDir = new File(outputPath);
                if (outputDir.exists() && outputDir.isFile()) {
                    String errorMessage = CmdLineMessages.MKDIR_FAILED_FILE_EXISTS;
                    throw new IOException(MessageFormat.format(errorMessage, outputDir.getAbsolutePath()));
                }
                try {
                    Throwable errorMessage = null;
                    Object var26_28 = null;
                    try (ReportPrintStream out = new ReportPrintStream(outputDir, reportCallpathSourcesAndNames, reportFunctionSourcesAndNames, reportFilename_Log, reportFilename_Timeline, reportFilename_Cam, reportFilename_OpenCl, reportFilename_Bookmarks, reportFilename_Warnings, reportHeatmapSourcesAndNames, report.getFormat());){
                        result = report.start(files, defaultTemplate, templatePaths, valueReporting, zoomLevel, start, stop, bookmarkStart, bookmarkStop, out, averageHeatmapPerCore);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        if (errorMessage == null) {
                            errorMessage = throwable;
                        } else if (errorMessage != throwable) {
                            errorMessage.addSuppressed(throwable);
                        }
                        throw errorMessage;
                    }
                }
                catch (IllegalArgumentException exception) {
                    throw exception;
                }
                catch (FileNotFoundException exception) {
                    throw new Exception(CmdLineMessages.UNABLE_TO_CREATE_OUTPUT);
                }
                catch (Exception exception) {
                    new File(outputPath).delete();
                    throw exception;
                }
            }
            if (reportCallpathSourcesAndNames.values().stream().anyMatch(s -> s != null) || reportFunctionSourcesAndNames.values().stream().anyMatch(s -> s != null) || reportFilename_Log != null || reportFilename_Timeline != null || reportFilename_Cam != null || reportFilename_OpenCl != null || reportFilename_Bookmarks != null || reportHeatmapSourcesAndNames.values().stream().anyMatch(s -> s != null)) {
                CmdLine.displayWarning(CmdLineMessages.REPORT_FILENAME_WAS_SPECIFIED_WITHOUT_OUTPUT_OPTION);
            }
            result = report.start(files, defaultTemplate, templatePaths, valueReporting, zoomLevel, start, stop, bookmarkStart, bookmarkStop, new OutputStreamWrappingReportPrintStream(System.out), averageHeatmapPerCore);
        }
        return result ? null : "Failed";
    }

    public static final @Nullable Integer processCommandLine(@NonNull String @NonNull [] args) {
        @NonNull String @NonNull [] additionalArgs = (String[])NullChecking.neverNull((Object[])Platform.getCommandLineArgs());
        return CmdLineParser.parse(args, additionalArgs, new CmdLineParser.ICommandLineHandler(){

            @Override
            public int analyze(@NonNull ResolutionMode resolutionMode, @NonNull List<@NonNull String> files) {
                boolean success = true;
                for (String fileName : files) {
                    File file = new File(fileName);
                    AnalysisRunner analysisRunner = new AnalysisRunner(file);
                    if (analysisRunner.run(resolutionMode)) continue;
                    success = false;
                }
                return CmdLine.setErrorIf(success ? null : CmdLineMessages.ANALYSIS_FAILED);
            }

            @Override
            public int capture(@Nullable String configPath, @Nullable Integer durationSeconds, boolean retrieveLibraries, @Nullable String retrieveImagesRegex, @Nullable String username, @Nullable String password, @Nullable List<@NonNull String> templatePath, @Nullable String outputPath, @Nullable String androidPackageName, @Nullable String androidActivityName, @Nullable String androidPackageFlags, @NonNull List<@NonNull String> files, boolean cleanGatord) {
                try {
                    CaptureProcessor capture = new CaptureProcessor();
                    if (durationSeconds != null) {
                        capture.setDuration(durationSeconds);
                    }
                    return CmdLine.setErrorIf(CmdLine.doCapture(capture, files, configPath, templatePath, outputPath, retrieveImagesRegex, username, password, androidPackageName, androidActivityName, androidPackageFlags, retrieveLibraries, cleanGatord));
                }
                catch (Exception exception) {
                    return CmdLine.setError(exception.getMessage());
                }
            }

            @Override
            public int error(@NonNull String message) {
                StdLog.setBypass((boolean)true);
                return CmdLine.setError(message);
            }

            @Override
            public int generateBareMetalAgent(@Nullable String configPath, @Nullable String eventsXmlPath, @Nullable String pmusXmlPath, @Nullable String outputPath, @NonNull List<@NonNull String> files) {
                try {
                    return CmdLine.setErrorIf(CmdLine.doGenerateBarmanSources(files, configPath, pmusXmlPath, eventsXmlPath, outputPath));
                }
                catch (Exception exception) {
                    return CmdLine.setError(exception.getMessage());
                }
            }

            @Override
            public int help(@NonNull List<@NonNull String> files) {
                StdLog.setBypass((boolean)true);
                CmdLine.printBanner();
                System.out.println(CmdLineHelpFormatter.getHelpMessage());
                return IApplication.EXIT_OK;
            }

            @Override
            public int importCapture(@NonNull ImportFileType type, @Nullable String agentImagePath, @Nullable String barmanXmlInputPath, boolean importAsSynchronized, @Nullable String outputPath, @NonNull List<@NonNull String> files) {
                try {
                    return CmdLine.setErrorIf(CmdLine.doImport(files, outputPath, barmanXmlInputPath, agentImagePath, importAsSynchronized, type));
                }
                catch (Exception exception) {
                    return CmdLine.setError(ThrowableUtils.getCompleteErrorMessage(exception));
                }
            }

            @Override
            public int launchPA(@NonNull List<@NonNull String> args) {
                Application performanceAdvisorApplication = new Application();
                return performanceAdvisorApplication.start(args);
            }

            @Override
            public int invalidArguments(@NonNull List<@NonNull String> invalidArguments) {
                StdLog.setBypass((boolean)true);
                StringBuilder sb = new StringBuilder();
                for (String one : invalidArguments) {
                    sb.append(MessageFormat.format(CmdLineMessages.INVALID_OPTION, one));
                    sb.append('\n');
                }
                sb.append(CmdLineMessages.TRY_HELP);
                return CmdLine.setError(sb.toString());
            }

            @Override
            public int report(@Nullable String bookmarkStart, @Nullable String bookmarkStop, double start, double stop, boolean dumpAll, boolean dumpBookmarks, boolean dumpCallPaths, boolean dumpCams, boolean dumpFunctions, boolean dumpIndividualThreads, boolean dumpLog, boolean dumpOpenCL, boolean dumpTimeline, boolean dumpWarnings, @Nullable String filenameBookmarks, @NonNull Map<@NonNull String, @Nullable String> callPathSourcesAndNames, @Nullable String filenameCams, @NonNull Map<@NonNull String, @Nullable String> functionSourcesAndNames, @Nullable String filenameLog, @Nullable String filenameOpenCL, @Nullable String filenameTimeline, @Nullable String filenameWarnings, @NonNull Map<@NonNull String, @Nullable String> heatmapSourcesAndNames, @NonNull Map<@NonNull String, @NonNull Pair<@Nullable String, @Nullable Set<@NonNull String>>> disasmSourcesAndImageNames, @NonNull ReportProcessor.Format format, @Nullable String processSpecifier, @Nullable String threadSpecifier, boolean defaultTemplate, @Nullable List<@NonNull String> templatePaths, @NonNull ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, @Nullable String outputPath, @NonNull List<@NonNull String> files, boolean averageHeatmapPerCore) {
                if (start != -1.0 && stop != -1.0 && start > stop) {
                    StdLog.setBypass((boolean)true);
                    return CmdLine.setError(CmdLineMessages.STOP_LESS_THAN_START);
                }
                try {
                    ReportProcessor report = new ReportProcessor();
                    report.setDumpBookmarks(dumpBookmarks || dumpAll);
                    report.setDumpCallPath(dumpCallPaths || dumpAll);
                    report.setDumpCAM(dumpCams || dumpAll);
                    report.setDumpFunctions(dumpFunctions || dumpAll);
                    report.setDumpHeatmap(dumpAll || !heatmapSourcesAndNames.isEmpty());
                    report.setDumpIndividualThreads(dumpIndividualThreads);
                    report.setDumpLog(dumpLog || dumpAll);
                    report.setDumpOpenCL(dumpOpenCL || dumpAll);
                    report.setDumpTimeline(dumpTimeline || dumpAll);
                    report.setDumpWarnings(dumpWarnings || dumpAll);
                    report.setFormat(format);
                    report.setHeatmapSources(heatmapSourcesAndNames.keySet());
                    report.setCallpathSources(callPathSourcesAndNames.keySet());
                    report.setFunctionSources(functionSourcesAndNames.keySet());
                    report.setProcessSpecifier(processSpecifier);
                    report.setThreadSpecifier(threadSpecifier);
                    report.setDisasmSourcesAndImageNames(disasmSourcesAndImageNames);
                    return CmdLine.setErrorIf(CmdLine.doReport(report, files, valueReporting, defaultTemplate, templatePaths, outputPath, bookmarkStart, bookmarkStop, zoomLevel, start, stop, callPathSourcesAndNames, functionSourcesAndNames, filenameLog, filenameTimeline, filenameCams, filenameOpenCL, filenameBookmarks, filenameWarnings, heatmapSourcesAndNames, averageHeatmapPerCore));
                }
                catch (Exception exception) {
                    return CmdLine.setError(exception.getMessage());
                }
            }

            @Override
            public int version(boolean detailed) {
                StdLog.setBypass((boolean)true);
                CmdLine.printBanner();
                return IApplication.EXIT_OK;
            }

            @Override
            public int generateConfig(@NonNull List<@NonNull String> templatePath, @NonNull TargetAddressString targetAddress, @Nullable String outputPath, boolean includeDefault) {
                try {
                    CaptureProcessor.generateConfiguration(templatePath, targetAddress, outputPath, includeDefault);
                }
                catch (IOException exception) {
                    return CmdLine.setError(exception.getMessage());
                }
                return IApplication.EXIT_OK;
            }

            @Override
            public int listDevices(@Nullable Integer networkWaitSeconds) {
                if (networkWaitSeconds == null) {
                    networkWaitSeconds = 1;
                }
                try {
                    File adb = StreamlinePreferences.getApplicationPreferences().getAdbPathOrDefault();
                    if (adb == null) {
                        return CmdLine.setError(CmdLineMessages.ADB_NOT_FOUND);
                    }
                    IAdbProcessRunner adbProcessRunner = AdbRunnerFactory.SINGLETON.create(adb);
                    final ArrayList<@NonNull BrowseResult> devices = new ArrayList<BrowseResult>();
                    TargetBrowserForwarder browser = new TargetBrowserForwarder(List.of(new AdbTargetBrowser(adbProcessRunner, true), new StdTargetBrowser(null)));
                    browser.addClient(new ITargetBrowserClient(){

                        @Override
                        public void removeDebugHardware(@NonNull BrowseResult removeHardware) {
                        }

                        @Override
                        public synchronized void foundNewDebugHardware(@NonNull BrowseResult newHardware) {
                            devices.add(newHardware);
                        }

                        @Override
                        public void debugHardwareSearchFailed(@NonNull String reason) {
                        }

                        @Override
                        public void beginBrowse(@NonNull ConnectionType connectionType) {
                        }

                        @Override
                        public void endBrowse(@NonNull ConnectionType connectionType) {
                        }
                    });
                    browser.startBrowsing(1, false);
                    Thread.sleep(networkWaitSeconds * 1000);
                    browser.closeBrowser();
                    return CmdLine.printDevices(devices);
                }
                catch (IOException | InterruptedException e) {
                    return CmdLine.setError(e.getMessage());
                }
            }

            @Override
            public int listPackages(@Nullable String device, boolean showAllPackages, boolean showActivities) {
                try {
                    AdbDevice selectedDevice;
                    File adb = StreamlinePreferences.getApplicationPreferences().getAdbPathOrDefault();
                    if (adb == null) {
                        return CmdLine.setError(CmdLineMessages.ADB_NOT_FOUND);
                    }
                    IAdbProcessRunner adbProcessRunner = AdbRunnerFactory.SINGLETON.create(adb);
                    Set availableDevices = Collections.unmodifiableSet(AdbDeviceEnumeration.enumerate((IAdbProcessRunner)adbProcessRunner).stream().filter(d -> d.getState() == AdbDevice.AdbDeviceState.AVAILABLE).collect(Collectors.toSet()));
                    if (device != null) {
                        Optional<AdbDevice> potentialDevice = availableDevices.stream().filter(d -> d.getSerialNo().equals(device)).findFirst();
                        if (potentialDevice.isEmpty()) {
                            return CmdLine.setError(CmdLineMessages.SELECTED_DEVICE_NOT_AVAILABLE);
                        }
                        selectedDevice = potentialDevice.get();
                    } else {
                        if (availableDevices.size() > 1) {
                            return CmdLine.setError(CmdLineMessages.NO_DEVICE_SPECIFIED);
                        }
                        if (availableDevices.isEmpty()) {
                            return CmdLine.setError(CmdLineMessages.NO_DEVICES_FOUND);
                        }
                        selectedDevice = (AdbDevice)availableDevices.iterator().next();
                    }
                    IAdbCommandRunner adbCommandRunner = AdbRunnerFactory.SINGLETON.create(adbProcessRunner, selectedDevice.getSerialNo());
                    return CmdLine.enumerateAndPrintPackages(adbCommandRunner, showAllPackages, showActivities);
                }
                catch (IOException e) {
                    return CmdLine.setError(e.getMessage());
                }
            }
        });
    }

    public static void printBanner() {
        System.out.println(StreamlinePlugin.getVersion().getLocalizedBanner());
    }

    public static int setError(@Nullable String message) {
        if (message == null || message.isEmpty()) {
            message = CmdLineMessages.UNKNOWN_ERROR;
        }
        System.err.printf("%s:%n%s%n", PluginMessages.ERROR, message);
        return 1;
    }

    protected static int setErrorIf(@Nullable String message) {
        if (message == null) {
            return IApplication.EXIT_OK;
        }
        return CmdLine.setError(message);
    }

    private static void displayWarning(@NonNull String message) {
        System.err.println(CmdLineMessages.WARNING + message + CmdLineMessages.CONTINUING);
    }

    public static int printDevices(@NonNull List<@NonNull BrowseResult> devices) {
        if (devices.isEmpty()) {
            System.out.print(CmdLineMessages.DEVICES_NO_DEVICES_FOUND);
            return 0;
        }
        int maxTargetLength = devices.stream().mapToInt(d -> d.getTargetAddressString().toString().length()).max().getAsInt();
        int maxStatusLength = Stream.of(CmdLineMessages.DEVICES_USABLE, CmdLineMessages.DEVICES_USABLE_GATORD, CmdLineMessages.DEVICES_UNAUTHORIZED).mapToInt(s -> s.length()).max().getAsInt();
        int deviceColumnWidth = maxTargetLength > CmdLineMessages.DEVICES_DEVICE_COLUMN_HEADING.length() ? maxTargetLength : CmdLineMessages.DEVICES_DEVICE_COLUMN_HEADING.length();
        System.out.print(CmdLineMessages.DEVICES_DEVICE_COLUMN_HEADING);
        System.out.print(" ".repeat(deviceColumnWidth - CmdLineMessages.DEVICES_DEVICE_COLUMN_HEADING.length()));
        System.out.print(" | ");
        System.out.println(CmdLineMessages.DEVICES_STATUS_COLUMN_HEADING);
        System.out.println(String.format("%s+%s", "-".repeat(deviceColumnWidth + 1), "-".repeat(maxStatusLength + 1)));
        for (BrowseResult device : devices) {
            System.out.print(device.getTargetAddressString());
            System.out.print(" ".repeat(deviceColumnWidth - device.getTargetAddressString().toString().length()));
            System.out.print(" | ");
            String status = !device.getAvailable() ? CmdLineMessages.DEVICES_UNAUTHORIZED : (device.isGatorRunning() ? CmdLineMessages.DEVICES_USABLE_GATORD : CmdLineMessages.DEVICES_USABLE);
            System.out.println(String.format("%s", status));
        }
        return 0;
    }

    public static int enumerateAndPrintPackages(@NonNull IAdbCommandRunner adbRunner, boolean showAllPackages, boolean showActivities) {
        try {
            AdbPackageEnumeration packageEnumerator = new AdbPackageEnumeration(adbRunner, () -> false);
            StringBuilder sb = new StringBuilder();
            Set packages = packageEnumerator.enumerate(false);
            if (showAllPackages) {
                sb.append(MessageFormat.format(CmdLineMessages.SELECTED_DEVICE, "all", adbRunner.getDeviceSerial()));
                sb.append(CmdLineMessages.DEBUGGABLE_PACKAGES_HEADING);
            } else {
                sb.append(MessageFormat.format(CmdLineMessages.SELECTED_DEVICE, "debuggable", adbRunner.getDeviceSerial()));
            }
            packages.stream().filter(p -> p.isDebuggable()).forEach(p -> {
                if (showActivities) {
                    p.getMainActivities().stream().forEach(a -> {
                        StringBuilder stringBuilder2 = sb.append(String.format("    pkg: %s  -  activity: %s%n", p.getPackageName(), a));
                    });
                } else {
                    sb.append(String.format("    %s%n", p.getPackageName()));
                }
            });
            if (showAllPackages) {
                sb.append(CmdLineMessages.NON_DEBUGGABLE_PACKAGES_HEADING);
                packages.stream().filter(p -> !p.isDebuggable()).forEach(p -> {
                    if (showActivities) {
                        p.getMainActivities().stream().forEach(a -> {
                            StringBuilder stringBuilder2 = sb.append(String.format("    pkg: %s  -  activity: %s%n", p.getPackageName(), a));
                        });
                    } else {
                        sb.append(String.format("    %s%n", p.getPackageName()));
                    }
                });
            }
            System.out.print(sb.toString());
            return 0;
        }
        catch (IOException e) {
            return CmdLine.setError(e.getMessage());
        }
    }

    private static class AnalysisRunner {
        private final @NonNull File apcDir;

        public AnalysisRunner(@NonNull File apcDir) {
            this.apcDir = apcDir;
        }

        public boolean run(@NonNull ResolutionMode resolutionMode) {
            System.err.println(MessageFormat.format(CmdLineMessages.PROCESSING, this.apcDir.getAbsolutePath()));
            IProgressObserver nullProgressObserver = new IProgressObserver(){

                @Override
                public void addToInProgress(@NonNull ICapture placeholder) {
                }

                @Override
                public void pause() {
                }

                @Override
                public void removeFromInProgress(@NonNull ICapture placeholder) {
                }

                @Override
                public void resume() {
                }
            };
            try {
                ICapture capture = ICapture.createCapture(this.apcDir);
                IAnalysisInputSettings settings = capture.getAnalysisSettings();
                settings.setResolutionMode(resolutionMode);
                capture.cleanDbAndReport();
                ErrorHandler printingErrorHandler = new ErrorHandler();
                capture.analyze(settings, new SessionProcessor(), capture, nullProgressObserver, printingErrorHandler, true);
                return !printingErrorHandler.seenError;
            }
            catch (Exception exception) {
                System.err.println(MessageFormat.format(CmdLineMessages.ANALYSIS_ERROR, exception.getMessage()));
                return false;
            }
        }
    }

    public static class ErrorHandler
    implements IErrorHandler {
        public boolean seenError = false;

        public void reportError(Throwable throwable) {
            System.err.println(MessageFormat.format(CmdLineMessages.ANALYSIS_ERROR, throwable.getMessage()));
            this.seenError = true;
        }
    }
}

