/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capture.builder.apc;

import com.arm.streamline.common.utility.io.Compression;
import com.arm.utils.datainput.LittleEndianDataOutput;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public class APCFrameBuilder {
    private final @NonNull ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public APCFrameBuilder() throws IOException {
    }

    public APCFrameBuilder(int code) throws IOException {
        this.writePacked32(code);
    }

    public @NonNull DataOutput asDataOutput() {
        return new LittleEndianDataOutput((OutputStream)this.buffer);
    }

    public byte @NonNull [] getData() {
        return this.buffer.toByteArray();
    }

    public int size() {
        return this.buffer.size();
    }

    public void write(byte @NonNull [] data) throws IOException {
        this.buffer.write(data);
    }

    public void writeCString(@NonNull String string) throws IOException {
        this.writeCString(string, true);
    }

    public void writeCString(@NonNull String string, boolean nullTerminate) throws IOException {
        int terminator = string.indexOf(0);
        byte[] data = (terminator < 0 ? string : string.substring(0, terminator - 1)).getBytes(StandardCharsets.UTF_8);
        assert (data.length == 0 || data[data.length - 1] != 0);
        this.buffer.write(data);
        if (nullTerminate) {
            this.buffer.write(0);
        }
    }

    public void writePacked32(int value) throws IOException {
        Compression.packInt((long)value, (OutputStream)this.buffer);
    }

    public void writePacked64(long value) throws IOException {
        Compression.packInt((long)value, (OutputStream)this.buffer);
    }

    public void writeString(String string) throws IOException {
        Compression.writeString((String)string, (OutputStream)this.buffer);
    }
}

