/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capture.astf;

import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.analysis.session.IDatabaseGenerator;
import com.arm.streamline.analysis.session.IFinalWriter;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.astf.xml.ASTFXml;
import com.arm.streamline.astf.xml.ASTFXmlUtility;
import com.arm.streamline.astf.xml.Messages;
import com.arm.streamline.capture.SimpleAnalysisSettings;
import com.arm.streamline.capture.apc.APCDatabaseGenerator;
import com.arm.streamline.capture.astf.ASTFCaptureDetails;
import com.arm.streamline.capture.astf.ASTFClustersInfo;
import com.arm.streamline.capture.astf.ASTFPartialCaptureDetails;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.IErrorHandler;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.Warnings;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.databrowser.Capture;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.IOpenable;
import com.arm.streamline.databrowser.IProgressObserver;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.model.StateFile;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.SampleRate;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.utility.io.ProgressTracker;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ASTFCapture
extends Capture {
    private static final String ATTR_STOP_TIME = "stop_time";
    private static final String ATTR_TIME_UNIT = "time_unit";
    private final @NonNull IAnalysisInputSettings mAnalysisSettings;
    private @Nullable LegalASTFCapture mLegalCapture = null;
    private @Nullable StateXml mStateXml = null;
    private @Nullable String mInvalidReason = null;
    private @Nullable ResolutionMode mResolutionMode = null;

    private ASTFCapture(@NonNull File apcDirectory, @NonNull LegalASTFCapture legalCapture, @Nullable StateXml stateXml) {
        super(apcDirectory);
        this.mAnalysisSettings = new SimpleAnalysisSettings(new File(apcDirectory, "report/analysis-settings.xml"), ResolutionMode.NORMAL, this);
        this.mLegalCapture = legalCapture;
        this.mStateXml = stateXml;
        this.updateResolutionMode();
    }

    private ASTFCapture(@NonNull File apcDirectory, @NonNull String invalidReason) {
        super(apcDirectory);
        this.mAnalysisSettings = new SimpleAnalysisSettings(new File(apcDirectory, "report/analysis-settings.xml"), ResolutionMode.NORMAL, this);
        this.mInvalidReason = invalidReason;
        this.updateResolutionMode();
    }

    public static Optional<ASTFCapture> tryCreateFor(@NonNull File apcDirectory) {
        File astfXmlFile = new File(apcDirectory, "astf-trace.xml");
        if (astfXmlFile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (XMLParser astfXmlParser = new XMLParser((InputStream)new FileInputStream(astfXmlFile));){
                    ASTFXml astfXml = ASTFXmlUtility.load(astfXmlParser);
                    if (astfXml == null) {
                        return Optional.of(new ASTFCapture(apcDirectory, MessageFormat.format(Messages.Error_ASTF_XML, "astf-trace.xml")));
                    }
                    ASTFClustersInfo clustersInfo = new ASTFClustersInfo(astfXml.getClusters());
                    File statexml = ASTFCapture.deriveStateXmlFile(apcDirectory);
                    if (statexml.exists()) {
                        StateXml stateXmlContents = ASTFCapture.readStateXml(statexml);
                        return Optional.of(new ASTFCapture(apcDirectory, new LegalASTFCapture(astfXml, clustersInfo, apcDirectory), stateXmlContents));
                    }
                    return Optional.of(new ASTFCapture(apcDirectory, new LegalASTFCapture(astfXml, clustersInfo, apcDirectory), null));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                return Optional.of(new ASTFCapture(apcDirectory, ASTFCapture.ensureNonNullErrorMessage(e)));
            }
        }
        return Optional.empty();
    }

    @Override
    public void analyze(@NonNull IAnalysisInputSettings settings, @NonNull SessionProcessor sessionProcessor, @Nullable IOpenable openable, @NonNull IProgressObserver progressObserver, @NonNull IErrorHandler errorHandler, boolean openResult) {
        IDatabaseGenerator dbGenerator = new IDatabaseGenerator(){
            private final APCDatabaseGenerator apcDbGenerator = new APCDatabaseGenerator();

            @Override
            public void stop() {
                this.apcDbGenerator.stop();
            }

            @Override
            public boolean generateDatabase(@NonNull IAnalysisInputSettings analysisSettings, @NonNull String capturePath, @NonNull ICaptureDetails captureDetails, @NonNull IClustersInfo clustersInfo, @NonNull SessionProcessor sessionProcessor, ICaptureProxy proxy, @NonNull IAnalysisHandler handler, @NonNull AttachedApkEntries attachedApkEntries) throws IOException, Exception {
                boolean result = this.apcDbGenerator.generateDatabase(analysisSettings, capturePath, captureDetails, clustersInfo, sessionProcessor, proxy, handler, attachedApkEntries);
                ASTFCapture.this.reCheckStateXml();
                return result;
            }
        };
        try {
            LegalASTFCapture legalCap = (LegalASTFCapture)NullChecking.neverNull((Object)this.mLegalCapture);
            @NonNull ASTFCaptureDetails localCaptureDetails = legalCap.getCaptureDetails().withTimeUnit(() -> {
                if (this.mStateXml != null) {
                    return this.mStateXml.getTimeUnit();
                }
                CommonPlugin.warning((String)("db/state.xml has not been parsed, so no definite value for the time_unit.  Guessing 'cycles' for time_unit of " + String.valueOf(this.getApcDirectory())));
                return TimeUnit.MILLI_CYCLES;
            });
            @NonNull ASTFClustersInfo clustersInfo = legalCap.getClustersInfo();
            this.setStopHandler(sessionProcessor, progressObserver);
            @NonNull File reportDir = new File(this.getApcDirectory(), "report");
            String outputPath = (String)NullChecking.neverNull((Object)reportDir.getAbsolutePath());
            String capturePath = (String)NullChecking.neverNull((Object)this.getApcDirectory().getAbsolutePath());
            @NonNull Warnings captureWarnings = new Warnings();
            IFinalWriter finalWriter = new IFinalWriter(){

                @Override
                public void writeXML(@NonNull String outputPath) {
                    try {
                        ASTFCapture.this.mAnalysisSettings.save();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            try {
                boolean durationLimitInSecs = false;
                TargetAddressString targetAddress = null;
                SampleRate sampleRate = null;
                sessionProcessor.produceReport((IAnalysisInputSettings)NullChecking.neverNull((Object)this.mAnalysisSettings), capturePath, outputPath, true, (IWarnings)captureWarnings, clustersInfo, localCaptureDetails, finalWriter, dbGenerator, 0, targetAddress, sampleRate, this, openable, progressObserver, openResult, this.getResolutionMode());
                this.updateResolutionMode();
            }
            catch (Throwable throwable) {
                errorHandler.reportError(throwable);
            }
        }
        finally {
            progressObserver.removeFromInProgress(this);
        }
    }

    private static @NonNull StateXml readStateXml(@NonNull File stateFile) throws Exception {
        String rootTag = "state";
        String stateTimeUnit = null;
        TimeUnit timeunit = null;
        long duration = -1L;
        Throwable throwable = null;
        Object var7_7 = null;
        try (XMLParser parser = XMLParser.create((File)stateFile);){
            String tag = null;
            while ((tag = parser.nextTag()) != null) {
                if (!tag.equals(rootTag)) continue;
                stateTimeUnit = parser.getAttribute(ATTR_TIME_UNIT);
                duration = parser.getLongAttribute(ATTR_STOP_TIME, -1L);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (stateTimeUnit == null) {
            throw new Exception(MessageFormat.format(Messages.Error_Field_Missing_From_StateXML, ATTR_TIME_UNIT));
        }
        timeunit = ASTFCapture.parseTimeUnit(stateTimeUnit);
        if (duration == -1L) {
            throw new Exception(MessageFormat.format(Messages.Error_Field_Missing_From_StateXML, ATTR_STOP_TIME));
        }
        return new StateXml(timeunit, duration);
    }

    private static @NonNull TimeUnit parseTimeUnit(@NonNull String stateTimeUnit) throws Exception {
        switch (stateTimeUnit) {
            case "cycles": {
                return TimeUnit.MILLI_CYCLES;
            }
            case "nanoseconds": {
                return TimeUnit.NANO_SECONDS;
            }
        }
        throw new Exception(MessageFormat.format(Messages.Error_Illegal_Time_Unit, stateTimeUnit));
    }

    private static @NonNull File deriveStateXmlFile(@NonNull File apcDir) {
        File dbDir = new File(apcDir, "db");
        File stateFile = new File(dbDir, "state.xml");
        return stateFile;
    }

    private void reCheckStateXml() {
        try {
            File stateFile = ASTFCapture.deriveStateXmlFile(this.getApcDirectory());
            if (stateFile.exists()) {
                this.mStateXml = ASTFCapture.readStateXml(stateFile);
            } else {
                this.mInvalidReason = "Database state file is expected to exist, but was not found: " + String.valueOf(stateFile);
            }
        }
        catch (Exception ex) {
            this.mInvalidReason = ASTFCapture.ensureNonNullErrorMessage(ex);
        }
    }

    private static @NonNull String ensureNonNullErrorMessage(@NonNull Exception ex) {
        String message = ex.getMessage();
        if (message != null) {
            return message;
        }
        return "Exception occurred " + ex.getClass().getCanonicalName();
    }

    @Override
    public @NonNull IAnalysisInputSettings getAnalysisSettings() {
        return this.mAnalysisSettings;
    }

    @Override
    public long getCreatedOnSeconds() {
        if (this.mLegalCapture != null) {
            return this.mLegalCapture.getAstfXml().getCreatedOnMillis() / 1000L;
        }
        return -1L;
    }

    @Override
    public long getDurationInTimeUnits() {
        if (this.mStateXml != null) {
            return this.mStateXml.getDuration();
        }
        return -1L;
    }

    @Override
    public @Nullable TimeUnit getTimeUnit() {
        if (this.mStateXml != null) {
            return this.mStateXml.getTimeUnit();
        }
        return null;
    }

    @Override
    public @NonNull String getHumanReadableVersion() {
        return "";
    }

    @Override
    public @Nullable String getInvalidReason() {
        return this.mInvalidReason;
    }

    @Override
    public @Nullable ProtocolInfo getProtocolInfo() {
        if (this.mLegalCapture != null) {
            return this.mLegalCapture.getCaptureDetails().getProtocolInfo();
        }
        return null;
    }

    private void updateResolutionMode() {
        this.mResolutionMode = null;
        try {
            StateFile stateFile = StateFile.load(new File(this.getApcDirectory(), "report"), new ProgressTracker());
            if (stateFile.isVersionValid()) {
                this.mResolutionMode = stateFile.getResolution();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public @Nullable ResolutionMode getResolutionMode() {
        return this.mResolutionMode;
    }

    @Override
    public @NonNull SampleRate getSampleRate() {
        return SampleRate.HIGH;
    }

    @Override
    public @NonNull String getTargetDescription() {
        return "target description";
    }

    @Override
    public boolean isDataMissing() {
        return false;
    }

    @Override
    public boolean isJitDumpProfilingSupported() {
        return false;
    }

    @Override
    public boolean isShouldAlwaysDeleteDB() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.mInvalidReason == null;
    }

    @Override
    public boolean usesEBS() {
        return false;
    }

    private static class LegalASTFCapture {
        private final @NonNull ASTFPartialCaptureDetails mCaptureDetails;
        private final @NonNull ASTFClustersInfo mClustersInfo;
        private final @NonNull ASTFXml mAstfXml;

        public LegalASTFCapture(@NonNull ASTFXml xml, @NonNull ASTFClustersInfo clustersInfo, @NonNull File apcDirectory) {
            this.mAstfXml = xml;
            this.mClustersInfo = clustersInfo;
            this.mCaptureDetails = new ASTFPartialCaptureDetails(xml.getAstfFolderName(), apcDirectory.getAbsolutePath(), 10000L);
        }

        public @NonNull ASTFPartialCaptureDetails getCaptureDetails() {
            return this.mCaptureDetails;
        }

        public @NonNull ASTFClustersInfo getClustersInfo() {
            return this.mClustersInfo;
        }

        public @NonNull ASTFXml getAstfXml() {
            return this.mAstfXml;
        }
    }

    private static class StateXml {
        private final @NonNull TimeUnit mTimeUnit;
        private final long mDuration;

        public StateXml(@NonNull TimeUnit timeUnit, long duration) {
            this.mTimeUnit = timeUnit;
            this.mDuration = duration;
        }

        public @NonNull TimeUnit getTimeUnit() {
            return this.mTimeUnit;
        }

        public long getDuration() {
            return this.mDuration;
        }
    }
}

