/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capture.apc;

import com.arm.streamline.analysis.database.api.profiling.BacktraceSource;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseFactory;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.databrowser.AbstractDatabaseGenerator;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.jni.apcdbgen.AnalysisOptions;
import com.arm.streamline.jni.apcdbgen.AnalysisResult;
import com.arm.streamline.jni.apcdbgen.ApcDbGenerator;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.protocol.capture.apc.io.APCFrame;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameStream;
import com.arm.streamline.protocol.capture.apc.pass_one.IAPCPassOne;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.utility.HandlerProgressMonitor;
import com.arm.streamline.utility.HandlerProgressMonitorFactory;
import com.arm.utils.NullChecking;
import com.arm.utils.function.ICloseableThrowingRunnable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class APCDatabaseGenerator
extends AbstractDatabaseGenerator {
    private @Nullable ApcDbGenerator mApcDbGenerator = null;

    @Override
    public void stop() {
        super.stop();
        if (this.mApcDbGenerator != null) {
            this.mApcDbGenerator.cancel();
        }
    }

    public static @NonNull ICloseableThrowingRunnable<IOException> createLiveProcessor(@NonNull IAPCCaptureFrameStream frameStream, @Nullable IAPCPassOne livePassOne) {
        return new LiveAPCDatabaseGeneratorProcessorV3(frameStream, livePassOne);
    }

    public static @NonNull IBacktraceSource findBacktraceSource(@NonNull List<@NonNull CounterRecord> counterRecordList) {
        @Nullable String ebsCounterBacktraceSourceName = counterRecordList.stream().map(StaticCounterSeriesKey::new).map(StaticCounterSeriesKey::getBacktraceSourceNameIfEbsCounter).filter(name -> name != null).findFirst().orElse(null);
        return ebsCounterBacktraceSourceName != null ? BacktraceSource.ebs((String)ebsCounterBacktraceSourceName) : IBacktraceSource.PERIODIC_SAMPLES;
    }

    private boolean processRecordsV3(@NonNull File apcDirectory, @NonNull IAnalysisHandler handler, boolean processDebugInfo) throws Exception {
        boolean wasModified;
        long before = System.nanoTime();
        HandlerProgressMonitorFactory progressMonitorFactory = new HandlerProgressMonitorFactory(handler, apcDirectory);
        try {
            this.mApcDbGenerator = new ApcDbGenerator(new AnalysisOptions(true, true, true, true, processDebugInfo, null), apcDirectory, Task.getExecutorService(), (IProgressMonitorFactory)progressMonitorFactory);
            AnalysisResult result = this.mApcDbGenerator.generateDb();
            if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                System.out.printf("RESULT IS: %s (%s)%n", result.getResultCode(), result.isSuccessful());
            }
            if (!result.isSuccessful()) {
                switch (result.getResultCode()) {
                    case success: {
                        break;
                    }
                    case cancelled: {
                        throw new InterruptedException();
                    }
                    case failed_to_create_db_directory: {
                        throw new IOException("Failed to create db directory within " + String.valueOf(apcDirectory));
                    }
                    case invalid_capture_path: {
                        throw new IOException("Invalid capture path " + String.valueOf(apcDirectory));
                    }
                    case unsupported_protocol_type: {
                        throw new IOException("Invalid protocol type in " + String.valueOf(apcDirectory));
                    }
                    case unsupported_protocol_version: {
                        throw new IOException("Invalid protocol version in " + String.valueOf(apcDirectory));
                    }
                    case time_stamps_missing_for_multi_core_files: {
                        throw new IOException("Trace files in multi core ASTF import are missing timestamp records");
                    }
                    default: {
                        throw new AssertionError(result.getResultCode());
                    }
                }
            }
            wasModified = result.isNewlyGenerated();
        }
        catch (HandlerProgressMonitor.AsyncInterruptedException e) {
            throw new InterruptedException();
        }
        catch (Throwable t) {
            if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING && !(t instanceof InterruptedException)) {
                System.out.printf("FAILED WITH: %s (%s)%n", t.getClass(), t.getMessage());
                t.printStackTrace();
            }
            throw t;
        }
        long afterDb = System.nanoTime();
        long deltaDb = afterDb - before;
        if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
            System.out.printf("CUMULATIVE TOTAL TIME: %d.%09d%n", deltaDb / 1000000000L, deltaDb % 1000000000L);
        }
        return wasModified;
    }

    @Override
    protected boolean processRecords(IAnalysisInputSettings analysisSettings, boolean generateSpeSampleLog, @NonNull String capturePath, @NonNull ICaptureDetails captureDetails, @NonNull IClustersInfo clustersInfo, @NonNull SessionProcessor sessionProcessor, ICaptureProxy proxy, IAnalysisHandler handler, @NonNull AttachedApkEntries attachedApkEntries) throws Exception {
        return this.processRecordsV3(new File(capturePath), handler, analysisSettings.isParseDebugInfoEnabled());
    }

    private static final class LiveAPCDatabaseGeneratorProcessorV3
    implements ICloseableThrowingRunnable<IOException> {
        private final @NonNull IAPCCaptureFrameStream frameStream;
        private final @Nullable IAPCPassOne livePassOne;

        public LiveAPCDatabaseGeneratorProcessorV3(@NonNull IAPCCaptureFrameStream frameStream, @Nullable IAPCPassOne livePassOne) {
            this.frameStream = frameStream;
            this.livePassOne = livePassOne;
        }

        public void close() throws IOException {
            if (this.livePassOne != null) {
                this.livePassOne.close();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() throws IOException {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                IAPCPassOne apcPassOne = (IAPCPassOne)NullChecking.neverNullOrCreate((Object)this.livePassOne, () -> new NullPassOne());
                try {
                    try (IAPCCaptureFrameStream frameStream = this.frameStream;){
                        IAPCPassOne.process((IAPCCaptureFrameStream)frameStream, (IAPCPassOne)apcPassOne);
                    }
                    if (apcPassOne == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (apcPassOne == null) throw throwable;
                    apcPassOne.close();
                    throw throwable;
                }
                apcPassOne.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private static final class NullPassOne
    implements IAPCPassOne {
        private NullPassOne() {
        }

        public void close() throws IOException {
        }

        public void consumeNextFrame(@NonNull APCFrame frame) throws IOException {
        }

        public void flushDelayedFrames() throws IOException {
        }
    }
}

