/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capture.apc;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.UserFriendlyIOException;
import com.arm.streamline.analysis.database.ZeroLengthCaptureException;
import com.arm.streamline.analysis.gator.BacktraceProcessing;
import com.arm.streamline.analysis.gator.GatorCapturedRawXML;
import com.arm.streamline.analysis.gator.GatorCapturedXML;
import com.arm.streamline.analysis.gator.GatorProtocolVerifier;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.analysis.session.IFinalWriter;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.capture.apc.APCDatabaseGenerator;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.IErrorHandler;
import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.InvalidVersionException;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.counterconfig.model.CounterNames;
import com.arm.streamline.databrowser.Capture;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.ElfImage;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.IOpenable;
import com.arm.streamline.databrowser.IProgressObserver;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.jni.elfdwarf.ElfDwarfParser;
import com.arm.streamline.model.StateFile;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.SampleRate;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.report.model.topology.GatorClusters;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.topology.XmlClustersInfo;
import com.arm.streamline.utility.io.ProgressTracker;
import com.arm.utils.NullChecking;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class APCCapture
extends Capture
implements ILiveCapture {
    public static final String COUNTERS_FILENAME = "counters.xml";
    public static final String EVENTS_FILENAME = "events.xml";
    public static final String SESSION_FILENAME = "session.xml";
    private static final String TARGET_DESCRIPTION_SEPARATOR = " - ";
    private long mCreatedOn = -1L;
    private boolean mDataMissing;
    private long mDuration = -1L;
    private boolean mEBS;
    private @Nullable String mInvalidReason;
    private boolean mIsPlaceholder;
    private @Nullable ProtocolInfo mProtocolInfo;
    private @Nullable ResolutionMode mResolutionMode = null;
    private @NonNull SampleRate mSampleRate = (SampleRate)((Object)NullChecking.neverNull((Object)((Object)SampleRate.DEFAULT)));
    private @NonNull String mTargetDescription = "";
    private @Nullable String mTargetOs;
    private boolean mIsPerfImport;
    private boolean mValid;

    public static boolean containsActive64BitImage(Set<ElfImage> mImages) {
        for (ElfImage image : mImages) {
            try {
                if (!ElfDwarfParser.is64Bit((File)image.getFile())) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static int @NonNull [] extractTargetCoreCPUIDs(@NonNull GatorCapturedRawXML capturedRawXML, @NonNull CounterNames counterNames) {
        return APCCapture.extractCPUIDs(capturedRawXML.getCpuId(), capturedRawXML.getBacktraceProcessing(), capturedRawXML.getCounterList(), counterNames, counterNames.getClusterNames().valueCollection());
    }

    protected static int @NonNull [] extractCPUIDs(int defaultCPUID, @NonNull BacktraceProcessing backtraceProcessing, @NonNull Collection<@NonNull CounterRecord> capturedRawXMLCounters, @NonNull Collection<@NonNull String> counterNames, @NonNull Collection<@NonNull String> clusterNames) {
        @NonNull HashSet<E> archNames = new HashSet();
        capturedRawXMLCounters.stream().map(CounterRecord::getCounter).map(ClusterNameUtils::getArchName).filter(NullChecking::isNotNull).forEach(archNames::add);
        counterNames.stream().map(ClusterNameUtils::getArchName).filter(NullChecking::isNotNull).forEach(archNames::add);
        clusterNames.stream().map(ClusterNameUtils::getArchName).filter(NullChecking::isNotNull).forEach(archNames::add);
        archNames.remove("Other");
        TIntHashSet cpuids = new TIntHashSet();
        archNames.stream().map(APCCapture::extractCPUIDs).filter(NullChecking::isNotNull).flatMapToInt(Arrays::stream).forEach(arg_0 -> ((TIntSet)cpuids).add(arg_0));
        if (defaultCPUID != 0) {
            cpuids.add(defaultCPUID);
        }
        cpuids.remove(1048575);
        cpuids.remove(-1);
        cpuids.remove(0);
        int @NonNull [] result = cpuids.toArray();
        return result;
    }

    private static int @NonNull [] extractCPUIDs(String archName) {
        return EventsAndPmusXml.BUILT_PMU.stream().filter(pmu -> pmu.getId().equals(archName) || pmu.getCoreName().equals(archName) || pmu.getCounterSet().equals(archName)).map(ProcessorPmu::getCpuids).flatMapToInt(Arrays::stream).distinct().toArray();
    }

    private static @NonNull File formatFile(@NonNull File file) {
        if (file.getName().equalsIgnoreCase("report")) {
            file = (File)NullChecking.neverNull((Object)file.getParentFile());
        }
        return (File)NullChecking.neverNull((Object)file.getAbsoluteFile());
    }

    private static @NonNull Collection<@NonNull SpeTargetDescription> getSpeTargetDescriptions(String capturePath) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream fs = new FileInputStream(new File(capturePath, EVENTS_FILENAME));){
                return Events.createWithAllEventsWithoutClusterInfo((InputStream)fs).getAvailableSpeTargetDescriptions();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Collections.emptyList();
        }
    }

    private static @NonNull Map<String, StockCounter> getStockCountersMap(String capturePath) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream fs = new FileInputStream(new File(capturePath, EVENTS_FILENAME));){
                return Events.createWithAllEventsWithoutClusterInfo((InputStream)fs).getStockCounterMap();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Collections.emptyMap();
        }
    }

    public APCCapture(@NonNull File dir) {
        super(APCCapture.formatFile(dir));
        this.validate();
    }

    @Override
    public void analyze(@NonNull IAnalysisInputSettings analysisSettings, @NonNull SessionProcessor sessionProcessor, @Nullable IOpenable captureToOpen, @NonNull IProgressObserver documentsScanner, @NonNull IErrorHandler errorHandler, boolean openResult) {
        try {
            @NonNull File reportDir = new File(this.getApcDirectory(), "report");
            String outputPath = (String)NullChecking.neverNull((Object)reportDir.getAbsolutePath());
            String capturePath = (String)NullChecking.neverNull((Object)this.getApcDirectory().getAbsolutePath());
            APCDatabaseGenerator dbGenerator = new APCDatabaseGenerator();
            this.setStopHandler(sessionProcessor, documentsScanner);
            try {
                ProtocolInfo protocolInfo = this.mProtocolInfo;
                if (!this.mIsPerfImport && protocolInfo != null && protocolInfo.getRawProtocolVersion() >= 840) {
                    File eventsXml = new File(capturePath, EVENTS_FILENAME);
                    APCCapture.checkEventsXml(eventsXml);
                }
                this.doIfValidCaptureSettings(analysisSettings, capturePath, (session, is64Bit, counterNames, captureDetails) -> {
                    @NonNull IWarnings warnings = counterNames.getOtherWarnings();
                    List<@NonNull CounterRecord> counterRecordList = captureDetails.getCounterList();
                    GatorClusters gatorClusters = new GatorClusters(counterNames.getClusterNames(), counterNames.getCpuClusterIds());
                    XmlClustersInfo clustersInfo = new XmlClustersInfo(gatorClusters, (List)counterNames, counterRecordList, captureDetails.getNumberOfCores());
                    clustersInfo.updateCounterRecordsWithClusterInformation(counterRecordList);
                    GatorCapturedXML.checkCounterAliasesDuplicates(counterRecordList);
                    IFinalWriter finalWriter = new IFinalWriter(){

                        @Override
                        public void writeXML(@NonNull String outputPath) {
                        }
                    };
                    int durationLimitInSecs = session.getDurationLimitInSecs();
                    @NonNull TargetAddressString targetAddress = session.getTargetAddress();
                    @NonNull SampleRate sampleRate = session.getSampleRate();
                    sessionProcessor.produceReport(analysisSettings, capturePath, outputPath, is64Bit, warnings, (IClustersInfo)clustersInfo, captureDetails, finalWriter, dbGenerator, durationLimitInSecs, targetAddress, sampleRate, this, captureToOpen, documentsScanner, openResult, this.mResolutionMode);
                    return Boolean.TRUE;
                });
            }
            catch (ZeroLengthCaptureException e) {
                try {
                    this.writeErrorIntoCapture(AnalysisMessages.ZERO_DURATION);
                }
                catch (IOException ex) {
                    CommonPlugin.error((Throwable)ex);
                }
                errorHandler.reportError((Throwable)new UserFriendlyIOException(AnalysisMessages.ZERO_DURATION));
            }
            catch (Throwable throwable) {
                errorHandler.reportError(throwable);
            }
        }
        finally {
            documentsScanner.removeFromInProgress(this);
        }
    }

    private <T> @NonNull Optional<T> doIfValidCaptureSettings(@NonNull IAnalysisInputSettings analysisSettings, @NonNull String capturePath, @NonNull RunIfValid<T> func) throws Throwable {
        Optional<GatorCapturedXML> maybeCaptureDetails;
        if (!(analysisSettings instanceof Session)) {
            return Optional.empty();
        }
        Session session = (Session)analysisSettings;
        boolean is64Bit = this.is64Bit(session);
        CounterNames counterNames = new CounterNames();
        File captureFile = new File(capturePath, COUNTERS_FILENAME);
        if (captureFile.exists() && captureFile.isFile()) {
            Throwable throwable = null;
            Object var9_10 = null;
            try (FileInputStream fs = new FileInputStream(captureFile);){
                counterNames.load(fs);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if ((maybeCaptureDetails = this.buildCaptureDetails(counterNames, capturePath)).isEmpty()) {
            return Optional.empty();
        }
        GatorCapturedXML captureDetails = maybeCaptureDetails.get();
        T result = func.run(session, is64Bit, counterNames, captureDetails);
        return result == null ? Optional.empty() : Optional.of(result);
    }

    private Optional<GatorCapturedXML> buildCaptureDetails(@NonNull CounterNames counterNames, @NonNull String capturePath) throws IOException {
        Map<String, StockCounter> stockCounterMap = APCCapture.getStockCountersMap(capturePath);
        @NonNull Collection<@NonNull SpeTargetDescription> speTargetDescription = APCCapture.getSpeTargetDescriptions(capturePath);
        @NonNull CaptureSubType captureSubType = GatorCapturedRawXML.getCaptureSubType(this.mTargetOs);
        @NonNull GatorCapturedXML captureDetails = new GatorCapturedXML(capturePath, captureSubType, GatorProtocolVerifier.ANALYSIS_EXCEPTION_FACTORY, stockCounterMap, speTargetDescription, counterNames.hasArmNNCounters());
        return Optional.of(captureDetails);
    }

    @Override
    public void convertPlaceholderToFinal() {
        if (this.mValid) {
            this.validate();
            if (this.mValid && this.hasReport(true)) {
                DocumentScanner.INSTANCE.removePlaceholder(this);
                this.openAsync();
            }
        }
    }

    @Override
    public @NonNull IAnalysisInputSettings getAnalysisSettings() {
        return (IAnalysisInputSettings)NullChecking.neverNullOrCreate((Object)this.getPreviousAnalysisSettings(), Session::new);
    }

    private @Nullable IAnalysisInputSettings getPreviousAnalysisSettings() {
        try {
            @NonNull File sessionFile = new File(this.getApcDirectory(), SESSION_FILENAME);
            return new Session(sessionFile, true);
        }
        catch (IOException exception) {
            return null;
        }
    }

    @Override
    public long getCreatedOnSeconds() {
        return this.mCreatedOn;
    }

    @Override
    public long getDurationInTimeUnits() {
        return this.mDuration;
    }

    @Override
    public @NonNull String getHumanReadableVersion() {
        ProtocolInfo mProtocolInfo = this.mProtocolInfo;
        if (mProtocolInfo != null) {
            return mProtocolInfo.getHumanReadableVersion();
        }
        return "";
    }

    @Override
    public @Nullable String getInvalidReason() {
        return this.mInvalidReason;
    }

    @Override
    public @Nullable ProtocolInfo getProtocolInfo() {
        return this.mProtocolInfo;
    }

    @Override
    public @Nullable ResolutionMode getResolutionMode() {
        return this.mResolutionMode;
    }

    @Override
    public @NonNull SampleRate getSampleRate() {
        return this.mSampleRate;
    }

    @Override
    public @NonNull String getTargetDescription() {
        return this.mTargetDescription;
    }

    @Override
    public @Nullable TimeUnit getTimeUnit() {
        return TimeUnit.NANO_SECONDS;
    }

    @Override
    public boolean isCapturing() {
        return this.mStopHandler != null ? this.mStopHandler.isCapturing() : false;
    }

    @Override
    public boolean isDataMissing() {
        return this.mDataMissing;
    }

    @Override
    public boolean isJitDumpProfilingSupported() {
        @Nullable ProtocolInfo mProtocolInfo = this.mProtocolInfo;
        return mProtocolInfo != null && mProtocolInfo.getType() == ProtocolType.PERF;
    }

    @Override
    public boolean isPlaceholder() {
        return this.mIsPlaceholder;
    }

    @Override
    public boolean isShouldAlwaysDeleteDB() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.mValid;
    }

    @Override
    public void setAsPlaceholder() {
        if (this.mStopHandler != null) {
            DocumentScanner.INSTANCE.addPlaceholder(this);
            this.mIsPlaceholder = true;
        }
    }

    @Override
    public void setFile(@NonNull File file) {
        super.setFile(APCCapture.formatFile(file));
    }

    @Override
    public boolean usesEBS() {
        return this.mEBS;
    }

    public static void checkEventsXml(File eventsXml) throws FileNotFoundException {
        if (!(eventsXml.exists() && eventsXml.isFile() && eventsXml.canRead())) {
            throw new FileNotFoundException(String.format("Invalid capture, analysis stopped.\nReason: %s is not found/accessible.", eventsXml));
        }
    }

    public void validate() {
        TargetAddressString targetAddress = null;
        String targetName = null;
        this.mCreatedOn = -1L;
        this.mDuration = -1L;
        this.mValid = false;
        try {
            Session captureInputSettings;
            try {
                captureInputSettings = new Session(new File(this.getApcDirectory(), SESSION_FILENAME), true);
            }
            catch (FileNotFoundException fnf) {
                captureInputSettings = new Session();
            }
            this.mSampleRate = captureInputSettings.getSampleRate();
            targetAddress = captureInputSettings.getTargetAddress();
        }
        catch (Exception captureInputSettings) {
            // empty catch block
        }
        File capturedFile = new File(this.getApcDirectory(), "captured.xml");
        GatorCapturedRawXML capturedXML = null;
        this.mDataMissing = false;
        if (CommonFileUtils.exists((File)capturedFile)) {
            try {
                Throwable throwable = null;
                Object var6_11 = null;
                try (XMLParser parser = new XMLParser((InputStream)new FileInputStream(capturedFile));){
                    capturedXML = GatorCapturedRawXML.read(parser);
                    this.mCreatedOn = capturedXML.getCreated();
                    this.mTargetOs = capturedXML.getOs();
                    this.mIsPerfImport = capturedXML.isPerfImport();
                    this.mDuration = 0L;
                    @NonNull ProtocolInfo protocolInfo = this.mProtocolInfo = capturedXML.getProtocolInfo();
                    boolean bl = this.mValid = capturedXML.getError() == null;
                    if (!this.mValid) {
                        this.mInvalidReason = capturedXML.getError();
                    } else {
                        try {
                            GatorProtocolVerifier.verifyCaptureProtocol(protocolInfo, GatorProtocolVerifier.ANALYSIS_EXCEPTION_FACTORY);
                        }
                        catch (InvalidVersionException ioe) {
                            this.mValid = false;
                            this.mInvalidReason = ioe.getMessage();
                        }
                    }
                    targetName = capturedXML.getName();
                    for (CounterRecord counter : capturedXML.getCounterList()) {
                        if (counter.getEventCount() <= 0) continue;
                        this.mEBS = true;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        } else {
            this.mInvalidReason = String.format(DocumentsMessages.CAPTURE_NOT_FOUND, capturedFile);
            this.mDataMissing = true;
        }
        if (this.mValid && this.hasReport(true)) {
            try {
                StateFile stateFile = StateFile.load(new File(this.getApcDirectory(), "report"), new ProgressTracker());
                this.mDuration = stateFile.getDuration();
                this.mResolutionMode = stateFile.getResolution();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string = this.mTargetDescription = targetName == null ? "" : targetName;
        if (capturedXML != null && capturedXML.isLocalCapture()) {
            this.mTargetDescription = String.valueOf(this.mTargetDescription) + (this.mTargetDescription.isEmpty() ? "" : TARGET_DESCRIPTION_SEPARATOR) + AnalysisMessages.LOCAL_CAPTURE;
        } else if (targetAddress != null && targetAddress.isValid()) {
            this.mTargetDescription = String.valueOf(this.mTargetDescription) + (this.mTargetDescription.isEmpty() ? "" : TARGET_DESCRIPTION_SEPARATOR) + String.valueOf(targetAddress);
        }
    }

    private boolean is64Bit(Session session) {
        boolean is64Bit = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream in = new FileInputStream(new File(this.getApcDirectory(), "captured.xml"));){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (XMLParser parser = new XMLParser((InputStream)in);){
                    is64Bit = GatorCapturedRawXML.read(parser).is64bit();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!is64Bit) {
            is64Bit = APCCapture.containsActive64BitImage(this.getAvailableImages());
        }
        return is64Bit;
    }

    private void writeErrorIntoCapture(@NonNull String errorMessage) throws IOException {
        File capturedFile = new File(this.getApcDirectory(), "captured.xml");
        if (CommonFileUtils.exists((File)capturedFile)) {
            GatorCapturedRawXML capturedXml = null;
            Throwable throwable = null;
            Object var5_6 = null;
            try (XMLParser parser = new XMLParser((InputStream)new FileInputStream(capturedFile));){
                capturedXml = GatorCapturedRawXML.read(parser);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            capturedXml.setError(errorMessage);
            capturedXml.save(capturedFile, false);
        }
    }

    public static enum GatorLicensingRequirementResult {
        FAIL_OTHER,
        FAIL_REQUIRES_MALI,
        OK;

    }

    @FunctionalInterface
    private static interface RunIfValid<T> {
        public T run(@NonNull Session var1, boolean var2, @NonNull CounterNames var3, @NonNull GatorCapturedXML var4) throws Throwable;
    }
}

