/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.events;

import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuEventPair;
import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuEventRow;
import com.arm.streamline.barmancfg.wizard.events.SelectedProcessorPmuRow;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.NullChecking;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class SelectedEventsOutlineModel
extends OutlineModel<SimpleColumn> {
    final @NonNull Map<@NonNull ProcessorPmu, @NonNull Integer> numEventsForPmu = new HashMap<ProcessorPmu, Integer>();
    final @NonNull Map<@NonNull ProcessorPmu, @NonNull Boolean> clockCyclesForPmu = new HashMap<ProcessorPmu, Boolean>();
    final @NonNull Set<@NonNull ProcessorPmuEventPair> eventPairs = new HashSet<ProcessorPmuEventPair>();

    @Override
    public void addRow(int index, Row<SimpleColumn> row, boolean includeChildren) {
        if (row instanceof ProcessorPmuEventRow) {
            ProcessorPmuEventRow r = (ProcessorPmuEventRow)row;
            ProcessorPmuEventPair event = r.getEvent();
            this.eventPairs.add(event);
            ProcessorPmu pmu = event.getPmu();
            @NonNull Integer num = 0;
            if (event.isCycleCounter()) {
                this.clockCyclesForPmu.put(pmu, true);
            } else {
                num = (Integer)NullChecking.neverNullOr((Object)this.numEventsForPmu.get(pmu), (Object)num);
                num = num + 1;
                this.numEventsForPmu.put(pmu, num);
            }
        }
        super.addRow(index, row, includeChildren);
    }

    public int getNumEventsForPmu(@NonNull ProcessorPmu processorPmu) {
        return NullChecking.neverNullOr((Integer)this.numEventsForPmu.get(processorPmu), (int)0);
    }

    public boolean hasClockCycleEventForPmu(@NonNull ProcessorPmu processorPmu) {
        return this.clockCyclesForPmu.containsKey(processorPmu);
    }

    public boolean isEventOnTheList(@NonNull ProcessorPmuEventPair event) {
        return this.eventPairs.contains(event);
    }

    public void removeRowsForOtherPmus(@NonNull Set<@NonNull ProcessorPmu> selectedPmus) {
        int index = this.getRowCount() - 1;
        while (index >= 0) {
            ProcessorPmuEventRow eventRow;
            ProcessorPmu pmu;
            if (index >= this.getRowCount() && (index = this.getRowCount() - 1) < 0) {
                return;
            }
            Row row = this.getRowAtIndex(index);
            if (row instanceof ProcessorPmuEventRow && !selectedPmus.contains(pmu = (eventRow = (ProcessorPmuEventRow)row).getEvent().getPmu())) {
                this.removeRow(index);
            }
            --index;
        }
    }

    @Override
    protected void removeRowsInternal(int[] indexes) {
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            Row row = this.getRowAtIndex(index);
            if (row instanceof ProcessorPmuEventRow) {
                ProcessorPmuEventRow r = (ProcessorPmuEventRow)row;
                ProcessorPmuEventPair event = r.getEvent();
                this.eventPairs.remove(event);
                ProcessorPmu pmu = event.getPmu();
                if (event.isCycleCounter()) {
                    this.clockCyclesForPmu.remove(pmu);
                } else {
                    @NonNull Integer num = (Integer)NullChecking.neverNull((Object)this.numEventsForPmu.get(pmu));
                    num = num - 1;
                    this.numEventsForPmu.put(pmu, num);
                }
            }
            ++n2;
        }
        super.removeRowsInternal(indexes);
        this.removeOrphanedTopLevelRows();
    }

    private void removeOrphanedTopLevelRows() {
        int index = this.getRowCount() - 1;
        while (index >= 0) {
            Row row = this.getRowAtIndex(index);
            if (row instanceof SelectedProcessorPmuRow) {
                SelectedProcessorPmuRow pmuRow = (SelectedProcessorPmuRow)row;
                int eventCount = 0;
                int eventIndex = index + 1;
                while (eventIndex < this.getRowCount()) {
                    ProcessorPmuEventRow eventRow;
                    Row r = this.getRowAtIndex(eventIndex);
                    if (r instanceof ProcessorPmuEventRow && (eventRow = (ProcessorPmuEventRow)r).getEvent().getPmu().equals((Object)pmuRow.getPmu())) {
                        ++eventCount;
                    }
                    ++eventIndex;
                }
                if (eventCount == 0) {
                    this.removeRow(index);
                }
            }
            --index;
        }
    }
}

