/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.custcounters;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.barmancfg.configuration.CustomChart;
import com.arm.streamline.barmancfg.configuration.CustomChartSeries;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.barmancfg.wizard.custcounters.CustomChartSeriesWidget;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.model.capture.GraphRenderingTypeImages;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.widget.TextField;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CustomChartWidget
extends Composite {
    private boolean configAverageCores = false;
    private boolean configAverageSelection = false;
    private @NonNull String configName = "";
    private boolean configPercentage = false;
    private boolean configPerCpu = false;
    private @NonNull GraphRenderingType configRenderingType = CustomChart.DEFAULT_RENDERING_TYPE;
    private @NonNull SeriesComposition configSeriesComposition = CustomChart.DEFAULT_SERIES_COMPOSITION;
    private final @NonNull IChartListener listener;
    private final @NonNull ScrolledComposite scrolledComposite;
    private final @NonNull Composite seriesContainer;
    private final @NonNull List<@NonNull CustomChartSeriesWidget> serieses = new ArrayList<CustomChartSeriesWidget>();

    private static @NonNull Button createImageButton(@NonNull Composite parent, @NonNull String tooltip, @NonNull String imageName, boolean defaultValue, @Nullable Function<@NonNull Boolean, @NonNull Boolean> handler) {
        Button button = new Button(parent, 2);
        button.setToolTipText(tooltip);
        button.setImage(StreamlinePlugin.getImage(imageName));
        button.setSelection(defaultValue);
        if (handler != null) {
            button.addListener(13, e -> {
                boolean newValue;
                boolean oldValue = button.getSelection();
                if (oldValue != (newValue = ((Boolean)handler.apply((Boolean)NullChecking.neverNull((Object)oldValue))).booleanValue())) {
                    button.setSelection(newValue);
                }
            });
        }
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)button);
        return button;
    }

    public CustomChartWidget(Composite parent, @Nullable CustomChart defaults, @NonNull IChartListener listener) {
        super(parent, 2048);
        super.setLayout((Layout)new GridLayout(1, true));
        this.listener = listener;
        if (defaults != null) {
            this.configAverageCores = defaults.isAverageCores();
            this.configAverageSelection = defaults.isAverageSelection();
            this.configPercentage = defaults.isPercentage();
            this.configPerCpu = defaults.isPerCpu();
            this.configRenderingType = defaults.getRenderingType();
            this.configSeriesComposition = defaults.getSeriesComposition();
            this.configName = defaults.getName();
        }
        Composite children = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(children);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)children);
        Label nameLabel = new Label(children, 0);
        nameLabel.setText(BarmanWizardMessages.PAGE_4_LABEL_NAME_INPUT);
        nameLabel.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_CHART_NAME_INPUT);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)nameLabel);
        TextField nameInput = new TextField(children);
        nameInput.addFieldModifiedListener(f -> this.validateWidget((String)NullChecking.neverNull((Object)f.getText()), this.configAverageCores, this.configAverageSelection, this.configPercentage, this.configPerCpu, this.configSeriesComposition, this.configRenderingType));
        nameInput.setText(this.configName);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)nameInput);
        Label optionsLabel = new Label(children, 0);
        optionsLabel.setText(BarmanWizardMessages.PAGE_4_LABEL_OPTIONS_INPUT);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)optionsLabel);
        Composite optionsBox = new Composite(children, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).applyTo(optionsBox);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)optionsBox);
        Composite buttonBox = new Composite(optionsBox, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(true).applyTo(buttonBox);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)buttonBox);
        Button[] averageCoresButton = new Button[1];
        CustomChartWidget.createImageButton(buttonBox, (String)NullChecking.neverNull((Object)ChartMessages.PER_CPU_TOOLTIP), "Cores.png", this.configPerCpu, b -> {
            this.setAverageCoresButtonEnabled(averageCoresButton[0], (boolean)b);
            this.validateWidget(this.configName, this.configAverageCores, this.configAverageSelection, this.configPercentage, (boolean)b, this.configSeriesComposition, this.configRenderingType);
            return b;
        });
        averageCoresButton[0] = CustomChartWidget.createImageButton(buttonBox, "", StreamlineImages.AVERAGE_CORES, this.configAverageCores, b -> {
            Button button = averageCoresButton[0];
            boolean averageCores = b != false && (button == null || button.isEnabled());
            this.validateWidget(this.configName, averageCores, this.configAverageSelection, this.configPercentage, this.configPerCpu, this.configSeriesComposition, this.configRenderingType);
            return (Boolean)NullChecking.neverNull((Object)averageCores);
        });
        this.setAverageCoresButtonEnabled(averageCoresButton[0], this.configPerCpu);
        CustomChartWidget.createImageButton(buttonBox, (String)NullChecking.neverNull((Object)ChartMessages.AVERAGE_SELECTION_TOOLTIP), StreamlineImages.AVERAGE_SELECTION, this.configAverageSelection, b -> {
            this.validateWidget(this.configName, this.configAverageCores, (boolean)b, this.configPercentage, this.configPerCpu, this.configSeriesComposition, this.configRenderingType);
            return b;
        });
        CustomChartWidget.createImageButton(buttonBox, (String)NullChecking.neverNull((Object)ChartMessages.PERCENTAGE_TOOLTIP), StreamlineImages.PERCENTAGE, this.configPercentage, b -> {
            this.validateWidget(this.configName, this.configAverageCores, this.configAverageSelection, (boolean)b, this.configPerCpu, this.configSeriesComposition, this.configRenderingType);
            return b;
        });
        Combo seriesCompositionInput = new Combo(optionsBox, 0);
        seriesCompositionInput.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_SERIES_COMPOSITION_INPUT);
        seriesCompositionInput.addListener(13, e -> {
            @NonNull List validValues = (List)seriesCompositionInput.getData();
            SeriesComposition seriesComposition = (SeriesComposition)validValues.get(seriesCompositionInput.getSelectionIndex());
            this.validateWidget(this.configName, this.configAverageCores, this.configAverageSelection, this.configPercentage, this.configPerCpu, seriesComposition, this.configRenderingType);
        });
        SWTUtils.addAllCombo(seriesCompositionInput, SeriesComposition.values(), this.configSeriesComposition, s -> s.canBeSwitchedTo() ? s.getPresentationName() : null);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)seriesCompositionInput);
        buttonBox = new Composite(optionsBox, 0);
        GridLayoutFactory.fillDefaults().numColumns(GraphRenderingType.values().length).equalWidth(true).applyTo(buttonBox);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)buttonBox);
        Button[] renderingTypeButtons = new Button[GraphRenderingType.values().length];
        Listener radioListener = e -> {
            Button[] buttonArray2 = renderingTypeButtons;
            int n = renderingTypeButtons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button;
                button.setSelection((button = buttonArray2[n2]) == e.widget);
                ++n2;
            }
            this.validateWidget(this.configName, this.configAverageCores, this.configAverageSelection, this.configPercentage, this.configPerCpu, this.configSeriesComposition, (GraphRenderingType)NullChecking.neverNull((Object)((GraphRenderingType)((Button)e.widget).getData())));
        };
        int index = 0;
        GraphRenderingType[] graphRenderingTypeArray = GraphRenderingType.values();
        int n = graphRenderingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphRenderingType value = graphRenderingTypeArray[n2];
            Button renderingTypeInput = CustomChartWidget.createImageButton(buttonBox, value.getTooltip(), GraphRenderingTypeImages.get(value), value.equals((Object)this.configRenderingType), null);
            renderingTypeInput.setData((Object)value);
            renderingTypeInput.addListener(13, radioListener);
            renderingTypeButtons[index++] = renderingTypeInput;
            ++n2;
        }
        Group seriesGroup = new Group(children, 16);
        seriesGroup.setText(BarmanWizardMessages.PAGE_4_LABEL_SERIES);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo((Composite)seriesGroup);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)seriesGroup);
        this.scrolledComposite = new ScrolledComposite((Composite)seriesGroup, 768);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.scrolledComposite);
        this.seriesContainer = new Composite((Composite)this.scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().margins(2, 2).spacing(0, 2).numColumns(1).applyTo(this.seriesContainer);
        this.scrolledComposite.setContent((Control)this.seriesContainer);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinSize(this.seriesContainer.computeSize(-1, -1));
        this.scrolledComposite.layout(true, true);
        Composite addSeriesContainer = new Composite((Composite)seriesGroup, 0);
        GridLayoutFactory.fillDefaults().margins(2, 2).numColumns(1).applyTo(addSeriesContainer);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addSeriesContainer);
        Button addSeriesButton = new Button(addSeriesContainer, 8);
        addSeriesButton.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_ADD_SERIES);
        addSeriesButton.setImage(StreamlinePlugin.getImage(StreamlineImages.ADD));
        addSeriesButton.addListener(13, e -> this.addSeries(null));
        GridDataFactory.fillDefaults().grab(true, false).align(131072, 0x1000000).applyTo((Control)addSeriesButton);
        if (defaults != null) {
            for (CustomChartSeries series : defaults.getSeries()) {
                this.addSeries(series);
            }
        }
        listener.chartStateChanged(this, this.isValid());
    }

    public @Nullable CustomChart getCustomChart() {
        if (!this.isValid()) {
            return null;
        }
        ArrayList<@NonNull CustomChartSeries> seriesObjects = new ArrayList<CustomChartSeries>();
        for (CustomChartSeriesWidget seriesWidget : this.serieses) {
            seriesObjects.add(seriesWidget.getCustomChartSeries());
        }
        return new CustomChart(this.configName, this.configSeriesComposition, this.configRenderingType, this.configAverageSelection, this.configAverageCores, this.configPercentage, this.configPerCpu, seriesObjects);
    }

    public boolean isValid() {
        return !this.configName.trim().isEmpty() && this.areSeriesAllValid();
    }

    public void removeSeries(@NonNull CustomChartSeriesWidget series) {
        if (this.serieses.remove((Object)series)) {
            series.dispose();
            this.redrawSeriesArea();
            this.listener.chartStateChanged(this, this.isValid());
        }
    }

    public void setLayout(Layout layout) {
    }

    private void addSeries(@Nullable CustomChartSeries defaults) {
        CustomChartSeriesWidget series = new CustomChartSeriesWidget(this, defaults, this.seriesContainer);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)series);
        this.serieses.add(series);
        this.redrawSeriesArea();
    }

    private boolean areSeriesAllValid() {
        if (this.serieses.isEmpty()) {
            return false;
        }
        for (CustomChartSeriesWidget series : this.serieses) {
            if (series.isValid()) continue;
            return false;
        }
        return true;
    }

    private void redrawSeriesArea() {
        this.scrolledComposite.layout(true, true);
        this.scrolledComposite.setMinSize(this.seriesContainer.computeSize(-1, -1));
    }

    private void setAverageCoresButtonEnabled(@Nullable Button button, boolean perCpu) {
        if (button != null) {
            button.setToolTipText(perCpu ? ChartMessages.AVERAGE_CORES_TOOLTIP : ChartMessages.AVERAGE_CORES_TOOLTIP_DISABLED);
            button.setEnabled(perCpu);
            if (!perCpu) {
                button.setSelection(false);
                this.validateWidget(this.configName, this.configAverageCores, false, this.configPercentage, this.configPerCpu, this.configSeriesComposition, this.configRenderingType);
            }
        }
    }

    private void validateWidget(@NonNull String configName, boolean configAverageCores, boolean configAverageSelection, boolean configPercentage, boolean configPerCpu, @NonNull SeriesComposition configSeriesComposition, @NonNull GraphRenderingType configRenderingType) {
        this.configName = configName;
        this.configAverageCores = configAverageCores;
        this.configAverageSelection = configAverageSelection;
        this.configPercentage = configPercentage;
        this.configPerCpu = configPerCpu;
        this.configSeriesComposition = configSeriesComposition;
        this.configRenderingType = configRenderingType;
        this.listener.chartStateChanged(this, this.isValid());
    }

    void notifySeriesChanged(@NonNull CustomChartSeriesWidget series) {
        this.listener.chartStateChanged(this, this.isValid());
    }

    @FunctionalInterface
    public static interface IChartListener {
        public void chartStateChanged(@NonNull CustomChartWidget var1, boolean var2);
    }
}

