/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.barmancfg.wizard.BarmanOutputOptionsPage;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.common.utility.io.StdLog;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;

public class BarmanWizardSummaryPage
extends WizardPage {
    public static final String PAGE_NAME = "PAGE_6";
    public static final String PAGE_TITLE = BarmanWizardMessages.PAGE_6_TITLE;
    private static final String FORM_WRAPPER = "<form>%s</form>";
    private static final int LAYOUT_MARGIN = 6;
    private final boolean mustViewSummaryPage;
    private @Nullable FormText textArea;

    private static String em(String text) {
        return String.format("<b>%s</b>", text);
    }

    private static String paragraph(String text) {
        return String.format("<p>%s</p>", text);
    }

    private static String tt(String text) {
        return String.format("'%s'", text);
    }

    protected BarmanWizardSummaryPage(boolean mustViewSummaryPage) {
        super(PAGE_NAME, PAGE_TITLE, null);
        this.mustViewSummaryPage = mustViewSummaryPage;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 6;
        fillLayout.marginWidth = 6;
        composite.setLayout((Layout)fillLayout);
        FormText formText = new FormText(composite, 0);
        this.setControl((Control)composite);
        this.setPageComplete(!this.mustViewSummaryPage);
        this.textArea = formText;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setPageComplete(true);
            this.setLabelContents();
        }
    }

    private void setLabelContents() {
        String generatedItemSuffix;
        FormText formText = this.textArea;
        File path = ((BarmanOutputOptionsPage)this.getPreviousPage()).getOutputPath();
        if (path == null) {
            if (formText != null) {
                formText.setText("", false, false);
            }
            return;
        }
        boolean generateSourceFiles = ((BarmanOutputOptionsPage)this.getPreviousPage()).isGenerateSourceFiles();
        boolean saveConfigFile = ((BarmanOutputOptionsPage)this.getPreviousPage()).isSaveConfigFile();
        File barmanH = new File(path, "barman.h");
        File barmanC = new File(path, "barman.c");
        File barmanXml = new File(path, "barman.xml");
        boolean isOverwriting = generateSourceFiles && (barmanH.exists() || barmanC.exists()) || saveConfigFile && barmanXml.exists();
        String generatedItemPrefix = generateSourceFiles && saveConfigFile ? "<li>" : "";
        String string = generatedItemSuffix = generateSourceFiles && saveConfigFile ? "</li>" : "";
        if (formText != null) {
            try {
                StringBuilder textBody = new StringBuilder();
                textBody.append(BarmanWizardSummaryPage.paragraph(String.format("%s %s", MessageFormat.format(BarmanWizardMessages.PAGE_6_MESSAGE_GENERATION_LOCATION, BarmanWizardSummaryPage.tt(path.getCanonicalPath())), isOverwriting ? BarmanWizardSummaryPage.em(BarmanWizardMessages.PAGE_6_MESSAGE_EXISTING_FILES_OVERWRITTEN) : "")));
                if (generateSourceFiles) {
                    textBody.append(generatedItemPrefix);
                    textBody.append(MessageFormat.format(BarmanWizardMessages.PAGE_6_MESSAGE_SOURCE_FILES, BarmanWizardSummaryPage.tt("barman.h"), BarmanWizardSummaryPage.tt("barman.c")));
                    textBody.append(generatedItemSuffix);
                }
                if (saveConfigFile) {
                    textBody.append(generatedItemPrefix);
                    textBody.append(MessageFormat.format(BarmanWizardMessages.PAGE_6_MESSAGE_CONFIGURATION_FILE, BarmanWizardSummaryPage.tt("barman.xml")));
                    textBody.append(generatedItemSuffix);
                }
                textBody.append(BarmanWizardSummaryPage.paragraph(BarmanWizardMessages.PAGE_6_MESSAGE_PRESS_FINISH_TO_COMPLETE));
                textBody.append(BarmanWizardSummaryPage.paragraph(BarmanWizardMessages.PAGE_6_MESSAGE_SEE_DOCUMENTATION));
                String text = String.format(FORM_WRAPPER, textBody);
                formText.setText(text, true, false);
            }
            catch (IOException exception) {
                StdLog.error((Plugin)StreamlinePlugin.getInstance(), (String)exception.getMessage(), (Throwable)exception);
            }
        }
    }
}

