/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.barmancfg.configuration.STMBackendConfiguration;
import com.arm.streamline.barmancfg.configuration.StreamingConfiguration;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.utility.text.IntegerRange;
import java.util.List;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class BarmanWizardSTMConfigPage
extends WizardPage {
    public static final String PAGE_NAME = "PAGE_1A";
    public static final String PAGE_TITLE = BarmanWizardMessages.PAGE_1A_TITLE;
    private final @NonNull IWizardPage nextPage;
    private final @NonNull STMBackendConfiguration stmConfiguration;
    private final @NonNull StreamingConfiguration streamingConfiguration;
    private final @NonNull IntSupplier maxCores;
    private boolean canFlip;
    private Spinner channelNumberSpinner;
    private Text cpuListsText;
    private Spinner headerEveryNSamples;

    public BarmanWizardSTMConfigPage(@NonNull IWizard wizard, @NonNull IWizardPage nextPage, @NonNull STMBackendConfiguration stmConfig, @NonNull StreamingConfiguration streamingConfiguration, @NonNull IntSupplier maxCores) {
        super(PAGE_NAME, PAGE_TITLE, null);
        this.setMessage(BarmanWizardMessages.PAGE_1A_MESSAGE);
        super.setWizard(wizard);
        this.nextPage = nextPage;
        this.stmConfiguration = stmConfig;
        this.streamingConfiguration = streamingConfiguration;
        this.maxCores = maxCores;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        composite.setLayout((Layout)gl_composite);
        Label lblNewLabel = new Label(composite, 64);
        GridData gd_lblNewLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_lblNewLabel.heightHint = 48;
        gd_lblNewLabel.widthHint = 450;
        lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        lblNewLabel.setText(BarmanWizardMessages.PAGE_1A_PROMPT_MESSAGE);
        Group channelsGroup = new Group(composite, 0);
        channelsGroup.setText(BarmanWizardMessages.PAGE_1A_MASTERS_CHANNELS_GROUP);
        channelsGroup.setLayout((Layout)new GridLayout(2, false));
        channelsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel_4 = new Label((Composite)channelsGroup, 0);
        lblNewLabel_4.setText(BarmanWizardMessages.PAGE_1A_LIST_OF_MASTERS_LABEL);
        this.cpuListsText = new Text((Composite)channelsGroup, 2048);
        this.cpuListsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblUseChannelsStarting = new Label((Composite)channelsGroup, 0);
        lblUseChannelsStarting.setBounds(0, 0, 55, 15);
        lblUseChannelsStarting.setText(BarmanWizardMessages.PAGE_1A_CHANNELS_RANGE_LABEL);
        this.channelNumberSpinner = new Spinner((Composite)channelsGroup, 2048);
        this.channelNumberSpinner.setMaximum(65535);
        this.channelNumberSpinner.setSelection(50000);
        Group headerGroup = new Group(composite, 0);
        headerGroup.setText(BarmanWizardMessages.PAGE_1A_STREAMING_GROUP);
        headerGroup.setLayout((Layout)new GridLayout(3, false));
        headerGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel_5 = new Label((Composite)headerGroup, 0);
        lblNewLabel_5.setText(BarmanWizardMessages.PAGE_1A_SENDING_HEADER_RECORDS_LABEL);
        this.headerEveryNSamples = new Spinner((Composite)headerGroup, 2048);
        this.headerEveryNSamples.setMaximum(1000000);
        this.headerEveryNSamples.setMinimum(0);
        Label lblNewLabel_6 = new Label((Composite)headerGroup, 0);
        lblNewLabel_6.setText(BarmanWizardMessages.PAGE_1A_SAMPLES_SUFFIX_LABEL);
        this.initializeFromDefaults();
        this.channelNumberSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BarmanWizardSTMConfigPage.this.updatePageState();
            }
        });
        this.headerEveryNSamples.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BarmanWizardSTMConfigPage.this.updatePageState();
            }
        });
        this.cpuListsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BarmanWizardSTMConfigPage.this.updatePageState();
            }
        });
        this.updatePageState();
        this.setControl((Control)composite);
    }

    private void initializeFromDefaults() {
        this.headerEveryNSamples.setSelection(this.streamingConfiguration.getHeaderEveryNRecords());
        this.channelNumberSpinner.setSelection(this.stmConfiguration.getMinChannelNumber());
        this.cpuListsText.setText(IntegerRange.asRangedList(this.stmConfiguration.getMasterIds(), 10));
        this.setNumberOfChannels();
    }

    protected void updatePageState() {
        try {
            this.setErrorMessage(null);
            String text = this.cpuListsText.getText();
            List<Integer> range = IntegerRange.parseString(text);
            if (range.isEmpty()) {
                this.canFlip = false;
                this.setPageComplete(false);
            }
            this.stmConfiguration.getMasterIds().clear();
            this.stmConfiguration.getMasterIds().addAll(range);
            int channel = this.channelNumberSpinner.getSelection();
            this.stmConfiguration.setMinChannelNumber(channel);
            int everyN = this.headerEveryNSamples.getSelection();
            this.streamingConfiguration.setHeaderEveryNRecords(everyN);
            this.setNumberOfChannels();
        }
        catch (Exception e) {
            this.setErrorMessage(BarmanWizardMessages.PAGE_1A_INVALID_INPUTS_ERROR_MESSAGE);
        }
    }

    public boolean canFlipToNextPage() {
        return this.canFlip;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.canFlip = newMessage == null;
        this.setPageComplete(this.canFlip);
    }

    public @NonNull STMBackendConfiguration getStmConfiguration() {
        return this.stmConfiguration;
    }

    public @NonNull StreamingConfiguration getStreamingConfiguration() {
        return this.streamingConfiguration;
    }

    private void setNumberOfChannels() {
        if (this.stmConfiguration.getNumberOfChannels() < this.maxCores.getAsInt()) {
            this.stmConfiguration.setNumberOfChannels(this.maxCores.getAsInt());
        }
    }
}

