/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.BarmanProcessorConfiguration;
import com.arm.streamline.barmancfg.wizard.BarmanSelectConfigOptionsPage;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class BarmanSelectProcessorsPage
extends WizardPage {
    public static final String PAGE_NAME = "PAGE_2";
    public static final String PAGE_TITLE = BarmanWizardMessages.PAGE_2_TITLE;
    private final @NonNull BarmanSelectConfigOptionsPage configOptionsPage;
    private @NonNull BarmanConfiguration defaults;
    private @Nullable Label labelNumProcessorsSelected;
    private @Nullable Table tableWidget;

    private static void fillTableRows(@Nullable Map<Integer, ProcessorPmu> pmus, @Nullable Table table, @NonNull Set<@NonNull ProcessorPmu> selectedPmus) {
        if (table != null) {
            table.removeAll();
            if (pmus != null) {
                List<@NonNull T> pmusList = pmus.values().stream().distinct().sorted().collect(Collectors.toList());
                for (ProcessorPmu pmu : pmusList) {
                    TableItem tableItem = new TableItem(table, 0);
                    tableItem.setText(0, pmu.getCoreName());
                    tableItem.setText(1, Arrays.stream(pmu.getCpuids()).mapToObj(Integer::valueOf).map(c -> String.format("0x%05x", c)).collect(Collectors.joining("/")));
                    tableItem.setText(2, pmu.getImplementor());
                    tableItem.setData((Object)pmu);
                    tableItem.setChecked(selectedPmus.contains(pmu));
                }
                table.layout(true);
            }
        }
    }

    public BarmanSelectProcessorsPage(@NonNull BarmanConfiguration defaults, @NonNull BarmanSelectConfigOptionsPage configOptionsPage) {
        super(PAGE_NAME, PAGE_TITLE, null);
        this.configOptionsPage = configOptionsPage;
        this.defaults = defaults;
        this.validateComplete();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Table table = new Table(composite, 67616);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        TableColumn nameCol = new TableColumn(table, 0);
        nameCol.setAlignment(16384);
        nameCol.setWidth(221);
        nameCol.setText(BarmanWizardMessages.PAGE_2_LABEL_COLUMN_NAME);
        nameCol.setResizable(true);
        TableColumn cpuidCol = new TableColumn(table, 0);
        cpuidCol.setWidth(90);
        cpuidCol.setText(BarmanWizardMessages.PAGE_2_LABEL_COLUMN_CPUID);
        cpuidCol.setResizable(true);
        TableColumn implementerCol = new TableColumn(table, 0);
        implementerCol.setAlignment(16384);
        implementerCol.setWidth(190);
        implementerCol.setText(BarmanWizardMessages.PAGE_2_LABEL_COLUMN_IMPLEMENTER);
        implementerCol.setResizable(true);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setToolTipText(BarmanWizardMessages.PAGE_2_TOOLTIP_PROCESSOR_LIST);
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    BarmanSelectProcessorsPage.this.validateComplete();
                }
            }
        });
        this.tableWidget = table;
        this.fillTableRows();
        this.setControl((Control)composite);
        this.labelNumProcessorsSelected = new Label(composite, 0);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.labelNumProcessorsSelected);
        this.setPageComplete(false);
        this.validateComplete();
    }

    public @NonNull Set<@NonNull ProcessorPmu> getSelectedPmus() {
        @NonNull HashSet<@NonNull ProcessorPmu> selectedPmus = new HashSet<ProcessorPmu>();
        if (this.tableWidget != null) {
            TableItem[] tableItemArray = this.tableWidget.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    @NonNull ProcessorPmu pmu = (ProcessorPmu)NullChecking.neverNull((Object)((ProcessorPmu)item.getData()));
                    selectedPmus.add(pmu);
                }
                ++n2;
            }
        }
        return selectedPmus;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillTableRows();
        }
    }

    private void fillTableRows() {
        @NonNull HashSet<@NonNull ProcessorPmu> selectedPmus = new HashSet<ProcessorPmu>();
        for (BarmanProcessorConfiguration proc : this.defaults.getProcessors()) {
            selectedPmus.add(proc.getProcessorPmu());
        }
        Map<Integer, ProcessorPmu> pmusMap = null;
        try {
            pmusMap = this.getProcessorPmus();
        }
        catch (IOException exception) {
            StdLog.error((Plugin)StreamlinePlugin.getInstance(), (String)BarmanWizardMessages.PAGE_2_ERROR_FAILED_TO_LOAD_PMUS_XML, (Throwable)exception);
        }
        BarmanSelectProcessorsPage.fillTableRows(pmusMap, this.tableWidget, selectedPmus);
    }

    private @Nullable Map<Integer, ProcessorPmu> getProcessorPmus() throws IOException {
        return this.configOptionsPage.getProcessorPmus();
    }

    void validateComplete() {
        boolean seenMProfile = false;
        boolean seenARProfile = false;
        int numberSelected = 0;
        if (this.tableWidget != null) {
            TableItem[] tableItemArray = this.tableWidget.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    ++numberSelected;
                    @NonNull ProcessorPmu pmu = (ProcessorPmu)NullChecking.neverNull((Object)((ProcessorPmu)item.getData()));
                    if (pmu.getProfile().isMProfile()) {
                        seenMProfile = true;
                    } else {
                        seenARProfile = true;
                    }
                }
                ++n2;
            }
        }
        boolean seenMProfileAndARProfile = seenMProfile && seenARProfile;
        @Nullable Label labelNumProcessorsSelected = this.labelNumProcessorsSelected;
        if (labelNumProcessorsSelected != null) {
            if (seenMProfileAndARProfile) {
                labelNumProcessorsSelected.setText(BarmanWizardMessages.PAGE_2_CANNOT_MIX_M_WITH_AR_PROFILE);
            } else {
                labelNumProcessorsSelected.setText(MessageFormat.format(BarmanWizardMessages.PAGE_2_NUM_PROCESSORS_SELECTED_LABEL, numberSelected));
            }
        }
        this.setPageComplete(!seenMProfileAndARProfile && numberSelected > 0);
    }
}

