/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.BarmanProcessorConfiguration;
import com.arm.streamline.barmancfg.configuration.DataStorageBackend;
import com.arm.streamline.barmancfg.wizard.BarmanDWTConfigPage;
import com.arm.streamline.barmancfg.wizard.BarmanSelectConfigOptionsPage;
import com.arm.streamline.barmancfg.wizard.BarmanSelectProcessorsPage;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.barmancfg.wizard.events.AvailableProcessorPmuRow;
import com.arm.streamline.barmancfg.wizard.events.PmuAvailableEventsOutline;
import com.arm.streamline.barmancfg.wizard.events.PmuSelectedEventsOutline;
import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuCell;
import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuEventPair;
import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuEventRow;
import com.arm.streamline.barmancfg.wizard.events.SelectedEventsOutlineModel;
import com.arm.streamline.barmancfg.wizard.events.SelectedProcessorPmuRow;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.common.xml.pmus.ProcessorPmuEventDescription;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.utility.io.LocalObjectTransfer;
import com.arm.streamline.widget.FilterField;
import com.arm.streamline.widget.outline.IOutlineModelListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BarmanSelectEventsPage
extends WizardPage {
    public static final String PAGE_NAME = "PAGE_3";
    public static final String PAGE_TITLE = BarmanWizardMessages.PAGE_3_TITLE;
    protected static final KeyListener SELECT_ALL_LISTENER = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            Object source;
            KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e));
            if (keyStroke.isComplete() && keyStroke.getModifierKeys() == WorkspaceUtils.getCommandKey() && keyStroke.getNaturalKey() == 65 && (source = e.getSource()) instanceof Outline) {
                ((Outline)source).getModel().select();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private @Nullable OutlineModel<SimpleColumn> availableModel;
    private final @NonNull BarmanSelectConfigOptionsPage configOptionsPage;
    private @NonNull BarmanConfiguration defaults;
    private @Nullable FilterField mFilterField;
    private @Nullable IWizardPage nextPage;
    private @Nullable PmuAvailableEventsOutline outlineAvailable;
    private @Nullable WizardPage page = null;
    private @Nullable SelectedEventsOutlineModel selectedModel;

    public static void fillSelectedEvents(@NonNull SelectedEventsOutlineModel selectedModel, @NonNull BarmanConfiguration barmanConfiguration) {
        for (BarmanProcessorConfiguration procConfig : barmanConfiguration.getProcessors()) {
            ProcessorPmu pmu = procConfig.getProcessorPmu();
            SelectedProcessorPmuRow pmuRow = new SelectedProcessorPmuRow(pmu);
            selectedModel.addRow(pmuRow);
            for (Integer event : procConfig.getEvents()) {
                @NonNull ProcessorPmuEventDescription eventDescription = (ProcessorPmuEventDescription)NullChecking.neverNull((Object)((ProcessorPmuEventDescription)pmu.getEvents().get(event)));
                ProcessorPmuEventPair pair = new ProcessorPmuEventPair(pmu, eventDescription);
                ProcessorPmuEventRow row = new ProcessorPmuEventRow(pair, selectedModel);
                pmuRow.addChild(row);
                selectedModel.addRow(row);
            }
            if (!procConfig.isSampleCycleCounter()) continue;
            @NonNull ProcessorPmuEventDescription eventDescription = (ProcessorPmuEventDescription)NullChecking.neverNull((Object)((ProcessorPmuEventDescription)pmu.getEvents().get(ProcessorPmuEventDescription.CYCLE_COUNTER_KEY)));
            ProcessorPmuEventPair pair = new ProcessorPmuEventPair(pmu, eventDescription);
            ProcessorPmuEventRow row = new ProcessorPmuEventRow(pair, selectedModel);
            pmuRow.addChild(row);
            selectedModel.addRow(row);
        }
    }

    protected static @NonNull List<@NonNull BarmanProcessorConfiguration> extractProcessorsAndEvents(@NonNull OutlineModel<SimpleColumn> model) {
        HashMap<ProcessorPmu, HashSet<@NonNull E>> pmuEvents = new HashMap();
        HashMap<ProcessorPmu, Boolean> pmuCycleCounters = new HashMap<ProcessorPmu, Boolean>();
        for (Row<SimpleColumn> pRow : model.getRows()) {
            if (!(pRow instanceof ProcessorPmuEventRow)) continue;
            ProcessorPmuEventRow eRow = (ProcessorPmuEventRow)pRow;
            ProcessorPmuEventPair event = eRow.getEvent();
            ProcessorPmu pmu = event.getPmu();
            HashSet<@NonNull Integer> eventsSet = (HashSet<Integer>)pmuEvents.get(pmu);
            if (eventsSet == null) {
                eventsSet = new HashSet<Integer>();
                pmuEvents.put(pmu, eventsSet);
            }
            if (event.isCycleCounter()) {
                pmuCycleCounters.put(pmu, Boolean.TRUE);
                continue;
            }
            pmuCycleCounters.putIfAbsent(pmu, Boolean.FALSE);
            eventsSet.add((Integer)NullChecking.neverNull((Object)event.getEvent().getEventID()));
        }
        assert (pmuEvents.size() == pmuCycleCounters.size());
        ArrayList<@NonNull BarmanProcessorConfiguration> result = new ArrayList<BarmanProcessorConfiguration>();
        for (Map.Entry pmuCycleCountersEntry : pmuCycleCounters.entrySet()) {
            ProcessorPmu pmu = (ProcessorPmu)NullChecking.neverNull((Object)((ProcessorPmu)pmuCycleCountersEntry.getKey()));
            result.add(new BarmanProcessorConfiguration(pmu, (Boolean)NullChecking.neverNull((Object)((Boolean)pmuCycleCountersEntry.getValue())), (Set)NullChecking.neverNull((Object)((Set)pmuEvents.get(pmu)))));
        }
        return result;
    }

    private static void fillEventsTable(@NonNull Set<@NonNull ProcessorPmu> pmus, @Nullable OutlineModel<SimpleColumn> eventsModel, @Nullable SelectedEventsOutlineModel selectedModel, @Nullable Pattern availableEventsFilterPattern) {
        if (eventsModel != null) {
            eventsModel.removeAllRows();
            for (ProcessorPmu pmu : new TreeSet<ProcessorPmu>(pmus)) {
                eventsModel.addRow(new AvailableProcessorPmuRow(pmu, (SelectedEventsOutlineModel)NullChecking.neverNull((Object)selectedModel), availableEventsFilterPattern), true);
            }
        }
    }

    public BarmanSelectEventsPage(@NonNull BarmanConfiguration defaults, @NonNull BarmanSelectConfigOptionsPage configOptionsPage) {
        super(PAGE_NAME, PAGE_TITLE, null);
        this.defaults = defaults;
        this.configOptionsPage = configOptionsPage;
    }

    public void createControl(Composite parent) {
        PmuAvailableEventsOutline outlineAvailable;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Composite compositeAvailable = new Composite(composite, 0);
        compositeAvailable.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)compositeAvailable);
        Composite compositeSelected = new Composite(composite, 0);
        compositeSelected.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)compositeSelected);
        Label labelAvailable = SWTUtils.createLabel(compositeAvailable, BarmanWizardMessages.PAGE_3_LABEL_AVAILABLE_EVENT_LIST, BarmanWizardMessages.PAGE_3_TOOLTIP_AVAILABLE_EVENT_LIST, 0);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)labelAvailable);
        Composite wrapperAvailable = new Composite(compositeAvailable, 2048);
        GridLayoutFactory.fillDefaults().applyTo(wrapperAvailable);
        OutlineModel<SimpleColumn> modelAvailable = new OutlineModel<SimpleColumn>();
        SimpleColumn columnAvailable = new SimpleColumn(0, BarmanWizardMessages.PAGE_3_LABEL_AVAILABLE_EVENT_LIST, BarmanWizardMessages.PAGE_3_TOOLTIP_AVAILABLE_EVENT_LIST);
        columnAvailable.setPrimary(true);
        columnAvailable.setRowCell(new ProcessorPmuCell());
        columnAvailable.setNoMaxWidth();
        modelAvailable.addColumn(columnAvailable);
        this.mFilterField = new FilterField(wrapperAvailable, field -> this.applyFilter(field.getPattern()), CountersMessages.FILTER_WATERMARK, CountersMessages.FILTER_TOOLTIP);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mFilterField);
        this.outlineAvailable = outlineAvailable = new PmuAvailableEventsOutline(wrapperAvailable, modelAvailable);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outlineAvailable);
        GridDataFactory.fillDefaults().grab(true, true).hint(wrapperAvailable.computeSize((int)-1, (int)-1).x + 17, -1).applyTo((Control)wrapperAvailable);
        outlineAvailable.addKeyListener(SELECT_ALL_LISTENER);
        this.availableModel = modelAvailable;
        outlineAvailable.setAllowLazyAdjust(true);
        outlineAvailable.adjustScrollBarsForContent();
        outlineAvailable.redraw();
        Label labelSelected = SWTUtils.createLabel(compositeSelected, BarmanWizardMessages.PAGE_3_LABEL_SELECTED_EVENT_LIST, BarmanWizardMessages.PAGE_3_TOOLTIP_SELECTED_EVENT_LIST, 0);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)labelSelected);
        Composite wrapperSelected = new Composite(compositeSelected, 2048);
        GridLayoutFactory.fillDefaults().applyTo(wrapperSelected);
        final SelectedEventsOutlineModel modelSelected = new SelectedEventsOutlineModel();
        SimpleColumn columnSelected = new SimpleColumn(0, BarmanWizardMessages.PAGE_3_LABEL_SELECTED_EVENT_LIST, BarmanWizardMessages.PAGE_3_TOOLTIP_SELECTED_EVENT_LIST);
        columnSelected.setPrimary(true);
        columnSelected.setRowCell(new ProcessorPmuCell());
        columnSelected.setNoMaxWidth();
        modelSelected.addColumn(columnSelected);
        final PmuSelectedEventsOutline outlineSelected = new PmuSelectedEventsOutline(wrapperSelected, modelSelected);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outlineSelected);
        GridDataFactory.fillDefaults().grab(true, true).hint(wrapperSelected.computeSize((int)-1, (int)-1).x + 17, -1).applyTo((Control)wrapperSelected);
        outlineSelected.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && (e.keyCode == 8 || e.keyCode == 127)) {
                    outlineSelected.getModel().removeSelection();
                } else {
                    SELECT_ALL_LISTENER.keyPressed(e);
                }
            }

            public void keyReleased(KeyEvent e) {
                SELECT_ALL_LISTENER.keyReleased(e);
            }
        });
        outlineAvailable.addListener(8, e -> {
            for (Row row : modelAvailable.getSelectionAsList()) {
                if (!(row instanceof ProcessorPmuEventRow)) continue;
                @NonNull ProcessorPmuEventRow r = (ProcessorPmuEventRow)NullChecking.neverNull((Object)((ProcessorPmuEventRow)row));
                @NonNull ProcessorPmuEventPair event = r.getEvent();
                outlineSelected.dropEvent(event);
            }
            outlineAvailable.redraw();
        });
        modelSelected.addListener(new IOutlineModelListener<SimpleColumn>(){

            @Override
            public void rowsAdded(OutlineModel<SimpleColumn> model, Row<SimpleColumn>[] rows) {
                outlineAvailable.adjustScrollBarsForContent();
                outlineAvailable.redraw();
                BarmanSelectEventsPage.this.setPageComplete(modelSelected.getRows().size() > 0);
            }

            @Override
            public void rowsWereRemoved(OutlineModel<SimpleColumn> model, Row<SimpleColumn>[] rows) {
                outlineAvailable.adjustScrollBarsForContent();
                outlineAvailable.redraw();
                BarmanSelectEventsPage.this.setPageComplete(modelSelected.getRows().size() > 0);
            }

            @Override
            public void rowsWillBeRemoved(OutlineModel<SimpleColumn> model, Row<SimpleColumn>[] rows) {
            }

            @Override
            public void selectionDidChange(OutlineModel<SimpleColumn> model) {
            }

            @Override
            public void selectionWillChange(OutlineModel<SimpleColumn> model) {
            }

            @Override
            public void sortCleared(OutlineModel<SimpleColumn> model) {
            }

            @Override
            public void sorted(OutlineModel<SimpleColumn> model, boolean restoring) {
            }
        });
        final DragSource dragSource = new DragSource((Control)outlineAvailable, 1);
        dragSource.setTransfer(new Transfer[]{LocalObjectTransfer.get(Row.class)});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                outlineAvailable.dragFinished(event);
            }

            public void dragSetData(DragSourceEvent event) {
                try {
                    @NonNull LocalObjectTransfer<Row<SimpleColumn>> transfer = this.getDragSourceTransfer();
                    if (transfer.isSupportedType(event.dataType)) {
                        event.data = transfer.getTransferObjects();
                        event.doit = true;
                    } else {
                        event.doit = false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void dragStart(DragSourceEvent event) {
                try {
                    @NonNull LocalObjectTransfer<Row<SimpleColumn>> transfer = this.getDragSourceTransfer();
                    outlineAvailable.setDragStart(event, transfer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            protected @NonNull LocalObjectTransfer<Row<SimpleColumn>> getDragSourceTransfer() throws Exception {
                Transfer @NonNull [] transfers = (Transfer[])NullChecking.neverNull((Object[])dragSource.getTransfer());
                if (transfers.length > 0) {
                    Transfer transfer = transfers[0];
                    return (LocalObjectTransfer)((Object)NullChecking.neverNull((Object)((Object)((LocalObjectTransfer)transfer))));
                }
                throw new Exception("No Transfers item found in collection.");
            }
        });
        dragSource = new DragSource((Control)outlineSelected, 2);
        dragSource.setTransfer(new Transfer[]{LocalObjectTransfer.get(Row.class)});
        DropTarget dropTarget = new DropTarget((Control)outlineAvailable, 2);
        dropTarget.setTransfer(new Transfer[]{LocalObjectTransfer.get(Row.class)});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 2;
                outlineAvailable.setDropHighlight(true);
            }

            public void dragLeave(DropTargetEvent event) {
                outlineAvailable.setDropHighlight(false);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = 2;
                outlineAvailable.setDropHighlight(true);
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 2;
            }

            public void drop(DropTargetEvent event) {
                modelSelected.removeSelection();
                outlineAvailable.setDropHighlight(false);
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.availableModel = modelAvailable;
        this.selectedModel = modelSelected;
        BarmanSelectEventsPage.fillSelectedEvents((SelectedEventsOutlineModel)NullChecking.neverNull((Object)this.selectedModel), this.defaults);
        outlineSelected.adjust();
        this.setControl((Control)composite);
        this.setPageComplete(modelSelected.getRows().size() > 0);
    }

    public IWizardPage getNextPage() {
        if (this.nextPage == null) {
            IWizardPage defaultNextPage;
            this.nextPage = defaultNextPage = (IWizardPage)NullChecking.neverNull((Object)super.getNextPage());
            DataStorageBackend backend = this.configOptionsPage.getDataStorageBackend();
            @NonNull Set<@NonNull ProcessorPmu> pmus = this.getSelectedPmus();
            if (backend != null && backend.equals((Object)DataStorageBackend.ITM_INTERFACE)) {
                boolean hasARProfile = false;
                boolean hasMProfile = false;
                for (ProcessorPmu pmu : pmus) {
                    if (pmu.getProfile().isMProfile()) {
                        hasMProfile = true;
                        continue;
                    }
                    hasARProfile = true;
                }
                if (hasMProfile) {
                    assert (!hasARProfile);
                    if (this.page == null) {
                        @NonNull IWizard wizard = (IWizard)NullChecking.neverNull((Object)this.getWizard());
                        this.page = new BarmanDWTConfigPage(wizard, defaultNextPage, this.defaults);
                    }
                    this.nextPage = this.page;
                }
            }
        }
        return this.nextPage;
    }

    public @Nullable List<@NonNull BarmanProcessorConfiguration> getProcessorsAndEvents() {
        SelectedEventsOutlineModel model = this.selectedModel;
        if (model != null) {
            return BarmanSelectEventsPage.extractProcessorsAndEvents(model);
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillEventsTable(((FilterField)NullChecking.neverNull((Object)this.mFilterField)).getPattern());
            @NonNull BarmanSelectProcessorsPage page = (BarmanSelectProcessorsPage)((Object)NullChecking.neverNull((Object)((Object)((BarmanSelectProcessorsPage)this.getPreviousPage()))));
            if (this.selectedModel != null) {
                this.selectedModel.removeRowsForOtherPmus(page.getSelectedPmus());
            }
            this.nextPage = null;
        }
    }

    protected void fillEventsTable(@Nullable Pattern availableEventsFilterPattern) {
        @NonNull Set<@NonNull ProcessorPmu> pmus = this.getSelectedPmus();
        BarmanSelectEventsPage.fillEventsTable(pmus, this.availableModel, this.selectedModel, availableEventsFilterPattern);
    }

    private void applyFilter(@Nullable Pattern pattern) {
        @NonNull OutlineModel model = (OutlineModel)NullChecking.neverNull(this.availableModel);
        @NonNull PmuAvailableEventsOutline outline = (PmuAvailableEventsOutline)NullChecking.neverNull((Object)this.outlineAvailable);
        outline.setAllowLazyAdjust(false);
        boolean canNotify = model.getSelection().canNotify();
        model.getSelection().setNotify(false);
        this.fillEventsTable(pattern);
        outline.setAllowLazyAdjust(true);
        model.getSelection().setNotify(canNotify);
        outline.adjustScrollBarsForContent();
        outline.redraw();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Set<@NonNull ProcessorPmu> getSelectedPmus() {
        @NonNull BarmanSelectProcessorsPage page = (BarmanSelectProcessorsPage)((Object)NullChecking.neverNull((Object)((Object)((BarmanSelectProcessorsPage)this.getPreviousPage()))));
        @NonNull @NonNull Set pmus = (Set)NullChecking.neverNull(page.getSelectedPmus());
        return pmus;
    }
}

