/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.barmancfg.configuration.DataStorageBackend;
import com.arm.streamline.barmancfg.wizard.BarmanSelectConfigOptionsPage;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.barmancfg.wizard.utils.AbstractDirectoryInputHelper;
import com.arm.streamline.barmancfg.wizard.utils.WizardUtils;
import com.arm.streamline.utility.ui.ILastFilterPathStore;
import com.arm.streamline.utility.ui.SimpleLastFilterPathStore;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BarmanOutputOptionsPage
extends WizardPage {
    public static final String PAGE_NAME = "PAGE_5";
    public static final String PAGE_TITLE = BarmanWizardMessages.PAGE_5_TITLE;
    private static @NonNull ILastFilterPathStore LAST_OUTPUT_PATH = new SimpleLastFilterPathStore();
    protected boolean configGenerateSourceFiles = true;
    protected boolean configSaveConfigFile = true;
    protected @Nullable File configSaveLocation;
    private BarmanSelectConfigOptionsPage configOptionsPage;
    private Button saveConfigFile;

    public BarmanOutputOptionsPage(@Nullable File defaultOutputPath, BarmanSelectConfigOptionsPage configOptionsPage) {
        super(PAGE_NAME, PAGE_TITLE, null);
        this.configOptionsPage = configOptionsPage;
        this.configSaveLocation = defaultOutputPath;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Button generateSourceFiles = WizardUtils.addCheckbox(composite, BarmanWizardMessages.PAGE_5_LABEL_GEN_SOURCE_FILES, BarmanWizardMessages.PAGE_5_TOOLTIP_GEN_SOURCE_FILES, b -> {
            this.configGenerateSourceFiles = b;
            this.validateComplete();
            return b;
        });
        generateSourceFiles.setSelection(this.configGenerateSourceFiles);
        this.saveConfigFile = WizardUtils.addCheckbox(composite, BarmanWizardMessages.PAGE_5_LABEL_GEN_XML_FILE, BarmanWizardMessages.PAGE_5_TOOLTIP_GEN_XML_FILE, b -> {
            this.configSaveConfigFile = b;
            this.validateComplete();
            return b;
        });
        File configSaveLocation = this.configSaveLocation;
        String defaultValue = configSaveLocation != null ? configSaveLocation.getAbsolutePath() : null;
        WizardUtils.addDirectoryInput(composite, BarmanWizardMessages.PAGE_5_LABEL_SAVE_PATH, BarmanWizardMessages.PAGE_5_TOOLTIP_SAVE_PATH, BarmanWizardMessages.PAGE_5_TOOLTIP_SET_SAVE_PATH, defaultValue, new AbstractDirectoryInputHelper(LAST_OUTPUT_PATH){

            @Override
            protected @Nullable File handleValidatedInputChanged(@NonNull File currentValue) {
                BarmanOutputOptionsPage.this.configSaveLocation = currentValue;
                BarmanOutputOptionsPage.this.validateComplete();
                return currentValue;
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(false);
        this.validateComplete();
    }

    public @Nullable File getOutputPath() {
        return this.configSaveLocation;
    }

    public boolean isGenerateSourceFiles() {
        return this.configGenerateSourceFiles;
    }

    public boolean isSaveConfigFile() {
        return this.configSaveConfigFile;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.configOptionsPage.getDataStorageBackend() == DataStorageBackend.STM_INTERFACE) {
                this.configSaveConfigFile = true;
                this.saveConfigFile.setEnabled(false);
            } else {
                this.saveConfigFile.setEnabled(true);
            }
            this.saveConfigFile.setSelection(this.configSaveConfigFile);
        }
    }

    protected void validateComplete() {
        File configSaveLocation = this.configSaveLocation;
        this.setPageComplete(configSaveLocation != null && configSaveLocation.exists() && configSaveLocation.isDirectory() && (this.configGenerateSourceFiles || this.configSaveConfigFile));
    }
}

