/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.frames.objects;

import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.frames.IBarmanSerializableFrame;
import com.arm.streamline.barman.v1.BarmanRecordType;
import com.arm.utils.NullChecking;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EventCounterWithoutTaskId
implements IBarmanSerializableFrame {
    private final long timestamp;
    private final int core;
    private final int eventId;
    private final long counterValue;

    public EventCounterWithoutTaskId(long timestamp, int core, int eventId, long counterValue) {
        this.timestamp = timestamp;
        this.core = core;
        this.eventId = eventId;
        this.counterValue = counterValue;
    }

    @Override
    public byte @NonNull [] serializeRecord(@NonNull BarmanTypeAndVersion typeAndVersion) {
        ByteOrder byteOrder = typeAndVersion.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        int length = 28;
        ByteBuffer buffer = ByteBuffer.allocate(28).order(byteOrder);
        buffer.putInt(BarmanRecordType.EVENT_COUNTER_WITHOUT_TASK_ID.getValue());
        buffer.putInt(this.core);
        buffer.putLong(this.timestamp);
        buffer.putInt(this.eventId);
        buffer.putLong(this.counterValue);
        return (byte[])NullChecking.neverNull((Object)buffer.array());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getCore() {
        return this.core;
    }

    public int getEventId() {
        return this.eventId;
    }

    public long getCounterValue() {
        return this.counterValue;
    }

    @Override
    public byte @Nullable [] getRawFrameData() {
        return null;
    }

    @Override
    public @Nullable Long getTimestampOverride() {
        return null;
    }
}

