/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.frames;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.IBarmanHeader;
import com.arm.streamline.barman.frames.IBarmanFrameConsumer;
import com.arm.streamline.barman.frames.IBarmanSerializableFrame;
import com.arm.streamline.barman.frames.UncheckedBarmanDecodeException;
import com.arm.streamline.barman.v1.BarmanRecordType;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.utils.NullChecking;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanFrameSorter
implements Consumer<IBarmanSerializableFrame> {
    private @Nullable Boolean assumedBigEndian = null;
    private final @NonNull Events events;
    private final @NonNull IBarmanFrameConsumer frameConsumer;
    private @Nullable Header headerFrame = null;
    private final @NonNull Map<Integer, ProcessorPmu> pmus;
    private final @NonNull List<IBarmanSerializableFrame> recordBuffer = new ArrayList<IBarmanSerializableFrame>();

    public BarmanFrameSorter(@NonNull Map<Integer, ProcessorPmu> pmus, @NonNull Events events, @NonNull IBarmanFrameConsumer frameConsumer) {
        this.pmus = pmus;
        this.events = events;
        this.frameConsumer = frameConsumer;
    }

    @Override
    public void accept(@NonNull IBarmanSerializableFrame frame) {
        try {
            byte @Nullable [] rawData = frame.getRawFrameData();
            if (rawData != null) {
                BarmanTypeAndVersion typeAndVersion = BarmanTypeAndVersion.detectTypeAndVersion(rawData);
                if (typeAndVersion != null) {
                    this.processHeaderFrame(typeAndVersion, rawData, frame.getTimestampOverride());
                } else {
                    this.processDataFrame(frame);
                }
            } else {
                this.consumeRecord(frame);
            }
        }
        catch (IOException e) {
            throw new UncheckedBarmanDecodeException(DocumentsMessages.IMPORT_ERROR_EXCEPTION, e);
        }
    }

    public int getNumberOfRecordsStashed() {
        return this.recordBuffer.size();
    }

    public boolean foundHeader() {
        return this.headerFrame != null;
    }

    private void consumeRecord(@NonNull IBarmanSerializableFrame frame) throws IOException {
        @Nullable Header headerFrame = this.headerFrame;
        if (headerFrame != null) {
            @NonNull BarmanTypeAndVersion typeAndVersion = headerFrame.headerObject.getTypeAndVersion();
            this.flushFrames(typeAndVersion);
            this.frameConsumer.consumeRecord(frame.serializeRecord(typeAndVersion));
        } else {
            this.recordBuffer.add(frame);
        }
    }

    private void flushFrames(@NonNull BarmanTypeAndVersion typeAndVersion) throws IOException {
        if (!this.recordBuffer.isEmpty()) {
            for (IBarmanSerializableFrame frame : this.recordBuffer) {
                this.frameConsumer.consumeRecord(frame.serializeRecord(typeAndVersion));
            }
            this.recordBuffer.clear();
        }
    }

    private void processDataFrame(@NonNull IBarmanSerializableFrame frameObject) throws IOException {
        byte @NonNull [] frame = (byte[])NullChecking.neverNull((Object)frameObject.getRawFrameData());
        if (frame.length >= 16) {
            BarmanTypeAndVersion lastHeaderTypeAndVersion;
            ByteBuffer buffer = ByteBuffer.wrap(frame);
            Boolean assumedBigEndian = this.assumedBigEndian;
            Header headerFrame = this.headerFrame;
            BarmanTypeAndVersion barmanTypeAndVersion = lastHeaderTypeAndVersion = headerFrame != null ? headerFrame.headerObject.getTypeAndVersion() : null;
            ByteOrder order = lastHeaderTypeAndVersion != null ? lastHeaderTypeAndVersion.getByteOrder() : (assumedBigEndian != null && assumedBigEndian != false ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            buffer.order(order);
            BarmanRecordType recordType = BarmanRecordType.fromInt(buffer.getInt());
            if (recordType == null) {
                if (lastHeaderTypeAndVersion != null || assumedBigEndian != null) {
                    throw new UncheckedBarmanDecodeException(DocumentsMessages.UNRECOGNIZED_FRAME_FOUND);
                }
                buffer.order(ByteOrder.BIG_ENDIAN);
                buffer.position(0);
                BarmanRecordType recordTypeBigEndian = BarmanRecordType.fromInt(buffer.getInt());
                if (recordTypeBigEndian == null) {
                    throw new UncheckedBarmanDecodeException(DocumentsMessages.UNRECOGNIZED_FRAME_FOUND);
                }
                this.assumedBigEndian = Boolean.TRUE;
            } else {
                this.assumedBigEndian = order == ByteOrder.BIG_ENDIAN;
            }
        } else {
            throw new UncheckedBarmanDecodeException(DocumentsMessages.UNRECOGNIZED_FRAME_FOUND);
        }
        this.consumeRecord(frameObject);
    }

    private void processHeaderFrame(@NonNull BarmanTypeAndVersion typeAndVersion, byte @NonNull [] frame, @Nullable Long timestamp) {
        try {
            BarmanTypeAndVersion lastHeaderTypeAndVersion;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(frame);
            inputStream.skip(typeAndVersion.getDataOffset());
            IBarmanHeader header = typeAndVersion.getHeader(this.pmus, this.events, inputStream);
            Boolean assumedBigEndian = this.assumedBigEndian;
            Header headerFrame = this.headerFrame;
            BarmanTypeAndVersion barmanTypeAndVersion = lastHeaderTypeAndVersion = headerFrame != null ? headerFrame.headerObject.getTypeAndVersion() : null;
            if (lastHeaderTypeAndVersion != null && !lastHeaderTypeAndVersion.equals(typeAndVersion)) {
                throw new UncheckedBarmanDecodeException(DocumentsMessages.INCONSISTENT_HEADERS);
            }
            if (assumedBigEndian != null && assumedBigEndian.booleanValue() != typeAndVersion.isBigEndian()) {
                throw new UncheckedBarmanDecodeException(DocumentsMessages.UNRECOGNIZED_FRAME_FOUND);
            }
            if (headerFrame == null || timestamp != null && timestamp >= headerFrame.timestamp || timestamp == null && header.getLastTimestamp() >= headerFrame.headerObject.getLastTimestamp()) {
                this.headerFrame = new Header(header, timestamp);
                this.assumedBigEndian = typeAndVersion.isBigEndian();
                this.frameConsumer.consumeHeader(header, frame);
                this.flushFrames(typeAndVersion);
            }
        }
        catch (BarmanDataError | IOException e) {
            throw new UncheckedBarmanDecodeException(DocumentsMessages.UNRECOGNIZED_FRAME_FOUND);
        }
    }

    private static class Header {
        public final @NonNull IBarmanHeader headerObject;
        public final long timestamp;

        public Header(@NonNull IBarmanHeader headerObject, @Nullable Long timestamp) {
            this.headerObject = headerObject;
            this.timestamp = timestamp != null ? timestamp.longValue() : headerObject.getLastTimestamp();
        }
    }
}

