/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.streamline.analysis.gator.BacktraceProcessing;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.barman.IBarmanHeader;
import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.utils.NullChecking;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanCaptureDetails
implements ICaptureDetails {
    private final @NonNull File apcDirectory;
    private final @NonNull IBarmanHeader header;

    public BarmanCaptureDetails(@NonNull File apcDirectory, @NonNull IBarmanHeader header) {
        this.apcDirectory = apcDirectory;
        this.header = header;
    }

    @Override
    public BacktraceProcessing getBacktraceProcessing() {
        return BacktraceProcessing.NONE;
    }

    @Override
    public @NonNull CaptureSubType getCaptureSubType() {
        return CaptureSubType.DEFAULT;
    }

    @Override
    public @Nullable CounterRecord getCounter(int key) {
        throw new AssertionError();
    }

    @Override
    public @NonNull List<@NonNull CounterRecord> getCounterList() {
        return this.header.getCounters().getCounterRecords();
    }

    @Override
    public @Nullable CounterRecord getDerivedCounter(String type) {
        return null;
    }

    @Override
    public @Nullable EventBasedSampleInfo getEBSInfo() {
        return null;
    }

    @Override
    public @NonNull ProtocolInfo getProtocolInfo() {
        return new ProtocolInfo(ProtocolType.BARMAN, this.header.getTypeAndVersion().getVersionNo(), this.header.getTypeAndVersion().getVersionNo(), "");
    }

    @Override
    public @NonNull String @NonNull [] getInvalidCounters() {
        return new String[0];
    }

    @Override
    public String getName() {
        return this.header.getTargetDescription();
    }

    @Override
    public String getGPUPublicName() {
        return "";
    }

    @Override
    public int getNumberOfCores() {
        return this.header.getCoreCount();
    }

    @Override
    public String getPath() {
        return (String)NullChecking.neverNull((Object)this.apcDirectory.getAbsolutePath());
    }

    @Override
    public long getSampleIntervalNanoSeconds() {
        long timerRateHz = (long)this.header.getTimerSampleRateHz() & 0xFFFFFFFFL;
        return timerRateHz > 0L ? 1000000000L / timerRateHz : 0L;
    }

    @Override
    public @NonNull Set<@NonNull SpeCaptureRecord> getSpes() {
        return Collections.emptySet();
    }

    @Override
    public @NonNull TimeUnit getTimeUnit() {
        return TimeUnit.NANO_SECONDS;
    }

    @Override
    public boolean hasBeenRecordedOnTarget() {
        return true;
    }

    @Override
    public boolean hasDerivedCounterOfType(String type) {
        return false;
    }

    @Override
    public boolean hasArmNNCounters() {
        return false;
    }

    @Override
    public boolean hasMaliCounters() {
        return false;
    }

    @Override
    public boolean isCallStackUnwindingSupported() {
        return false;
    }

    @Override
    public boolean supportsSelectableCPUActivityPerCluster() {
        return true;
    }

    @Override
    public @Nullable Integer getGpuCoresCount() {
        return 0;
    }

    @Override
    public @Nullable String getGatordMd5Sum() {
        return null;
    }

    @Override
    public @Nullable String getGatordBuildId() {
        return null;
    }

    @Override
    public boolean isAtraceEnabled() {
        return false;
    }
}

