/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.analysis.session.IFinalWriter;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.barman.BarmanCaptureDetails;
import com.arm.streamline.barman.BarmanClustersInfo;
import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanDurationTracker;
import com.arm.streamline.barman.BarmanMessages;
import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.IBarmanHeader;
import com.arm.streamline.capture.SimpleAnalysisSettings;
import com.arm.streamline.capture.apc.APCDatabaseGenerator;
import com.arm.streamline.common.IErrorHandler;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.Warnings;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.streamline.databrowser.Capture;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.databrowser.IOpenable;
import com.arm.streamline.databrowser.IProgressObserver;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.SampleRate;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanCapture
extends Capture {
    public static final @NonNull String BARMAN_RAW_NAME = "barman.raw";
    protected final @NonNull BarmanDurationTracker durationTracker;
    private final @NonNull SimpleAnalysisSettings analysisSettings;
    private final @NonNull File barmanRawFile;
    private final @Nullable ICaptureDetails captureDetails;
    private final @Nullable IBarmanHeader header;

    public static boolean isBarmanCapture(@NonNull File apcDirectory) {
        File barmanRaw = new File(apcDirectory, BARMAN_RAW_NAME);
        return barmanRaw.exists() && barmanRaw.isFile();
    }

    public static @Nullable ICapture tryCreateFor(@NonNull File apcDirectory) {
        File barmanRaw = new File(apcDirectory, BARMAN_RAW_NAME);
        if (barmanRaw.exists() && barmanRaw.isFile()) {
            return new BarmanCapture(apcDirectory);
        }
        return null;
    }

    private static @Nullable IBarmanHeader getFileHeader(@NonNull File barmanRawFile) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream inputStream = new FileInputStream(barmanRawFile);){
                BarmanTypeAndVersion typeAndVersion = BarmanTypeAndVersion.detectTypeAndVersion(inputStream);
                IBarmanHeader iBarmanHeader = typeAndVersion != null ? typeAndVersion.getHeader(EventsAndPmusXml.getPmus((File)barmanRawFile), EventsAndPmusXml.getEvents((File)barmanRawFile), inputStream) : null;
                return iBarmanHeader;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BarmanDataError | IOException e) {
            return null;
        }
    }

    public BarmanCapture(@NonNull File apcDirectory) {
        super(apcDirectory);
        this.durationTracker = new BarmanDurationTracker(new File(apcDirectory, "report/barman.xml"));
        this.analysisSettings = new SimpleAnalysisSettings(new File(apcDirectory, "report/analysis-settings.xml"), ResolutionMode.NORMAL, this);
        this.barmanRawFile = new File(apcDirectory, BARMAN_RAW_NAME);
        this.header = BarmanCapture.getFileHeader(this.barmanRawFile);
        this.captureDetails = this.header != null ? new BarmanCaptureDetails(apcDirectory, this.header) : null;
    }

    @Override
    public @NonNull IAnalysisInputSettings getAnalysisSettings() {
        return this.analysisSettings;
    }

    @Override
    public long getCreatedOnSeconds() {
        IBarmanHeader localHeader;
        long createdTimestampSeconds;
        if (this.header != null && (createdTimestampSeconds = (localHeader = (IBarmanHeader)NullChecking.neverNull((Object)this.header)).getCreatedUnixTimestampSeconds()) > 0L) {
            return createdTimestampSeconds;
        }
        return CommonFileUtils.getCreatedModifiedOrAccessedTimeInSeconds((File)this.barmanRawFile);
    }

    @Override
    public long getDurationInTimeUnits() {
        return this.durationTracker.getDurationInNanosecs();
    }

    @Override
    public @NonNull String getHumanReadableVersion() {
        if (this.header != null) {
            IBarmanHeader localHeader = (IBarmanHeader)NullChecking.neverNull((Object)this.header);
            return (String)NullChecking.neverNull((Object)String.format("Barman V%s", localHeader.getTypeAndVersion().getVersionNo()));
        }
        return (String)NullChecking.neverNull((Object)BarmanMessages.UNKNOWN_VERSION);
    }

    @Override
    public @Nullable String getInvalidReason() {
        if (this.header == null) {
            return MessageFormat.format(BarmanMessages.INVALID_BARMAN_RAW_DATA, BARMAN_RAW_NAME);
        }
        return null;
    }

    @Override
    public @Nullable ProtocolInfo getProtocolInfo() {
        return (ProtocolInfo)NullChecking.applyIfNonNull((Object)this.captureDetails, ICaptureDetails::getProtocolInfo);
    }

    @Override
    public @Nullable ResolutionMode getResolutionMode() {
        return null;
    }

    @Override
    public @NonNull SampleRate getSampleRate() {
        return SampleRate.NORMAL;
    }

    @Override
    public @NonNull String getTargetDescription() {
        IBarmanHeader localHeader = this.header;
        if (localHeader != null) {
            return localHeader.getTargetDescription();
        }
        return (String)NullChecking.neverNull((Object)DocumentsMessages.UNKNOWN_BARMAN_DEVICE);
    }

    @Override
    public @Nullable TimeUnit getTimeUnit() {
        return (TimeUnit)NullChecking.applyIfNonNull((Object)this.captureDetails, ICaptureDetails::getTimeUnit);
    }

    @Override
    public boolean isDataMissing() {
        return false;
    }

    @Override
    public boolean isJitDumpProfilingSupported() {
        return false;
    }

    @Override
    public boolean isShouldAlwaysDeleteDB() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.header != null;
    }

    @Override
    public boolean usesEBS() {
        ICaptureDetails localCaptureDetails = this.captureDetails;
        return localCaptureDetails != null ? localCaptureDetails.getEBSInfo() != null : false;
    }

    @Override
    public void analyze(final @NonNull IAnalysisInputSettings analysisSettings, @NonNull SessionProcessor sessionProcessor, @Nullable IOpenable captureToOpen, @NonNull IProgressObserver observer, @NonNull IErrorHandler errorHandler, boolean openResult) {
        try {
            IBarmanHeader localHeader = (IBarmanHeader)NullChecking.neverNull((Object)this.header);
            ICaptureDetails localCaptureDetails = (ICaptureDetails)NullChecking.neverNull((Object)this.captureDetails);
            this.setStopHandler(sessionProcessor, observer);
            @NonNull File reportDir = new File(this.getApcDirectory(), "report");
            String outputPath = (String)NullChecking.neverNull((Object)reportDir.getAbsolutePath());
            String capturePath = (String)NullChecking.neverNull((Object)this.getApcDirectory().getAbsolutePath());
            @NonNull Warnings captureWarnings = new Warnings();
            BarmanClustersInfo clustersInfo = localHeader.getClustersInfo();
            boolean is64Bit = localHeader.getTypeAndVersion().isBits64();
            IFinalWriter finalWriter = new IFinalWriter(){

                @Override
                public void writeXML(@NonNull String outputPath) {
                    try {
                        analysisSettings.save();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    BarmanCapture.this.durationTracker.save();
                }
            };
            try {
                APCDatabaseGenerator dbGenerator = new APCDatabaseGenerator();
                boolean durationLimitInSecs = false;
                TargetAddressString targetAddress = null;
                SampleRate sampleRate = null;
                sessionProcessor.produceReport(analysisSettings, capturePath, outputPath, is64Bit, (IWarnings)captureWarnings, (IClustersInfo)clustersInfo, localCaptureDetails, finalWriter, dbGenerator, 0, targetAddress, sampleRate, this, captureToOpen, observer, openResult, null);
            }
            catch (Throwable throwable) {
                errorHandler.reportError(throwable);
            }
        }
        finally {
            observer.removeFromInProgress(this);
        }
    }
}

