/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.preferences;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.PreferencesMessages;
import java.text.MessageFormat;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DebugLabelConfig
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int MAX_STACK_SEPARATOR_LENGTH = 5;

    public DebugLabelConfig() {
        super(1);
        this.setPreferenceStore(StreamlinePlugin.getInstance().getPreferenceStore());
        this.setDescription(PreferencesMessages.DEBUG_LABEL_CONFIG_DESCRIPTION);
    }

    public void init(IWorkbench workbench) {
    }

    private Control addBooleanFieldEditor(String name, String text, Composite parent) {
        BooleanFieldEditor editor = new BooleanFieldEditor(name, text, parent);
        editor.fillIntoGrid(parent, 2);
        this.addField((FieldEditor)editor);
        Control ctrl = editor.getDescriptionControl(parent);
        return ctrl;
    }

    private void addPresentationModeSelector(Composite parent) {
        String[][] labelAndValues = new String[][]{{PreferencesMessages.PRESENTATION_MODE_STACK_LABEL, "com.arm.streamline.presentation_mode_stack"}, {PreferencesMessages.PRESENTATION_MODE_LEAF_LABEL, "com.arm.streamline.presentation_mode_leaf"}};
        RadioGroupFieldEditor presentationModeEditor = new RadioGroupFieldEditor("com.arm.streamline.presentation_mode_option", PreferencesMessages.PRESENTATION_MODE_LABEL, 1, labelAndValues, parent, true);
        this.addField((FieldEditor)presentationModeEditor);
    }

    private void addStackSeparatorEditor(Composite parent) {
        StringFieldEditor editor = new StringFieldEditor("com.arm.streamline.stack_separator", PreferencesMessages.STACK_SEPARATOR_LABEL, parent){

            protected boolean doCheckState() {
                String value = this.getStringValue();
                if (value == null || value.trim().isEmpty()) {
                    this.setErrorMessage(PreferencesMessages.STACK_SEPARATOR_EMPTY_ERROR_MESSSAGE);
                    return false;
                }
                if (value.length() > 5) {
                    String msg = MessageFormat.format(PreferencesMessages.STACK_SEPARATOR_TOO_LONG, 5);
                    this.setErrorMessage(msg);
                    return false;
                }
                this.clearErrorMessage();
                return true;
            }
        };
        editor.getLabelControl(parent).setToolTipText(PreferencesMessages.STACK_SEPARATOR_LABEL_TOOLTIP);
        editor.getTextControl(parent).setToolTipText(PreferencesMessages.STACK_SEPARATOR_TEXTBOX_TOOLTIP);
        this.addField((FieldEditor)editor);
    }

    private void addContractionModeEditor(Composite parent) {
        String[][] labelAndValues = new String[][]{{PreferencesMessages.CONTRACTION_MODE_LEFT_LABEL, "com.arm.streamline.contraction_mode_left"}, {PreferencesMessages.CONTRACTION_MODE_RIGHT_LABEL, "com.arm.streamline.contraction_mode_right"}, {PreferencesMessages.CONTRACTION_MODE_BOTH_LABEL, "com.arm.streamline.contraction_mode_both"}};
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor("com.arm.streamline.contraction_mode", PreferencesMessages.CONTRACTION_MODE_LABEL, 1, labelAndValues, parent, true);
        this.addField((FieldEditor)editor);
    }

    private void addContractedLengthEditor(Composite parent) {
        IntegerFieldEditor editor = new IntegerFieldEditor("com.arm.streamline.contracted_length", PreferencesMessages.CONTRACTED_LENGTH_LABEL, parent);
        Text text = editor.getTextControl(parent);
        text.addVerifyListener(e -> {
            String newText = text.getText().substring(0, e.start) + e.text + text.getText().substring(e.end);
            if (!newText.matches("\\d*")) {
                e.doit = false;
            }
        });
        text.addModifyListener(e -> {
            String val = text.getText();
            if (!val.isEmpty()) {
                try {
                    int value = Integer.parseInt(val);
                    if (value < 1) {
                        text.setText("1");
                    } else if (value > 1000) {
                        text.setText("1000");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        editor.getLabelControl(parent).setToolTipText(PreferencesMessages.CONTRACTED_LENGTH_LABEL_TOOLTIP);
        editor.getTextControl(parent).setToolTipText(PreferencesMessages.CONTRACTED_LENGTH_TEXTBOX_TOOLTIP);
        this.addField((FieldEditor)editor);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Group group = new Group(parent, 0);
        group.setText(PreferencesMessages.DEBUG_LABEL_CONFIGURATION_GROUP_TITLE);
        FillLayout layout = new FillLayout();
        group.setLayout((Layout)layout);
        layout.marginHeight = 9;
        layout.marginWidth = 9;
        GridDataFactory.defaultsFor((Control)group).grab(true, false).span(2, 1).applyTo((Control)group);
        Composite container = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(container);
        this.addBooleanFieldEditor("com.arm.streamline.discard_root_label_in_stack_option", PreferencesMessages.DISCARD_ROOT_LABEL_IN_STACK_LABEL, container);
        this.addBooleanFieldEditor("com.arm.streamline.discard_leaf_label_in_stack_option", PreferencesMessages.DISCARD_LEAF_LABEL_IN_STACK_LABEL, container);
        this.addPresentationModeSelector(container);
        this.addStackSeparatorEditor(container);
        this.addContractionModeEditor(container);
        this.addContractedLengthEditor(container);
    }
}

