/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application;

import com.arm.streamline.application.BundleURLResolver;
import com.arm.streamline.application.DynamicVariableResolver;
import com.arm.streamline.application.GatorBinaryId;
import com.arm.streamline.application.PluginVersion;
import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.databrowser.DeviceConnectionModel;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.browser.UdpTargetBrowserService;
import com.arm.streamline.hacks.FixBadWorkbenchXmi;
import com.arm.streamline.utility.io.Images;
import com.arm.util.URLResolver;
import com.arm.util.libs.IURLResolver;
import com.arm.utils.NullChecking;
import com.arm.utils.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.framework.BundleContext;

public class StreamlinePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.arm.streamline";
    private static final String[] BUSY_IMAGES = new String[]{"Throbber-1.gif", "Throbber-2.gif", "Throbber-3.gif", "Throbber-4.gif", "Throbber-5.gif", "Throbber-6.gif", "Throbber-7.gif", "Throbber-8.gif"};
    private static Cursor CLOSED_HAND_CURSOR;
    private static final @NonNull File INSTALL_DIR;
    private static StreamlinePlugin INSTANCE;
    private static Cursor OPEN_HAND_CURSOR;
    private PluginVersion mVersion;

    static {
        INSTALL_DIR = CommonPlugin.getInstallDir();
    }

    public static final File getBinPath() {
        File bin = new File(INSTALL_DIR, "bin");
        String osArch = System.getProperty("os.arch").toLowerCase();
        int bits = osArch.equals("x86") || osArch.equals("i386") ? 32 : 64;
        String osName = System.getProperty("os.name").toLowerCase();
        Object arch = osName.startsWith("mac") ? "mac" : (osName.startsWith("win") ? "win-" + bits : (osName.startsWith("linux") ? "linux-" + bits : "unknown"));
        return new File(bin, (String)arch);
    }

    public static Image getBusyImage(int which) {
        return StreamlinePlugin.getImage(BUSY_IMAGES[which % BUSY_IMAGES.length]);
    }

    public static int getBusyImageCount() {
        return BUSY_IMAGES.length;
    }

    public static ImageDescriptor getBusyImageDescriptor(int which) {
        return StreamlinePlugin.getImageDescriptor(BUSY_IMAGES[which % BUSY_IMAGES.length]);
    }

    public static Cursor getClosedHandCursor() {
        if (CLOSED_HAND_CURSOR == null) {
            CLOSED_HAND_CURSOR = new Cursor((Device)Display.getCurrent(), StreamlinePlugin.getImage("ClosedHand.gif").getImageData(), 8, 8);
        }
        return CLOSED_HAND_CURSOR;
    }

    public static Image getColorizedImage(String name, RGB color) {
        String key = name + color.toString();
        Image img = StreamlinePlugin.getImage(key);
        if (img == null && (img = StreamlinePlugin.getImage(name)) != null) {
            ImageData imageData = img.getImageData();
            int[] pixels = new int[imageData.width];
            int y = 0;
            while (y < imageData.height) {
                imageData.getPixels(0, y, imageData.width, pixels, 0);
                int x = 0;
                while (x < imageData.width) {
                    int argb = pixels[x];
                    int darkenBy = (int)(((double)(argb >> 16 & 0xFF) * 0.3 + (double)(argb >> 8 & 0xFF) * 0.59 + (double)(argb & 0xFF) * 0.11) / 2.55);
                    pixels[x] = argb & 0xFF000000 | color.red * darkenBy / 100 << 16 | color.green * darkenBy / 100 << 8 | color.blue * darkenBy / 100;
                    ++x;
                }
                imageData.setPixels(0, y, imageData.width, pixels, 0);
                ++y;
            }
            img = new Image(img.getDevice(), imageData);
            StreamlinePlugin.getInstance().getImageRegistry().put(key, img);
        }
        return img;
    }

    public static final String getDefaultTargetSetupScriptPath() {
        return new File((File)NullChecking.neverNull((Object)((File)NullChecking.neverNull((Object)StreamlinePlugin.getBinPath().getParentFile())).getParentFile()), "gator/setup/gator_setup").getAbsolutePath();
    }

    public static final File getExamplesPath() {
        return new File(INSTALL_DIR, "examples");
    }

    public static final File getExecutable(String name) {
        File batch;
        Platform platform;
        File dir = StreamlinePlugin.getBinPath();
        File file = new File(dir, name + (platform = Platform.getPlatform()).getExecutableExtension());
        if ((!file.isFile() || !file.canRead()) && (batch = new File(dir, name + platform.getBatchExtension())).isFile() && batch.canRead()) {
            file = batch;
        }
        return file;
    }

    public static final @NonNull File getGatord(@NonNull GatorBinaryId binary) throws FileNotFoundException {
        File devGatord;
        File devGatord2;
        File gatord = Paths.get(INSTALL_DIR.getAbsolutePath(), "bin", binary.os, binary.arch, "gatord").toFile();
        if (gatord.isFile()) {
            return gatord;
        }
        String propPath = System.getProperty(String.format("streamline.gatord.%s.%s", binary.os, binary.arch));
        if (propPath != null && (devGatord2 = new File(propPath)).isFile()) {
            return devGatord2;
        }
        String envPath = System.getenv(String.format("STREAMLINE_GATORD_%s_%s", binary.os, binary.arch).toUpperCase());
        if (envPath != null && (devGatord = new File(envPath)).isFile()) {
            return devGatord;
        }
        throw new FileNotFoundException("Could not find a suitable gatord executable.");
    }

    public static Image getImage(String name) {
        return StreamlinePlugin.getInstance().getImageRegistry().get(name);
    }

    public static Image getDisabledImage(String name) {
        @NonNull String disabled_key = name + "_img_disabled";
        ImageRegistry imageRegistry = StreamlinePlugin.getInstance().getImageRegistry();
        if (imageRegistry.get(disabled_key) == null) {
            imageRegistry.put(disabled_key, new Image((Device)Display.getCurrent(), StreamlinePlugin.getImage(name), 1));
        }
        return imageRegistry.get(disabled_key);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return StreamlinePlugin.getInstance().getImageRegistry().getDescriptor(name);
    }

    public static StreamlinePlugin getInstance() {
        return INSTANCE;
    }

    public static Cursor getOpenHandCursor() {
        if (OPEN_HAND_CURSOR == null) {
            OPEN_HAND_CURSOR = new Cursor((Device)Display.getCurrent(), StreamlinePlugin.getImage("OpenHand.png").getImageData(), 8, 8);
        }
        return OPEN_HAND_CURSOR;
    }

    public static final @NonNull PluginVersion getVersion() {
        StreamlinePlugin self = StreamlinePlugin.getInstance();
        if (self.mVersion == null) {
            self.mVersion = new PluginVersion((Plugin)self);
        }
        return self.mVersion;
    }

    public static final void info(String msg) {
        StdLog.info((Plugin)StreamlinePlugin.getInstance(), (String)msg, (Throwable)new Throwable());
    }

    public static final void info(String msg, Throwable throwable) {
        StdLog.info((Plugin)StreamlinePlugin.getInstance(), (String)msg, (Throwable)throwable);
    }

    public static final void info(Throwable throwable) {
        StdLog.info((Plugin)StreamlinePlugin.getInstance(), null, (Throwable)throwable);
    }

    public static final void warning(String msg) {
        StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)msg, (Throwable)new Throwable());
    }

    public static final void warning(String msg, Throwable throwable) {
        StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)msg, (Throwable)throwable);
    }

    public static final void warning(Throwable throwable) {
        StdLog.warning((Plugin)StreamlinePlugin.getInstance(), null, (Throwable)throwable);
    }

    private static void setInstance(StreamlinePlugin plugin) {
        INSTANCE = plugin;
    }

    public void start(BundleContext context) throws Exception {
        StreamlinePlugin.setInstance(this);
        super.start(context);
        URLResolver.addURLResolver((IURLResolver)new BundleURLResolver());
        StreamlinePreferences.initialize();
        DynamicVariableResolver.initialize();
        TargetAuthentication.loadCache();
        if (!WorkspaceUtils.isHeadless()) {
            FixBadWorkbenchXmi.fixIfNeeded();
        }
    }

    public void stop(BundleContext context) throws Exception {
        UdpTargetBrowserService.get().close();
        DocumentScanner.INSTANCE.stop();
        DeviceConnectionModel.save();
        TargetAuthentication.saveCache();
        SWTResourceManager.dispose();
        StreamlinePlugin.setInstance(null);
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        Images.registerImages(StreamlineImages.class, reg, PLUGIN_ID);
    }
}

