/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.EventsChart;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.model.CounterRecordUtils;
import com.arm.streamline.analysis.processor.timeline.ThreadActivityEntry;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.model.chart.SeriesAliasUtils;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.CounterRecordFile;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.LittleEndianDataOutputStream;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.OptionalUtils;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ThreadActivity
extends AnalysisBase {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream activityStream;
    private final int clusterCount;
    private final @NonNull File @NonNull [] @NonNull [] counterPathsByClusterByActivity;
    private final @NonNull ICaptureDetails mCaptureDetails;
    private final @NonNull EventsChart mChartFile;
    private final @NonNull List<CounterRecord> mCounterRecordsList;
    private final long mDuration;
    private final @NonNull List<@NonNull ThreadActivityEntry> mEntries = new ArrayList<ThreadActivityEntry>();
    private final @NonNull File @NonNull [] mHeatmapPathsByActivity;
    private long mLastTime;
    private final int[] mTicksPerScale;
    private final @NonNull ToIntFunction<@NonNull ProcessingElementReference> mPeReferenceToClusterNumber;
    private final long mTimebase;
    private final int[] mTimeScale;
    private final @NonNull IUniqueIds mUniqueIds;
    private final boolean splitCpuByCluster;
    private final boolean generateHeatMapData;

    private static @NonNull File @NonNull [] @NonNull [] makeCounterDataPaths(@NonNull File @NonNull [] @NonNull [] directories, int scaleSuffix) {
        return (File[][])ArrayUtils.create(n -> new File[n][], (int)directories.length, i0 -> (File[])ArrayUtils.create(File[]::new, (int)directories[i0].length, i1 -> new File(directories[i0][i1], String.format("average_%d.bin", scaleSuffix))));
    }

    private static @NonNull File @NonNull [] makeHeatmapDataPaths(@NonNull File @NonNull [] directories, int scaleSuffix) {
        return (File[])ArrayUtils.create(File[]::new, (int)directories.length, i -> new File(directories[i], String.format("data_%d.bin", scaleSuffix)));
    }

    private static void output(ThreadActivityEntry entry) throws IOException {
        entry.normalize();
        entry.output();
    }

    public ThreadActivity(SessionSettings settings, @NonNull SessionProcessor sp, int clusterCount, @NonNull ToIntFunction<@NonNull ProcessingElementReference> peReferenceToClusterNumber, @NonNull ICaptureDetails captureDetails, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream activityStream) {
        super(sp);
        int numClusters;
        this.activityStream = activityStream;
        this.clusterCount = clusterCount;
        this.mUniqueIds = (IUniqueIds)NullChecking.neverNull((Object)sp.getUniqueIds());
        this.mPeReferenceToClusterNumber = peReferenceToClusterNumber;
        this.mCounterRecordsList = captureDetails.getCounterList();
        this.mCaptureDetails = captureDetails;
        this.progress(0);
        this.mChartFile = activityStream.getEventsChart();
        this.generateHeatMapData = this.mChartFile.isSourceFilterable();
        assert (this.mChartFile.isProc() || !activityStream.isSchedulerTrace());
        this.mTimebase = settings.getNanosecondsPerDensestBin();
        this.mTicksPerScale = settings.getTicksPerScale();
        this.mTimeScale = settings.getTimeScale();
        this.mDuration = settings.getDurationInNanosecs();
        this.splitCpuByCluster = activityStream.isSchedulerTrace() ? this.cpuSplitByCluster() : false;
        String[] activityNames = this.mChartFile.getNames();
        int n = numClusters = this.splitCpuByCluster ? clusterCount : 1;
        assert (activityNames.length == 2 || !activityStream.isSchedulerTrace());
        this.counterPathsByClusterByActivity = new File[numClusters][activityNames.length];
        int cluster = 0;
        while (cluster < numClusters) {
            int activity = 0;
            while (activity < activityNames.length) {
                this.counterPathsByClusterByActivity[cluster][activity] = new File(settings.getOutputPathCounters(), this.createAlias(this.mChartFile.getTitle(), activityNames[activity], cluster));
                ++activity;
            }
            ++cluster;
        }
        if (this.generateHeatMapData) {
            if (activityStream.isSchedulerTrace()) {
                this.mHeatmapPathsByActivity = new File[1];
                this.mHeatmapPathsByActivity[0] = new File(settings.getOutputPathFocus(), this.mChartFile.getTitle());
            } else {
                this.mHeatmapPathsByActivity = new File[activityNames.length];
                int activity = 0;
                while (activity < activityNames.length) {
                    String name = activityNames.length == 1 ? this.mChartFile.getTitle() : String.format("%s - %s", this.mChartFile.getTitle(), activityNames[activity]);
                    this.mHeatmapPathsByActivity[activity] = new File(settings.getOutputPathFocus(), name);
                    ++activity;
                }
            }
        } else {
            this.mHeatmapPathsByActivity = new File[0];
        }
        this.setName(String.format("Trace[%s]", activityStream.getStreamName()), settings.getInputPath(), settings.getOutputPath());
        this.setPriorityLower();
        this.start();
    }

    @Override
    public void close() {
        for (ThreadActivityEntry entry : this.mEntries) {
            try {
                try {
                    this.addTime(this.mDuration);
                    ThreadActivity.output(entry);
                }
                catch (IOException e) {
                    this.error(e);
                    try {
                        entry.close();
                    }
                    catch (IOException e2) {
                        this.error(e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    entry.close();
                }
                catch (IOException e) {
                    this.error(e);
                }
                throw throwable;
            }
            try {
                entry.close();
            }
            catch (IOException e) {
                this.error(e);
            }
        }
        this.mEntries.clear();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void process() {
        try {
            try {
                if (this.generateHeatMapData) {
                    File[] fileArray = this.mHeatmapPathsByActivity;
                    int n = this.mHeatmapPathsByActivity.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File path = fileArray[n2];
                        CommonFileUtils.makeDirectory((File)path);
                        EventsChart.write((EventsChart)this.mChartFile, (File)path);
                        ++n2;
                    }
                }
                boolean procCounter = this.mChartFile.isProc();
                Throwable throwable = null;
                Object var3_4 = null;
                try (IAnalysisActivityReader eventsReader = this.activityStream.createReader();){
                    IAnalysisActivityReader.IValue eventValue;
                    @NonNull @NonNull List channels = eventsReader.getChannels();
                    int channelCount = channels.size();
                    @NonNull IntUnaryOperator channelToClusterMapper = channelNumber -> {
                        assert (channelNumber >= 0 && channelNumber < channelCount);
                        @NonNull ProcessingElementReference peReference = (ProcessingElementReference)channels.get(channelNumber);
                        return this.mPeReferenceToClusterNumber.applyAsInt(peReference);
                    };
                    int clusterIndex = 0;
                    while (clusterIndex < this.counterPathsByClusterByActivity.length) {
                        File[] counterPathsByActivity = this.counterPathsByClusterByActivity[clusterIndex];
                        int activityIndex = 0;
                        while (activityIndex < counterPathsByActivity.length) {
                            File counterPath = counterPathsByActivity[activityIndex];
                            CommonFileUtils.makeDirectory((File)counterPath);
                            this.createCounterRecord(counterPath, channelCount, activityIndex, this.splitCpuByCluster ? Integer.valueOf(clusterIndex) : null);
                            ++activityIndex;
                        }
                        ++clusterIndex;
                    }
                    int i = 0;
                    while (i < this.mTimeScale.length) {
                        File[] heatmapPaths = new File[]{};
                        if (this.generateHeatMapData) {
                            heatmapPaths = ThreadActivity.makeHeatmapDataPaths(this.mHeatmapPathsByActivity, this.mTimeScale[i]);
                        }
                        File[][] counterPaths = ThreadActivity.makeCounterDataPaths(this.counterPathsByClusterByActivity, this.mTimeScale[i]);
                        ThreadActivityEntry entry = new ThreadActivityEntry(this.activityStream.isSchedulerTrace(), this.splitCpuByCluster, procCounter, this.mUniqueIds, channelCount, heatmapPaths, this.mTicksPerScale[i], counterPaths, channelToClusterMapper, this.generateHeatMapData);
                        this.mEntries.add(entry);
                        ++i;
                    }
                    while (!this.isInterrupted() && (eventValue = (IAnalysisActivityReader.IValue)eventsReader.read()) != null) {
                        final long time = eventValue.getTimestamp();
                        this.progress((int)(100L * time / this.mDuration));
                        if (time > this.mDuration) {
                            break;
                        }
                        final int channelIndex = eventValue.getChannelIndex();
                        assert (channelIndex >= 0);
                        eventValue.accept((IAnalysisActivityReader.IValueVisitor)new IAnalysisActivityReader.IValueVisitor<ProcessingElementReference>(){

                            public boolean free(long timestamp, int utid) throws IOException {
                                ThreadActivity.this.threadFree(time, OptionalInt.of(utid));
                                return false;
                            }

                            public boolean stop(@NonNull ProcessingElementReference channel, long timestamp, int state) throws IOException {
                                ThreadActivity.this.threadStop(time, channelIndex, state);
                                return false;
                            }

                            public boolean swtch(@NonNull ProcessingElementReference channel, long timestamp, @Nullable Integer utid, int activity, int reason) throws IOException {
                                ThreadActivity.this.threadSwitch(time, channelIndex, activity, reason, OptionalUtils.ofInteger((Integer)utid));
                                return false;
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.addTime(this.mDuration);
                int clusterIndex = 0;
                while (clusterIndex < this.counterPathsByClusterByActivity.length) {
                    File[] counterPathsByActivity = this.counterPathsByClusterByActivity[clusterIndex];
                    int activityIndex = 0;
                    while (activityIndex < counterPathsByActivity.length) {
                        File counterPath = counterPathsByActivity[activityIndex];
                        Throwable throwable3 = null;
                        Object var7_17 = null;
                        try (LittleEndianDataOutputStream limitFile = new LittleEndianDataOutputStream(new File(counterPath, "limits.bin"));){
                            TLongHashSet limitSet = new TLongHashSet();
                            for (ThreadActivityEntry entry : this.mEntries) {
                                entry.addLimitIndices((TLongSet)limitSet, clusterIndex, activityIndex);
                            }
                            long[] limits = limitSet.toArray();
                            Arrays.sort(limits);
                            long[] lArray = limits;
                            int n = limits.length;
                            int n3 = 0;
                            while (n3 < n) {
                                long limit = lArray[n3];
                                limitFile.writeLELong(limit);
                                ++n3;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                        ++activityIndex;
                    }
                    ++clusterIndex;
                }
            }
            catch (Exception e) {
                this.error(e);
                this.progress(100);
            }
        }
        finally {
            this.progress(100);
        }
    }

    protected final void threadFree(long time, @NonNull OptionalInt utid) throws IOException {
        this.addTime(time);
        utid.ifPresent(x -> {
            for (ThreadActivityEntry entry : this.mEntries) {
                entry.threadFree(time, x);
            }
        });
    }

    protected final void threadStop(long time, int core, int reason) throws IOException {
        this.addTime(time);
        for (ThreadActivityEntry entry : this.mEntries) {
            entry.threadStop(core, reason);
        }
    }

    protected final void threadSwitch(long time, int core, int activity, int reason, @NonNull OptionalInt utid) throws IOException {
        this.addTime(time);
        for (ThreadActivityEntry entry : this.mEntries) {
            entry.threadSwitch(time, core, activity, reason, utid);
        }
    }

    private void addTime(long time) throws IOException {
        if (this.mLastTime < time) {
            int timeTick = (int)(time / this.mTimebase);
            int lastTick = (int)(this.mLastTime / this.mTimebase);
            while (lastTick < timeTick && !this.isInterrupted()) {
                long scanTime = (long)(++lastTick) * this.mTimebase;
                long deltaTime = scanTime - this.mLastTime;
                this.mLastTime = scanTime;
                for (ThreadActivityEntry entry : this.mEntries) {
                    entry.addTime(deltaTime);
                    if (!entry.process()) continue;
                    ThreadActivity.output(entry);
                }
            }
            long deltaTime = time - this.mLastTime;
            this.mLastTime = time;
            for (ThreadActivityEntry entry : this.mEntries) {
                entry.addTime(deltaTime);
            }
        }
    }

    private boolean cpuSplitByCluster() {
        return this.clusterCount > 1 && this.mCaptureDetails.supportsSelectableCPUActivityPerCluster();
    }

    private @NonNull String createAlias(@NonNull String title, @NonNull String name, int cluster) {
        return this.splitCpuByCluster ? SeriesAliasUtils.createAlias((String)title, (String)name, (int)cluster) : SeriesAliasUtils.createAlias((String)title, (String)name);
    }

    private void createCounterRecord(@NonNull File path, int cores, int index, Integer clusterIndex) {
        try {
            CounterRecordFile.writeCounterRecord((File)path, (CounterRecord)CounterRecordUtils.createEventsChartCounterRecord(this.mChartFile, index, clusterIndex, this.mCounterRecordsList, !this.activityStream.isSchedulerTrace() || !this.mCaptureDetails.supportsSelectableCPUActivityPerCluster()), (int)cores);
        }
        catch (Exception e) {
            this.error(e);
        }
    }
}

