/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.processor.timeline.ICallpathsInstructions;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.report.shared.io.IndexDataFile;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CallpathsInstructions
implements ICallpathsInstructions {
    private static final String CALLPATHS = "/callpaths";
    private static final String INSTRUCTIONS = "/instructions";
    private SampleChart[] mCallpathsArray;
    private SampleChart[] mInstructionsArray;
    private long mTick;

    public CallpathsInstructions(String path, int densestBinsPerSecond) throws IOException {
        ZoomLevel[] zoomLevels = Scales.CALLPATH_BINS_PER_SECOND;
        new File(path).mkdir();
        new File(path + CALLPATHS).mkdir();
        new File(path + INSTRUCTIONS).mkdir();
        SampleChart[] callpathsArray = new SampleChart[zoomLevels.length];
        SampleChart[] instructionsArray = new SampleChart[zoomLevels.length];
        int j = 0;
        int ndx = zoomLevels.length - 1;
        while (ndx >= 0) {
            boolean isIntegerMultipleOfDensestBPS;
            ZoomLevel zoomLevel = zoomLevels[ndx];
            int bps = zoomLevel.getBps();
            int ticks = zoomLevel.getCallPathTicks();
            boolean bl = isIntegerMultipleOfDensestBPS = bps % densestBinsPerSecond == 0;
            if (bps <= densestBinsPerSecond || isIntegerMultipleOfDensestBPS) {
                callpathsArray[j] = new SampleChart(path + CALLPATHS + String.format("/data_%d_us.bin", ticks), ticks);
                instructionsArray[j] = new SampleChart(path + INSTRUCTIONS + String.format("/data_%d_us.bin", ticks), ticks);
                ++j;
                if (bps >= densestBinsPerSecond) break;
            }
            --ndx;
        }
        if (j == 0) {
            throw new AssertionError((Object)"No zoom scales");
        }
        this.mCallpathsArray = new SampleChart[j];
        this.mInstructionsArray = new SampleChart[j];
        System.arraycopy(callpathsArray, 0, this.mCallpathsArray, 0, j);
        System.arraycopy(instructionsArray, 0, this.mInstructionsArray, 0, j);
    }

    @Override
    public void close() throws IOException {
        this.tick();
        SampleChart[] sampleChartArray = this.mCallpathsArray;
        int n = this.mCallpathsArray.length;
        int n2 = 0;
        while (n2 < n) {
            SampleChart c = sampleChartArray[n2];
            c.close();
            ++n2;
        }
        this.mCallpathsArray = null;
        sampleChartArray = this.mInstructionsArray;
        n = this.mInstructionsArray.length;
        n2 = 0;
        while (n2 < n) {
            SampleChart i = sampleChartArray[n2];
            i.close();
            ++n2;
        }
        this.mInstructionsArray = null;
    }

    @Override
    public void write(long timestamp, int callpathID, @Nullable Integer instructionID, long count) throws IOException {
        long tick = timestamp / Scales.NANOSECONDS_PER_DENSEST_CALLPATH_BIN;
        while (tick > this.mTick) {
            this.tick();
        }
        this.write(callpathID, instructionID, count);
    }

    private void tick() throws IOException {
        SampleChart[] sampleChartArray = this.mCallpathsArray;
        int n = this.mCallpathsArray.length;
        int n2 = 0;
        while (n2 < n) {
            SampleChart c = sampleChartArray[n2];
            c.tick();
            ++n2;
        }
        sampleChartArray = this.mInstructionsArray;
        n = this.mInstructionsArray.length;
        n2 = 0;
        while (n2 < n) {
            SampleChart i = sampleChartArray[n2];
            i.tick();
            ++n2;
        }
        ++this.mTick;
    }

    private void write(int callpathID, @Nullable Integer instructionID, long count) {
        SampleChart[] sampleChartArray = this.mCallpathsArray;
        int n = this.mCallpathsArray.length;
        int n2 = 0;
        while (n2 < n) {
            SampleChart c = sampleChartArray[n2];
            c.write(callpathID, count);
            ++n2;
        }
        if (instructionID != null) {
            sampleChartArray = this.mInstructionsArray;
            n = this.mInstructionsArray.length;
            n2 = 0;
            while (n2 < n) {
                SampleChart i = sampleChartArray[n2];
                i.write(instructionID, count);
                ++n2;
            }
        }
    }

    private static class SampleChart
    implements Closeable {
        private IndexDataFile mSampleList;
        private final int mTickLimit;
        private int mTickCount;
        private TIntLongHashMap mSampleCount = new TIntLongHashMap();
        private static final byte @NonNull [] EMPTY_ENTRY_MARKER = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private boolean lastWasEmptyMarker = false;

        public SampleChart(String path, int limit) throws IOException {
            this.mSampleList = new IndexDataFile(path);
            this.mTickCount = this.mTickLimit = limit;
        }

        @Override
        public void close() throws IOException {
            if (this.mTickCount != this.mTickLimit) {
                this.commit();
            }
            this.mSampleList.close();
        }

        public void tick() throws IOException {
            if (--this.mTickCount <= 0) {
                this.mTickCount = this.mTickLimit;
                this.commit();
            }
        }

        public void write(int id, long count) {
            this.mSampleCount.adjustOrPutValue(id, count, count);
        }

        private void commit() throws IOException {
            if (!this.mSampleCount.isEmpty()) {
                byte[] buffer = new byte[12 * this.mSampleCount.size()];
                ByteBuffer bb = ByteBuffer.wrap(buffer);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                this.mSampleCount.forEachEntry((key, count) -> {
                    int uid = key & 0xFFFFFF;
                    bb.putInt(uid);
                    bb.putLong(count);
                    return true;
                });
                this.mSampleCount.clear();
                this.mSampleList.writeBlobIndex(buffer, 0, buffer.length);
                this.lastWasEmptyMarker = false;
            } else if (!this.lastWasEmptyMarker) {
                this.mSampleList.writeBlobIndex(EMPTY_ENTRY_MARKER, 0, EMPTY_ENTRY_MARKER.length);
                this.lastWasEmptyMarker = true;
            } else {
                this.mSampleList.writeIndex();
            }
        }
    }
}

