/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.common.model.ProtocolType;
import org.eclipse.jdt.annotation.NonNull;

public final class ProtocolInfo {
    private final int productVersionNumber;
    private final @NonNull String productVersionTag;
    private final int protocolVersionNumber;
    private final @NonNull ProtocolType type;

    public ProtocolInfo(@NonNull ProtocolType type, int protocolVersionNumber, int productVersionNumber, @NonNull String productVersionTag) {
        this.type = type;
        this.protocolVersionNumber = protocolVersionNumber;
        this.productVersionNumber = productVersionNumber;
        this.productVersionTag = productVersionTag;
    }

    public @NonNull GatorProtocolVersion getGatorProtocolVersion() {
        return new GatorProtocolVersion(this.protocolVersionNumber);
    }

    public int getRawProtocolVersion() {
        return this.protocolVersionNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProtocolInfo) {
            ProtocolInfo that = (ProtocolInfo)obj;
            return this.type == that.type && this.protocolVersionNumber == that.protocolVersionNumber && this.productVersionNumber == that.productVersionNumber && this.productVersionTag.contentEquals(that.productVersionTag);
        }
        return false;
    }

    public @NonNull GatorProtocolVersion getGatorProductVersion() {
        return new GatorProtocolVersion(this.productVersionNumber);
    }

    public @NonNull String getHumanReadableVersion() {
        GatorProtocolVersion protocolVersion = new GatorProtocolVersion(this.protocolVersionNumber);
        GatorProtocolVersion productVersion = new GatorProtocolVersion(this.productVersionNumber);
        if (protocolVersion.isValidEncoding()) {
            if (protocolVersion.isProtocolAndProductVersionDistinct() && productVersion.isValidEncoding()) {
                String tag = this.productVersionTag.trim().toLowerCase();
                if (!tag.isBlank() && !tag.contentEquals("main")) {
                    return String.format("%s (%s)", productVersion.getProductVersionString(), this.productVersionTag);
                }
                return productVersion.getProductVersionString();
            }
            return protocolVersion.getProductVersionString();
        }
        return "";
    }

    public @NonNull String getProductTag() {
        return this.productVersionTag;
    }

    public int getRawProductVersion() {
        return this.productVersionNumber;
    }

    public @NonNull ProtocolType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.protocolVersionNumber;
        result = 31 * result + this.productVersionNumber;
        result = 31 * result + this.productVersionTag.hashCode();
        return result;
    }
}

