/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.elfdwarf;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.elfdwarf.IFunctionReaderCallback;
import com.arm.streamline.jni.elfdwarf.ImageMetadataReader;
import com.arm.streamline.jni.elfdwarf.MappingClassificationRange;
import com.arm.streamline.utility.io.StreamlineFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongUnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionReader {
    private final @NonNull IFunctionReaderCallback callback;
    private final @NonNull File metadataDir;

    private static boolean is64bitImage(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ImageMetadataReader.ImageDescriptor metadata) {
        int indexOf64 = metadata.triple.indexOf("64");
        if (indexOf64 < 0) {
            return false;
        }
        int firstDash = metadata.triple.indexOf(45);
        if (firstDash < 0) {
            return true;
        }
        return indexOf64 < firstDash;
    }

    private static @NonNull Map<@NonNull String, @Nullable String> map(@NonNull String @NonNull [] aliasNames, @NonNull String @NonNull [] unmangledAliasNames) {
        assert (aliasNames.length == unmangledAliasNames.length);
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 0;
        while (i < aliasNames.length) {
            result.put(aliasNames[i], unmangledAliasNames[i]);
            ++i;
        }
        return result;
    }

    private static long signExtend32(long l) {
        return (int)l;
    }

    private static long signExtendNop(long l) {
        return l;
    }

    public FunctionReader(@NonNull File metadataDir, @NonNull IFunctionReaderCallback callback) {
        this.metadataDir = metadataDir;
        this.callback = callback;
    }

    public void read() throws IOException, InterruptedException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ImageMetadataReader reader = (ImageMetadataReader)StreamlineFileUtils.ioOperationWithRetry(() -> new ImageMetadataReader(new File(this.metadataDir, "functions.bin"), new File(this.metadataDir, "opcodes.bin")));){
            ImageMetadataReader.ImageDescriptor metadata = reader.getImageDescriptor();
            final boolean useAddressesNotOffsets = metadata.useAddressesNotOffsets;
            final boolean is64bit = FunctionReader.is64bitImage(metadata);
            final LongUnaryOperator signExtender = is64bit ? FunctionReader::signExtendNop : FunctionReader::signExtend32;
            ImageMetadataReader.ISymbolConsumer symbolConsumer = new ImageMetadataReader.ISymbolConsumer(){

                public // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull ImageMetadataReader.IRegionConsumer onSymbol(final // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull ImageMetadataReader.SymbolRecord symbol, long opcodesFileOffset, final byte @NonNull [] opcodes) throws IOException {
                    long sa = signExtender.applyAsLong(symbol.address);
                    long so = useAddressesNotOffsets ? sa : symbol.fileOffset;
                    FunctionReader.this.callback.addFunction(sa, so, symbol.size, (int)symbol.stackFrameSize, symbol.stackFrameSize > 0L, symbol.name, symbol.unmangledName, FunctionReader.map(symbol.aliasNames, symbol.unmangledAliasNames));
                    return new ImageMetadataReader.IRegionConsumer(){
                        private long regionAddress;
                        {
                            this.regionAddress = symbolRecord.address;
                        }

                        public // Could not load outer class - annotation placement on inner may be incorrect
                        @NonNull ImageMetadataReader.IOpCodeConsumer onRegion(long size, // Could not load outer class - annotation placement on inner may be incorrect
                         @NonNull MappingClassificationRange.MappingSymbolClassification classification) throws IOException {
                            boolean isBreak;
                            boolean isArch64;
                            long regionEnd;
                            long ra = this.regionAddress;
                            this.regionAddress = regionEnd = ra + size;
                            if (!$assertionsDisabled && regionEnd > symbol.address + symbol.size) {
                                throw new AssertionError();
                            }
                            final boolean isThumb = switch (classification) {
                                case MappingClassificationRange.MappingSymbolClassification.AARCH64 -> {
                                    if (!$assertionsDisabled && !is64bit) {
                                        throw new AssertionError();
                                    }
                                    isArch64 = true;
                                    isBreak = false;
                                    yield false;
                                }
                                case MappingClassificationRange.MappingSymbolClassification.ARM -> {
                                    if (!$assertionsDisabled && is64bit) {
                                        throw new AssertionError();
                                    }
                                    isArch64 = false;
                                    isBreak = false;
                                    yield false;
                                }
                                case MappingClassificationRange.MappingSymbolClassification.NONE, MappingClassificationRange.MappingSymbolClassification.DATA -> {
                                    isArch64 = false;
                                    isBreak = true;
                                    yield false;
                                }
                                case MappingClassificationRange.MappingSymbolClassification.THUMB -> {
                                    if (!$assertionsDisabled && is64bit) {
                                        throw new AssertionError();
                                    }
                                    isArch64 = false;
                                    isBreak = false;
                                    yield true;
                                }
                                default -> throw new AssertionError(classification);
                            };
                            if (isBreak) {
                                (this).FunctionReader.this.callback.addBreak(Math.toIntExact(size));
                            }
                            return new ImageMetadataReader.IOpCodeConsumer(ra){
                                private long opcodeAddress;
                                {
                                    this.opcodeAddress = l;
                                }

                                public void onOpcode(boolean valid, long size, long source_file_uid, int line_no, long inline_source_file_uid, int inline_line_no, long inlined_function_uid) throws IOException {
                                    if (!isBreak) {
                                        long opcodeEnd;
                                        long oa = this.opcodeAddress;
                                        this.opcodeAddress = opcodeEnd = oa + size;
                                        if (!$assertionsDisabled && opcodeEnd > regionEnd) {
                                            throw new AssertionError();
                                        }
                                        if (valid) {
                                            int opcode;
                                            boolean is32Bit = size == 4L;
                                            boolean isInlined = inlined_function_uid != 0L && inline_source_file_uid != 0L && inline_line_no > 0;
                                            int opcodeOffset = Math.toIntExact(oa - symbol.address);
                                            if (size == 2L) {
                                                opcode = opcodes[opcodeOffset] & 0xFF | (opcodes[opcodeOffset + 1] & 0xFF) << 8;
                                            } else if (size == 4L) {
                                                opcode = opcodes[opcodeOffset] & 0xFF | (opcodes[opcodeOffset + 1] & 0xFF) << 8 | (opcodes[opcodeOffset + 2] & 0xFF) << 16 | (opcodes[opcodeOffset + 3] & 0xFF) << 24;
                                            } else {
                                                throw new AssertionError((Object)"Invalid opcode size");
                                            }
                                            ((this).this).FunctionReader.this.callback.addInstruction(signExtender.applyAsLong(oa), opcode, source_file_uid, line_no, inline_source_file_uid, inline_line_no, isThumb, is32Bit, isArch64, isInlined);
                                        } else {
                                            ((this).this).FunctionReader.this.callback.addBreak(Math.toIntExact(size));
                                        }
                                    }
                                }
                            };
                        }
                    };
                }
            };
            while (reader.readNext(symbolConsumer)) {
                AnalysisBase.checkInterrupted();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

