/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.elfdwarf;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.elfdwarf.ApkContentExtractor;
import com.arm.streamline.analysis.model.ImageRecordName;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.IProgressMonitor;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.jni.common.WarningType;
import com.arm.streamline.jni.elfdwarf.ElfDwarfParser;
import com.arm.streamline.jni.elfdwarf.IInterruptionChecker;
import com.arm.streamline.protocol.misc.ApkEntries;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.utility.HandlerProgressMonitor;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class ElfDwarf
extends AnalysisBase {
    public static final String IMAGES_DIR = "/db/image-metadata";
    private final @NonNull File captureDir;
    private final @NonNull List<@NonNull ImageRecordName> mActualFiles = new ArrayList<ImageRecordName>();
    private final boolean mDebugInfoEnabled;
    private final @NonNull Map<@NonNull String, @NonNull File> mSourceFiles;

    private static final @NonNull File toImageFileSafe(@NonNull File imagesDir, @NonNull String imageName) {
        File result = new File(imagesDir, imageName);
        File parent = result.getParentFile();
        if (!NullChecking.equalsNullable((Object)parent, (Object)imagesDir)) {
            throw new AssertionError((Object)("Invalid image name: " + imageName));
        }
        return result;
    }

    public ElfDwarf(@NonNull File captureDir, @NonNull Collection<@NonNull File> images, boolean debugInfoEnabled, @NonNull IAnalysisHandler handler, boolean autostart) {
        this(captureDir, images.stream().map(File::getName).collect(Collectors.toSet()), debugInfoEnabled, handler, autostart);
    }

    public ElfDwarf(@NonNull File captureDir, @NonNull Set<@NonNull String> imageNames, boolean debugInfoEnabled, @NonNull IAnalysisHandler handler, boolean autostart) {
        super(handler);
        this.captureDir = captureDir;
        File imagesDir = new File(captureDir, "images");
        this.mSourceFiles = imageNames.stream().map(n -> ElfDwarf.toImageFileSafe(imagesDir, n)).collect(Collectors.toMap(File::getName, f -> f));
        this.mDebugInfoEnabled = debugInfoEnabled;
        this.setName("ElfDwarf", captureDir.getAbsolutePath());
        this.setPriorityLower();
        if (autostart) {
            this.start();
        }
    }

    public @NonNull List<@NonNull ImageRecordName> getActualFiles(boolean usingDbV3) throws CodecException, IOException {
        if (usingDbV3) {
            this.updateActualFilesList();
        }
        return this.mActualFiles;
    }

    public boolean isProcessingNeeded() {
        block3: {
            this.mActualFiles.clear();
            if (!ElfDwarfParser.isProcessingNeeded((File)this.captureDir, (String[])this.mSourceFiles.keySet().toArray(new String[this.mSourceFiles.size()]), (boolean)this.mDebugInfoEnabled, (boolean)false)) break block3;
            return true;
        }
        try {
            this.updateActualFilesList();
            return false;
        }
        catch (CodecException | IOException e) {
            return true;
        }
    }

    private void updateActualFilesList() throws CodecException, IOException {
        Map allMetadataPaths = ElfDwarfParser.findAllImageMetadataPaths((File)this.captureDir);
        for (Map.Entry entry : allMetadataPaths.entrySet()) {
            ImageRecordName recordName;
            ElfDwarfParser.ImageNameAndEntryPath properties = (ElfDwarfParser.ImageNameAndEntryPath)entry.getValue();
            if (!this.mSourceFiles.containsKey(properties.imageName)) continue;
            File imagePath = new File(properties.imageName);
            String zipEntryName = properties.zipEntryName;
            ImageRecordName imageRecordName = recordName = zipEntryName == null || zipEntryName.isEmpty() ? ImageRecordName.fromFile(imagePath) : ImageRecordName.fromZipEntry(imagePath, zipEntryName);
            if (this.mActualFiles.contains(recordName)) continue;
            this.mActualFiles.add(recordName);
        }
    }

    @Override
    protected void process() {
        this.mActualFiles.clear();
        if (this.mSourceFiles.isEmpty()) {
            return;
        }
        try {
            HandlerProgressMonitor progress = new HandlerProgressMonitor(this.getHandler(), this.captureDir, "Extract ElfDwarf Metadata");
            IInterruptionChecker checker = new IInterruptionChecker(){

                public boolean checkInterrupted() {
                    return Thread.interrupted();
                }
            };
            List results = ElfDwarfParser.extractElfDwarfMetadata((File)this.captureDir, (String[])this.mSourceFiles.keySet().toArray(new String[this.mSourceFiles.size()]), (boolean)this.mDebugInfoEnabled, (boolean)false, (IProgressMonitor)progress, (IInterruptionChecker)checker);
            if (results == null) {
                this.cancel();
            } else {
                for (ElfDwarfParser.ExtractedImage entry : results) {
                    File imagePath = entry.imagePath;
                    String zipEntryName = entry.zipEntryName;
                    if (zipEntryName == null || zipEntryName.isEmpty()) {
                        this.mActualFiles.add(ImageRecordName.fromFile(imagePath));
                        continue;
                    }
                    this.mActualFiles.add(ImageRecordName.fromZipEntry(imagePath, zipEntryName));
                }
            }
        }
        catch (HandlerProgressMonitor.AsyncInterruptedException e) {
            this.interrupt();
        }
        catch (Exception e) {
            this.warning(new WarningItem(WarningType.ELF_DWARF, WarningSeverity.MEDIUM, AnalysisMessages.ELF_DWARF_WARNING, (String)NullChecking.neverNullOr((Object)e.getMessage(), (Object)"Failed to process ELF/DWARF data")));
        }
    }

    public final @NonNull AttachedApkEntries getAllApkEntries() {
        HashMap<String, ApkEntries> allAttachedZipFiles = new HashMap<String, ApkEntries>();
        for (File potentialZipFile : this.mSourceFiles.values()) {
            try {
                String zipFileName = potentialZipFile.getName();
                ApkEntries extractApkContent = ApkContentExtractor.extractApkContent(potentialZipFile, zipFileName);
                if (!extractApkContent.hasEntries()) continue;
                allAttachedZipFiles.put(zipFileName, extractApkContent);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new AttachedApkEntries(Collections.unmodifiableMap(allAttachedZipFiles));
    }
}

