/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.io;

import com.arm.utils.io.ByteBufferUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.eclipse.jdt.annotation.NonNull;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"})
public class ByteArrayReadableByteChannel
implements ReadableByteChannel {
    private final ByteBuffer buffer;

    public ByteArrayReadableByteChannel(byte @NonNull [] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
    }

    @Override
    public void close() throws IOException {
        this.buffer.position(this.buffer.limit());
    }

    @Override
    public boolean isOpen() {
        return !this.buffer.hasRemaining();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int nToRead = Math.min(dst.remaining(), this.buffer.remaining());
        byte @NonNull [] bytes = ByteBufferUtils.readNbytes(this.buffer, nToRead);
        dst.put(bytes);
        return nToRead;
    }
}

