/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import com.arm.utils.ListUtils;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TimeRangeFilter {
    public static <T extends IHasStartStopTime> @NonNull List<@NonNull T> filterTimeRangeWindow(long rangeStart, long rangeEnd, @Nullable List<@NonNull T> sortedItems) {
        if (rangeStart >= rangeEnd) {
            throw new IllegalArgumentException();
        }
        if (sortedItems == null) {
            return Collections.emptyList();
        }
        int baseIndex = ListUtils.binarySearch(sortedItems, j -> {
            if (j.getStartTime() >= rangeStart) {
                return -1;
            }
            if (j.getStopTime() <= rangeStart) {
                return 1;
            }
            return -1;
        });
        if (baseIndex < 0) {
            baseIndex = -(baseIndex + 1);
        }
        if (baseIndex >= sortedItems.size()) {
            return Collections.emptyList();
        }
        assert (baseIndex == 0 || ((IHasStartStopTime)sortedItems.get(baseIndex - 1)).getStopTime() <= rangeStart);
        IHasStartStopTime firstJob = (IHasStartStopTime)sortedItems.get(baseIndex);
        if (firstJob.getStartTime() >= rangeEnd) {
            return Collections.emptyList();
        }
        assert (firstJob.getStartTime() < rangeEnd && firstJob.getStopTime() > rangeStart || firstJob.getStartTime() == firstJob.getStopTime() && firstJob.getStartTime() >= rangeStart && firstJob.getStopTime() < rangeEnd);
        int endIndex = ListUtils.binarySearch(sortedItems, baseIndex, sortedItems.size() - baseIndex, j -> {
            if (j.getStartTime() >= rangeEnd) {
                return -1;
            }
            return 1;
        });
        if (endIndex < 0) {
            endIndex = -(endIndex + 1);
        }
        if (endIndex >= sortedItems.size()) {
            return Collections.unmodifiableList(sortedItems.subList(baseIndex, endIndex));
        }
        assert (endIndex >= baseIndex);
        assert (endIndex >= sortedItems.size() || ((IHasStartStopTime)sortedItems.get(endIndex)).getStartTime() >= rangeEnd && ((IHasStartStopTime)sortedItems.get(endIndex)).getStopTime() >= rangeEnd);
        return Collections.unmodifiableList(sortedItems.subList(baseIndex, endIndex));
    }

    public static interface IHasStartStopTime {
        public long getStartTime();

        public long getStopTime();
    }
}

