/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import org.eclipse.jdt.annotation.NonNull;

public enum Platform {
    LINUX("linux", "", "lib", ".so", ".sh"),
    MACINTOSH("mac", "", "lib", ".jnilib", ".sh"),
    UNKNOWN("unknown", "", "", "", ""),
    WINDOWS("windows", ".exe", "", ".dll", ".bat");

    private static final @NonNull Platform CURRENT;
    private final @NonNull String mBatchExtension;
    private final @NonNull String mDirName;
    private final @NonNull String mDynamicLibraryExtension;
    private final @NonNull String mDynamicLibraryPrefix;
    private final @NonNull String mExtension;

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        CURRENT = osName.startsWith("mac") ? MACINTOSH : (osName.startsWith("win") ? WINDOWS : (osName.startsWith("linux") ? LINUX : UNKNOWN));
    }

    public static final @NonNull Platform getPlatform() {
        return CURRENT;
    }

    public static final boolean isLinux() {
        return CURRENT == LINUX;
    }

    public static final boolean isMacintosh() {
        return CURRENT == MACINTOSH;
    }

    public static final boolean isWindows() {
        return CURRENT == WINDOWS;
    }

    public static final boolean isWindowsVistaOrNewer() {
        if (Platform.isWindows()) {
            double version;
            try {
                version = Double.parseDouble(System.getProperty("os.version").trim());
            }
            catch (Exception exception) {
                version = 0.0;
            }
            return version >= 6.0;
        }
        return false;
    }

    private Platform(@NonNull String dirName, @NonNull String extension, @NonNull String dynamicLibraryPrefix, String dynamicLibraryExtension, String batchExtension) {
        this.mDirName = dirName;
        this.mExtension = extension;
        this.mDynamicLibraryPrefix = dynamicLibraryPrefix;
        this.mDynamicLibraryExtension = dynamicLibraryExtension;
        this.mBatchExtension = batchExtension;
    }

    public final @NonNull String getBatchExtension() {
        return this.mBatchExtension;
    }

    public final @NonNull String getDirName() {
        return this.mDirName;
    }

    public final @NonNull String getDynamicLibraryExtension() {
        return this.mDynamicLibraryExtension;
    }

    public final @NonNull String getDynamicLibraryPath(String libName) {
        return this.mDirName + "/" + System.getProperty("os.arch") + "/" + this.mDynamicLibraryPrefix + libName + this.mDynamicLibraryExtension;
    }

    public final @NonNull String getDynamicLibraryPrefix() {
        return this.mDynamicLibraryPrefix;
    }

    public final @NonNull String getExecutableExtension() {
        return this.mExtension;
    }
}

