/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import com.arm.utils.IBinarySearchFor;
import gnu.trove.list.TLongList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ListUtils {
    public static <T> void addOrSetAtIndexZero(@NonNull List<T> list, T value) {
        if (list.isEmpty()) {
            list.add(value);
        } else {
            assert (list.size() == 1);
            list.set(0, value);
        }
    }

    public static <T> int binarySearch(@NonNull List<T> values, @NonNull IBinarySearchFor<T> search) {
        return ListUtils.binarySearch(values, 0, values.size(), search);
    }

    public static <T> int binarySearch(@NonNull List<T> values, int from, int count, @NonNull IBinarySearchFor<T> search) {
        if (from < 0 || count < 0 || from + count > values.size()) {
            throw new IllegalArgumentException();
        }
        int low = from;
        int high = from + count - 1;
        while (high >= low) {
            int mid = low + high >>> 1;
            T value = values.get(mid);
            int res = search.test(value);
            if (res == 0) {
                return mid;
            }
            if (res < 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -low - 1;
    }

    public static <T extends Comparable<? super T>> int appendInOrder(@NonNull List<@NonNull T> list, @NonNull T value) {
        ListIterator<@NonNull T> iter = list.listIterator(list.size());
        int steps = 0;
        while (iter.hasPrevious()) {
            if (((Comparable)iter.previous()).compareTo(value) <= 0) {
                iter.next();
                break;
            }
            ++steps;
        }
        iter.add(value);
        return steps;
    }

    public static <T> void convertAndRemoveNull(@NonNull List<T> list, @NonNull Function<? super T, ? extends @Nullable T> converter) {
        int i = 0;
        while (i < list.size()) {
            @Nullable T replacement = converter.apply(list.get(i));
            if (replacement != null) {
                list.set(i, replacement);
            } else {
                list.remove(i);
                --i;
            }
            ++i;
        }
    }

    public static <T> boolean moveBefore(@NonNull List<T> list, int indexToMove, int indexToMoveBefore) {
        if (indexToMove == indexToMoveBefore || indexToMove == indexToMoveBefore - 1) {
            return false;
        }
        T element = list.remove(indexToMove);
        list.add(indexToMove < indexToMoveBefore ? indexToMoveBefore - 1 : indexToMoveBefore, element);
        return true;
    }

    public static void set(@NonNull TLongList list, int index, long value) {
        int size = list.size();
        if (index < size) {
            list.set(index, value);
        } else if (index == size) {
            list.add(value);
        } else {
            throw new AssertionError((Object)"Invalid list index");
        }
    }

    public static <T> void set(@NonNull List<T> list, int index, T value) {
        int size = list.size();
        if (index < size) {
            list.set(index, value);
        } else if (index == size) {
            list.add(value);
        } else {
            throw new AssertionError((Object)"Invalid list index");
        }
    }

    public static <T extends Comparable<T>> int compare(@NonNull List<@NonNull T> listA, @NonNull List<@NonNull T> listB) {
        int n = Math.min(listA.size(), listB.size());
        int i = 0;
        while (i < n) {
            int result = ((Comparable)listA.get(i)).compareTo((Comparable)listB.get(i));
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return Integer.compare(listA.size(), listB.size());
    }
}

