/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.pmus;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.MIDRUtilities;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.streamline.common.xml.pmus.ProcessorPmuEventDescription;
import com.arm.utils.ArrayUtils;
import com.arm.utils.IterUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicStringUtils;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ProcessorPmu
implements Comparable<ProcessorPmu> {
    private static final String ATTRIBUTE_CORE_NAME = "core_name";
    private static final String ATTRIBUTE_COUNTER_SET = "counter_set";
    private static final String ATTRIBUTE_CPUID = "cpuid";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_PMNC_COUNTERS = "pmnc_counters";
    private static final String ATTRIBUTE_PMNC_NAME = "pmnc_name";
    private static final String ATTRIBUTE_PROFILE = "profile";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String TAG_CPUID = "cpuid";
    private static final String TAG_PMU = "pmu";
    private static final String TAG_PMUS = "pmus";
    private final @NonNull String coreName;
    private final @NonNull String counterSet;
    private final int @NonNull [] cpuIds;
    private final @NonNull Map<Integer, ProcessorPmuEventDescription> events;
    private final @NonNull String id;
    private final int numberOfEventCounters;
    private final @NonNull ArchitectureProfile profile;

    public static @NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> loadPMUXml(@NonNull InputStream inputStream, @NonNull Map<@NonNull String, @NonNull Map<@NonNull Integer, @NonNull ProcessorPmuEventDescription>> events) throws IOException {
        return ProcessorPmu.loadPMUXml(inputStream, (String counterSet) -> {
            Map pmuEvents = (Map)events.get(counterSet.toLowerCase());
            if (pmuEvents == null) {
                assert (false) : "Missing counter set: " + counterSet;
                pmuEvents = (Map)NullChecking.neverNull(Collections.emptyMap());
            }
            return pmuEvents;
        });
    }

    /*
     * Unable to fully structure code
     */
    private static @NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> loadPMUXml(@NonNull InputStream inputStream, @NonNull Function<@NonNull String, @NonNull Map<@NonNull Integer, @NonNull ProcessorPmuEventDescription>> computePmuEvents) throws IOException, IOException, AssertionError {
        result = new HashMap<Integer, ProcessorPmu>();
        var3_3 = null;
        var4_5 = null;
        try {
            xml = new XMLParser(inputStream);
            try {
                while ((tag = xml.nextTag()) != null) {
                    block22: {
                        if (!"pmus".equals(tag)) break block22;
                        marker = xml.getMarker();
                        version = xml.getIntegerAttribute("version", 1);
                        if (version >= 1 && version <= 2) ** GOTO lbl57
                        throw new IOException("Invalid pmus.xml version");
lbl-1000:
                        // 1 sources

                        {
                            if (!"pmu".equals(tag)) ** GOTO lbl56
                            subMarker = xml.getMarker();
                            if (version == 1) {
                                counterSet = id = xml.getAttribute("pmnc_name");
                            } else {
                                cs = xml.getAttribute("counter_set");
                                id = xml.getAttribute("id");
                                counterSet = cs == null ? id : cs;
                            }
                            cpuIds = new TIntHashSet(10, 0.5f, 0);
                            firstCpuId = xml.getIntegerAttribute("cpuid");
                            numCounters = xml.getIntegerAttribute("pmnc_counters");
                            coreName = xml.getAttribute("core_name");
                            profile = xml.getAttribute("profile");
                            if (firstCpuId != 0) {
                                cpuIds.add(firstCpuId);
                            }
                            while ((tag = xml.nextTag(subMarker)) != null) {
                                if ("cpuid".equals(tag)) {
                                    attrId = xml.getIntegerAttribute("id");
                                    if (attrId == 0) continue;
                                    cpuIds.add(attrId);
                                    continue;
                                }
                                xml.skip();
                            }
                            if (id != null && counterSet != null && coreName != null && !cpuIds.isEmpty()) {
                                pmu = new ProcessorPmu(id, counterSet, coreName, (int[])NullChecking.neverNull((Object)cpuIds.toArray()), numCounters, computePmuEvents.apply(counterSet), profile);
                                var21_24 = pmu.getCpuids();
                                var20_23 = var21_24.length;
                                var19_22 = 0;
                                while (var19_22 < var20_23) {
                                    cpuId = var21_24[var19_22];
                                    key = cpuId;
                                    if (result.containsKey(key)) {
                                        throw new AssertionError((Object)("Duplicate PMU with cpuid: " + cpuId));
                                    }
                                    result.put(key, pmu);
                                    ++var19_22;
                                }
                            } else {
                                if (!ProcessorPmu.$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                continue;
lbl56:
                                // 1 sources

                                xml.skip();
                            }
lbl57:
                            // 4 sources

                            ** while ((tag = xml.nextTag((String)marker)) != null)
                        }
lbl58:
                        // 1 sources

                        continue;
                    }
                    xml.skip();
                }
            }
            finally {
                if (xml != null) {
                    xml.close();
                }
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
        return result;
    }

    public static @NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> loadPMUXml(@NonNull InputStream inputStream) throws IOException {
        return ProcessorPmu.loadPMUXml(inputStream, (String counterSet) -> (Map)NullChecking.neverNull(Collections.emptyMap()));
    }

    public static @NonNull ArchitectureProfile mapCpuIDToArchitectureProfile(int cpuId) {
        @Nullable ArchitectureProfile result = ArchitectureProfile.classifyCPUID(cpuId);
        if (result != null) {
            return result;
        }
        @Nullable ProcessorPmu pmu = EventsAndPmusXml.getPmuByCPUID(cpuId);
        if (pmu != null) {
            return pmu.getProfile();
        }
        return ArchitectureProfile.UNKNOWN;
    }

    public ProcessorPmu(@NonNull String id, @NonNull String counterSet, @NonNull String coreName, int @NonNull [] cpuIds, int numberOfEventCounters, @NonNull Map<Integer, ProcessorPmuEventDescription> events, @NonNull ArchitectureProfile profile) {
        Arrays.sort(cpuIds);
        assert (cpuIds.length > 0);
        this.id = id;
        this.counterSet = counterSet;
        this.coreName = coreName;
        this.cpuIds = cpuIds;
        this.numberOfEventCounters = numberOfEventCounters;
        this.events = events;
        this.profile = profile;
    }

    protected ProcessorPmu(@NonNull String id, @NonNull String counterSet, @NonNull String coreName, int @NonNull [] cpuIds, int numberOfEventCounters, @NonNull Map<Integer, ProcessorPmuEventDescription> events, @Nullable String profile) {
        this(id, counterSet, coreName, cpuIds, numberOfEventCounters, events, ArchitectureProfile.classify(profile, id, cpuIds));
    }

    @Override
    public int compareTo(ProcessorPmu o) {
        Integer thatCortexNumber;
        String thatImplementer;
        int thatImpSortOrder;
        int thisImpSortOrder = this.implementorSortOrder();
        int result = Integer.compare(thisImpSortOrder, thatImpSortOrder = o.implementorSortOrder());
        if (result != 0) {
            return result;
        }
        String thisImplementer = this.getImplementor();
        result = thisImplementer.compareTo(thatImplementer = o.getImplementor());
        if (result != 0) {
            return result;
        }
        result = this.profile.compareTo(o.profile);
        if (result != 0) {
            return result;
        }
        Integer thisCortexNumber = this.getCortexOrNeoverseNumber();
        result = NullChecking.compareToNullable((Comparable)thisCortexNumber, (Comparable)(thatCortexNumber = o.getCortexOrNeoverseNumber()), (boolean)true);
        if (result != 0) {
            return result;
        }
        result = this.coreName.compareTo(o.coreName);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.cpuIds[0], o.cpuIds[0]);
        if (result != 0) {
            return result;
        }
        return this.id.compareTo(o.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessorPmu) {
            ProcessorPmu that = (ProcessorPmu)obj;
            return Arrays.equals(this.cpuIds, that.cpuIds) && this.coreName.equals(that.coreName) && this.id.equals(that.id) && this.counterSet.equals(that.counterSet) && this.events.equals(that.events);
        }
        return false;
    }

    public @NonNull String getConstantName(boolean isDuplicate, int cpuId) {
        assert (ArrayUtils.indexOf((int[])this.cpuIds, (int)cpuId) >= 0);
        String baseName = String.format("BARMAN_PROCESSOR_CPUID_%s", BasicStringUtils.makeIdentifier((String)this.coreName));
        if (isDuplicate) {
            return String.format("%s_%s", baseName, Integer.toHexString(cpuId)).toUpperCase();
        }
        return baseName.toUpperCase();
    }

    public @NonNull String getCoreName() {
        return this.coreName;
    }

    public @NonNull String getCounterSet() {
        return this.counterSet;
    }

    public int @NonNull [] getCpuids() {
        return this.cpuIds;
    }

    public @NonNull Map<Integer, ProcessorPmuEventDescription> getEvents() {
        return this.events;
    }

    public @NonNull String getId() {
        return this.id;
    }

    public @NonNull String getImplementor() {
        return Arrays.stream(this.cpuIds).map(MIDRUtilities::getImplementerFromCpuid).mapToObj(i -> {
            @Nullable String n = MIDRUtilities.getImplementerName(i);
            return n != null ? n : String.format("Unknown (0x%h)", i);
        }).distinct().sorted().collect(Collectors.joining(", ", "", ""));
    }

    public int getNumberOfEventCounters() {
        return this.numberOfEventCounters;
    }

    public @NonNull ArchitectureProfile getProfile() {
        return this.profile;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    private @Nullable Integer getCortexOrNeoverseNumber() {
        if (this.coreName.length() > 8 && this.coreName.startsWith("Cortex-") && this.coreName.charAt(7) >= 'A' && this.coreName.charAt(7) <= 'Z') {
            try {
                return Integer.valueOf(this.coreName.substring(8));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.coreName.length() > 10 && this.coreName.startsWith("Neoverse-") && this.coreName.charAt(9) >= 'A' && this.coreName.charAt(9) <= 'Z') {
            try {
                return Integer.valueOf(this.coreName.substring(10));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private int implementorSortOrder() {
        boolean hasArmChina = false;
        int[] nArray = this.cpuIds;
        int n = this.cpuIds.length;
        int n2 = 0;
        while (n2 < n) {
            int cpuId = nArray[n2];
            if (MIDRUtilities.getImplementerFromCpuid(cpuId) != MIDRUtilities.Implementer.ARM.id) {
                if (MIDRUtilities.getImplementerFromCpuid(cpuId) == MIDRUtilities.Implementer.ARM_CHINA.id) {
                    hasArmChina = true;
                } else {
                    return 2;
                }
            }
            ++n2;
        }
        if (hasArmChina) {
            return 1;
        }
        return 0;
    }

    public static final class ArchitectureProfile
    extends Enum<ArchitectureProfile> {
        public static final /* enum */ ArchitectureProfile A6_CLASS = new ArchitectureProfile("6a", false, false, false, false, false, true);
        public static final /* enum */ ArchitectureProfile A7_CLASS = new ArchitectureProfile("7a", true, true, false, true, true, true);
        public static final /* enum */ ArchitectureProfile A8_CLASS = new ArchitectureProfile("8a", true, true, false, true, true, true);
        public static final /* enum */ ArchitectureProfile A9_CLASS = new ArchitectureProfile("9a", true, true, false, true, true, true);
        public static final /* enum */ ArchitectureProfile M6_CLASS = new ArchitectureProfile("6m", false, false, false, false, false, false);
        public static final /* enum */ ArchitectureProfile M7_CLASS = new ArchitectureProfile("7m", true, false, false, true, false, false);
        public static final /* enum */ ArchitectureProfile M8_CLASS = new ArchitectureProfile("8m", true, false, false, true, false, false);
        public static final /* enum */ ArchitectureProfile R7_CLASS = new ArchitectureProfile("7r", true, true, true, true, true, false);
        public static final /* enum */ ArchitectureProfile R8_CLASS = new ArchitectureProfile("8r", true, true, true, true, true, false);
        public static final /* enum */ ArchitectureProfile UNKNOWN = new ArchitectureProfile("xx", true, true, true, true, true, true);
        private final @NonNull String profileString;
        private final boolean validForBareMetal;
        private final boolean validForBareMetalETM;
        private final boolean validForBareMetalInMemory;
        private final boolean validForBareMetalITM;
        private final boolean validForBareMetalSTM;
        private final boolean validForASTF;
        private static final /* synthetic */ ArchitectureProfile[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ArchitectureProfile[]{A6_CLASS, A7_CLASS, A8_CLASS, A9_CLASS, M6_CLASS, M7_CLASS, M8_CLASS, R7_CLASS, R8_CLASS, UNKNOWN};
        }

        public static @NonNull ArchitectureProfile classify(@Nullable String profile, @Nullable String id, int cpuId) {
            ArchitectureProfile profileProfile = profile != null ? ArchitectureProfile.classifyProfile(profile) : null;
            ArchitectureProfile pmncProfile = id != null ? ArchitectureProfile.classifyPmncName(id) : null;
            boolean pmncAndProfileMatch = "DWT".equals(id) && (profileProfile == M6_CLASS || profileProfile == M7_CLASS || profileProfile == M8_CLASS);
            ArchitectureProfile cpuIdProfile = ArchitectureProfile.classifyCPUID(cpuId);
            if (profileProfile == A9_CLASS && cpuIdProfile == A8_CLASS) {
                cpuIdProfile = A9_CLASS;
            }
            if (pmncProfile == A9_CLASS && cpuIdProfile == A8_CLASS) {
                cpuIdProfile = A9_CLASS;
            }
            if (!pmncAndProfileMatch && profileProfile != null && pmncProfile != null && pmncProfile != profileProfile) {
                StdLog.warn(CommonPlugin.getInstance(), String.format("profile (%s) and pmnc_name (%s) mismatched in pmus.xml: (%s vs %s)", new Object[]{profile, id, profileProfile, pmncProfile}));
            }
            if (cpuIdProfile != null) {
                if (profileProfile != null && cpuIdProfile != profileProfile) {
                    StdLog.warn(CommonPlugin.getInstance(), String.format("CPUID (0x%05x) and profile (%s) mismatched in pmus.xml: (%s vs %s)", new Object[]{cpuId, profile, cpuIdProfile, profileProfile}));
                }
                if (!pmncAndProfileMatch && pmncProfile != null && cpuIdProfile != pmncProfile) {
                    StdLog.warn(CommonPlugin.getInstance(), String.format("CPUID (0x%05x) and pmnc_name (%s) mismatched in pmus.xml: (%s vs %s)", new Object[]{cpuId, id, cpuIdProfile, pmncProfile}));
                }
                return cpuIdProfile;
            }
            if (profileProfile != null) {
                return profileProfile;
            }
            if (pmncProfile != null) {
                return pmncProfile;
            }
            return UNKNOWN;
        }

        public static @NonNull ArchitectureProfile classify(@Nullable String profile, @NonNull String id, int @NonNull [] cpuIds) {
            @NonNull Set<@NonNull T> allProfiles = Arrays.stream(cpuIds).mapToObj(cpuId -> ArchitectureProfile.classify(profile, id, cpuId)).collect(Collectors.toSet());
            if (allProfiles.size() == 1) {
                return (ArchitectureProfile)((Object)IterUtils.getNth(allProfiles, (int)0));
            }
            return UNKNOWN;
        }

        public static @Nullable ArchitectureProfile classifyCPUID(int cpuId) {
            int implementer = cpuId >>> 12;
            if (implementer != 65) {
                return null;
            }
            int primaryPartNumber = cpuId & 0xFFF;
            if ((primaryPartNumber & 0xC00) == 3072) {
                switch (primaryPartNumber) {
                    case 3104: 
                    case 3105: 
                    case 3120: 
                    case 3168: {
                        return M6_CLASS;
                    }
                    case 3107: 
                    case 3108: 
                    case 3111: 
                    case 3123: {
                        return M7_CLASS;
                    }
                }
                int system = cpuId >>> 8 & 3;
                int profile = cpuId >>> 4 & 3;
                if (system == 0) {
                    switch (profile) {
                        case 0: {
                            return A7_CLASS;
                        }
                        case 1: {
                            return R7_CLASS;
                        }
                    }
                    assert (false) : "Unexpected v6m or v7m cpuid 0x" + Integer.toHexString(cpuId);
                    return M7_CLASS;
                }
                if (system == 1) {
                    switch (profile) {
                        case 0: {
                            return A8_CLASS;
                        }
                        case 1: {
                            return R8_CLASS;
                        }
                    }
                    assert (profile == 2 || profile == 3);
                    return M8_CLASS;
                }
                assert (false) : "Unexpected system " + system + " in cpuid 0x" + Integer.toHexString(cpuId);
                return null;
            }
            if ((primaryPartNumber >>> 8 & 0xF) < 12) {
                return A6_CLASS;
            }
            return null;
        }

        private static @Nullable ArchitectureProfile classifyPmncName(@NonNull String pmncName) {
            if (pmncName.startsWith("ARMv7R_")) {
                return R7_CLASS;
            }
            if (pmncName.startsWith("ARMv8R_")) {
                return R8_CLASS;
            }
            if (pmncName.startsWith("ARM_") || pmncName.startsWith("ARMv6_")) {
                return A6_CLASS;
            }
            if (pmncName.startsWith("ARMv7_")) {
                return A7_CLASS;
            }
            if (pmncName.startsWith("ARMv8_")) {
                return A8_CLASS;
            }
            if (pmncName.startsWith("ARMv9_")) {
                return A9_CLASS;
            }
            if (pmncName.startsWith("ARMv8M_")) {
                return M8_CLASS;
            }
            if (pmncName.startsWith("ARMv7M_") || pmncName.equals("DWT")) {
                return M7_CLASS;
            }
            return null;
        }

        private static @Nullable ArchitectureProfile classifyProfile(@NonNull String profile) {
            ArchitectureProfile[] architectureProfileArray = ArchitectureProfile.values();
            int n = architectureProfileArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArchitectureProfile profileEnum = architectureProfileArray[n2];
                if (profileEnum != UNKNOWN && profileEnum.profileString.equals(profile)) {
                    return profileEnum;
                }
                ++n2;
            }
            return null;
        }

        private ArchitectureProfile(String profileString, boolean validForBareMetal, boolean validForBareMetalInMemory, boolean validForBareMetalETM, boolean validForBareMetalITM, boolean validForBareMetalSTM, boolean validForASTF) {
            assert (validForBareMetal == (validForBareMetalInMemory || validForBareMetalETM || validForBareMetalITM || validForBareMetalSTM) || validForASTF);
            this.profileString = profileString;
            this.validForBareMetal = validForBareMetal;
            this.validForBareMetalInMemory = validForBareMetalInMemory;
            this.validForBareMetalETM = validForBareMetalETM;
            this.validForBareMetalITM = validForBareMetalITM;
            this.validForBareMetalSTM = validForBareMetalSTM;
            this.validForASTF = validForASTF;
        }

        public boolean isMProfile() {
            return M6_CLASS == this || M7_CLASS == this || M8_CLASS == this;
        }

        public boolean isV8() {
            return A8_CLASS == this || R8_CLASS == this || M8_CLASS == this;
        }

        public boolean isValidForBareMetal() {
            return this.validForBareMetal;
        }

        public boolean isValidForBareMetalETMStream() {
            return this.validForBareMetalETM;
        }

        public boolean isValidForBareMetalInMemoryBuffer() {
            return this.validForBareMetalInMemory;
        }

        public boolean isValidForBareMetalITMStream() {
            return this.validForBareMetalITM;
        }

        public boolean isValidForBareMetalSTMStream() {
            return this.validForBareMetalSTM;
        }

        public boolean isValidForASTF() {
            return this.validForASTF;
        }

        public static ArchitectureProfile[] values() {
            ArchitectureProfile[] architectureProfileArray = ENUM$VALUES;
            int n = architectureProfileArray.length;
            ArchitectureProfile[] architectureProfileArray2 = new ArchitectureProfile[n];
            System.arraycopy(ENUM$VALUES, 0, architectureProfileArray2, 0, n);
            return architectureProfileArray2;
        }

        public static ArchitectureProfile valueOf(String string) {
            return Enum.valueOf(ArchitectureProfile.class, string);
        }
    }
}

