/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import java.io.DataInput;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public class DataInputAdapter {
    public static @NonNull DataInput adapt(final @NonNull ByteBuffer input) {
        return new DataInput(){

            @Override
            public boolean readBoolean() throws IOException {
                try {
                    return input.get() != 0;
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public byte readByte() throws IOException {
                try {
                    return input.get();
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public char readChar() throws IOException {
                try {
                    return input.getChar();
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public double readDouble() throws IOException {
                try {
                    return input.getDouble();
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public float readFloat() throws IOException {
                try {
                    return input.getFloat();
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public void readFully(byte[] b) throws IOException {
                try {
                    input.get(b);
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public void readFully(byte[] b, int off, int len) throws IOException {
                try {
                    input.get(b, off, len);
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public int readInt() throws IOException {
                try {
                    return input.getInt();
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public String readLine() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long readLong() throws IOException {
                try {
                    return input.getLong();
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public short readShort() throws IOException {
                try {
                    return input.getShort();
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public int readUnsignedByte() throws IOException {
                try {
                    return input.get() & 0xFF;
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public int readUnsignedShort() throws IOException {
                try {
                    return input.getShort() & 0xFFFF;
                }
                catch (BufferUnderflowException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public String readUTF() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int skipBytes(int n) throws IOException {
                int bytesToSkip = Math.min(Math.max(n, 0), input.remaining());
                input.position(input.position() + bytesToSkip);
                return bytesToSkip;
            }
        };
    }
}

