/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility;

import com.arm.streamline.common.utility.UtilityMessages;
import com.arm.utils.Platform;
import java.io.File;
import java.time.LocalDate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class WorkspaceUtils {
    private static final @NonNull Pattern PRODUCT_BUILD_DATE_QUALIFIER_PATTERN = Pattern.compile("v(\\d\\d\\d\\d)(\\d\\d)(\\d\\d)_(\\d\\d)(\\d\\d)(-.*)?");

    public static final int getCommandKey() {
        return Platform.isMacintosh() ? 0x400000 : 262144;
    }

    public static final String getCommandKeyText() {
        return Platform.isMacintosh() ? UtilityMessages.COMMAND : UtilityMessages.CONTROL;
    }

    public static final Shell getShell() {
        Shell shell;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if ((shell = display.getActiveShell()) == null) {
            Control focus = display.getFocusControl();
            if (focus != null && !focus.isDisposed() && (shell = focus.getShell()) != null) {
                return shell;
            }
            Shell[] shellArray = display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell one = shellArray[n2];
                if (!one.isDisposed()) {
                    if (!one.isVisible()) {
                        shell = one;
                    } else {
                        return one;
                    }
                }
                ++n2;
            }
        }
        return shell;
    }

    public static final boolean isHeadless() {
        Bundle bundle = org.eclipse.core.runtime.Platform.getBundle((String)"org.eclipse.ui");
        return bundle == null || bundle.getState() != 32 || !PlatformUI.isWorkbenchRunning();
    }

    public static final void refreshProject(File projectFile) throws CoreException {
        IPath filePath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootPath = root.getLocation();
        if (rootPath.isPrefixOf(filePath = new Path(projectFile.getAbsolutePath()).makeAbsolute())) {
            IPath relativePath = filePath.makeRelativeTo(rootPath);
            String projectSegment = relativePath.segment(0);
            IProject proj = root.getProject(projectSegment);
            proj.refreshLocal(2, null);
        }
    }

    public static @NonNull LocalDate buildDateFromBundle(@NonNull Version version) {
        String qualifier = version.getQualifier();
        Matcher matcher = PRODUCT_BUILD_DATE_QUALIFIER_PATTERN.matcher(qualifier);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2));
            int day = Integer.parseInt(matcher.group(3));
            return LocalDate.of(year, month, day);
        }
        assert (version.getMajor() == 0 && version.getMinor() == 0 && version.getMicro() == 0 && ("qualifier".contentEquals(qualifier) || qualifier.matches("\\d+"))) : String.format("Unexpected qualifier or version '%s'", version);
        return LocalDate.now();
    }
}

