/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.utils.NullChecking;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class Task
implements Runnable {
    private static final AtomicLong NEXT_KEY = new AtomicLong();
    private static final Set<String> PENDING = new HashSet<String>();
    private static final @NonNull ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private Future<?> mFuture;
    private String mKey;
    private final @NonNull Runnable mTask;
    private boolean mWasCancelled;
    private boolean mWasExecuted;
    private Plugin plugin;
    private @Nullable Thread mExecutedOnThread = null;

    public static void blockingCallOnUIThread(Runnable runnable) {
        try {
            if (Display.getCurrent() == null) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display != null && !display.isDisposed()) {
                    display.syncExec(runnable);
                }
            } else {
                runnable.run();
            }
        }
        catch (Throwable throwable) {
            StdLog.error(CommonPlugin.getInstance(), null, throwable);
        }
    }

    public static final @NonNull Task callOnAnotherThread(@NonNull Runnable runnable) {
        Task task = new Task(runnable, null, CommonPlugin.getInstance());
        Task.schedule(task, 0L, TimeUnit.MILLISECONDS);
        return task;
    }

    public static final @NonNull Task callOnCurrentThread(@NonNull Runnable runnable) {
        Task task = new Task(runnable, null, CommonPlugin.getInstance());
        task.run();
        return task;
    }

    public static boolean callOnUIThread(Runnable runnable) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(runnable);
            return true;
        }
        return false;
    }

    public static final @NonNull Thread executeAsynchronously(@NonNull Runnable runnable) {
        return Task.executeAsynchronously(null, runnable);
    }

    public static final @NonNull Thread executeAsynchronously(@Nullable String name, @NonNull Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName((String)NullChecking.neverNullOr((Object)name, (Object)"Task.execute thread"));
        thread.start();
        return thread;
    }

    public static String getNextUniqueKey() {
        return String.valueOf(NEXT_KEY.getAndIncrement());
    }

    public static final Task scheduleOnAnotherThread(@NonNull Runnable runnable, String key, long delay, TimeUnit delayUnits) {
        Task task = new Task(runnable, key, CommonPlugin.getInstance());
        Task.schedule(task, delay, delayUnits);
        return task;
    }

    public static final Task scheduleOnUIThread(@NonNull Runnable runnable) {
        Task task = new Task(runnable, null, CommonPlugin.getInstance());
        Task.scheduleForUI(task, 0L, TimeUnit.MILLISECONDS);
        return task;
    }

    public static final Task scheduleOnUIThread(@NonNull Runnable runnable, String key) {
        Task task = new Task(runnable, key, CommonPlugin.getInstance());
        Task.scheduleForUI(task, 0L, TimeUnit.MILLISECONDS);
        return task;
    }

    public static final Task scheduleOnUIThread(@NonNull Runnable runnable, String key, long delay, TimeUnit delayUnits) {
        Task task = new Task(runnable, key, CommonPlugin.getInstance());
        Task.scheduleForUI(task, delay, delayUnits);
        return task;
    }

    private static final void schedule(Task task, long delay, TimeUnit delayUnits) {
        if (task.shouldExecute()) {
            task.mFuture = SCHEDULED_EXECUTOR.schedule(task, delay, delayUnits);
        }
    }

    private static final void scheduleForUI(Task task, long delay, TimeUnit delayUnits) {
        if (task.shouldExecute()) {
            if (delay < 1L) {
                Task.callOnUIThread(task);
            } else {
                SCHEDULED_EXECUTOR.schedule(new Task(() -> {
                    boolean bl = Task.callOnUIThread(task);
                }, null, CommonPlugin.getInstance()), delay, delayUnits);
            }
        }
    }

    public static <T> @NonNull Future<T> submit(@NonNull Callable<T> task) {
        return SCHEDULED_EXECUTOR.submit(task);
    }

    private Task(@NonNull Runnable runnable, String key, Plugin plugin) {
        this.mTask = runnable;
        this.mKey = key;
        this.plugin = plugin;
    }

    public final synchronized void cancel() {
        if (this.mWasExecuted && this.mExecutedOnThread == null) {
            return;
        }
        this.mWasCancelled = true;
        if (this.mExecutedOnThread != null) {
            this.mExecutedOnThread.interrupt();
        }
    }

    public final void join() {
        if (!this.wasCancelled() && this.mFuture != null) {
            try {
                this.mFuture.get();
            }
            catch (InterruptedException e) {
                if (!this.mWasCancelled) {
                    StdLog.error(this.plugin, null, e);
                }
            }
            catch (Exception e) {
                StdLog.error(this.plugin, null, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block22: {
            Object object;
            if (this.mKey != null) {
                object = PENDING;
                synchronized (object) {
                    PENDING.remove(this.mKey);
                }
            }
            object = this;
            synchronized (object) {
                if (this.mWasCancelled) {
                    return;
                }
                this.mWasExecuted = true;
                this.mExecutedOnThread = Thread.currentThread();
            }
            try {
                try {
                    this.mTask.run();
                }
                catch (Throwable throwable) {
                    StdLog.error(this.plugin, null, throwable);
                    Task task = this;
                    synchronized (task) {
                        this.mExecutedOnThread = null;
                        break block22;
                    }
                }
            }
            catch (Throwable throwable) {
                Task task = this;
                synchronized (task) {
                    this.mExecutedOnThread = null;
                }
                throw throwable;
            }
            Task task = this;
            synchronized (task) {
                this.mExecutedOnThread = null;
            }
        }
    }

    public final synchronized boolean wasCancelled() {
        return this.mWasCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean shouldExecute() {
        if (this.mKey != null) {
            Set<String> set = PENDING;
            synchronized (set) {
                return PENDING.add(this.mKey);
            }
        }
        return true;
    }

    public static @NonNull ExecutorService getExecutorService() {
        return SCHEDULED_EXECUTOR;
    }
}

