/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MIDRUtilities {
    private static final TIntObjectMap<String> ARCHITECTURE_NAMES = new TIntObjectHashMap<String>(){
        {
            this.put(1, "ARMv4");
            this.put(2, "ARMv4T");
            this.put(3, "ARMv5");
            this.put(4, "ARMv5T");
            this.put(5, "ARMv5TE");
            this.put(6, "ARMv5TEJ");
            this.put(7, "ARMv6");
        }
    };
    private static final TIntObjectMap<String> IMPLEMENTER_NAMES = new TIntObjectHashMap<String>(){
        {
            this.put(Implementer.ARM.id, "Arm");
            this.put(Implementer.ARM_CHINA.id, "Arm China");
            this.put(Implementer.BROADCOM.id, "Broadcom");
            this.put(Implementer.CAVIUM.id, "Cavium");
            this.put(Implementer.DEC.id, "DEC");
            this.put(Implementer.HISILICON.id, "HiSilicon");
            this.put(Implementer.INFINEON.id, "Infineon");
            this.put(Implementer.FREESCALE.id, "Freescale");
            this.put(Implementer.NVIDIA.id, "NVIDIA");
            this.put(Implementer.AMPERE_COMPUTING_APPLIED_MICRO.id, "Ampere Computing");
            this.put(Implementer.QUALCOMM.id, "Qualcomm");
            this.put(Implementer.SAMSUNG.id, "Samsung");
            this.put(Implementer.MARVELL.id, "Marvell");
            this.put(Implementer.INTEL.id, "Intel");
            this.put(Implementer.AMPERE_COMPUTING.id, "Ampere Computing");
            if (!$assertionsDisabled && Implementer.values().length != this.size()) {
                throw new AssertionError();
            }
        }
    };

    public static int getArchitecture(int midr) {
        return midr >> 16 & 0xF;
    }

    public static @NonNull String getArchitectureName(int architecture) {
        String result = (String)ARCHITECTURE_NAMES.get(architecture);
        if (result != null) {
            return result;
        }
        return "ARM";
    }

    public static int getImplementer(int midr) {
        return midr >> 24 & 0xFF;
    }

    public static int getImplementerFromCpuid(int cpuid) {
        return cpuid >> 12 & 0xFF;
    }

    public static @Nullable String getImplementerName(int implementer) {
        return (String)IMPLEMENTER_NAMES.get(implementer);
    }

    public static int getPartNum(int midr) {
        return midr >> 4 & 0xFFF;
    }

    public static int getRevision(int midr) {
        return midr & 0xF;
    }

    public static int getVariant(int midr) {
        return midr >> 20 & 0xF;
    }

    public static int makeGatorCpuid(int midr) {
        return (midr & 0xFF000000) >> 12 | (midr & 0xFFF0) >> 4;
    }

    public static int makeMidrFromGatorCpuid(int cpuid) {
        return (cpuid & 0xFF000) << 12 | (cpuid & 0xFFF) << 4;
    }

    public static enum Implementer {
        AMPERE_COMPUTING(192),
        AMPERE_COMPUTING_APPLIED_MICRO(80),
        ARM(65),
        ARM_CHINA(99),
        BROADCOM(66),
        CAVIUM(67),
        DEC(68),
        FREESCALE(77),
        HISILICON(72),
        INFINEON(73),
        INTEL(105),
        MARVELL(86),
        NVIDIA(78),
        QUALCOMM(81),
        SAMSUNG(83);

        public final int id;

        private Implementer(int id) {
            this.id = id;
        }
    }
}

