/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.warnings;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.warnings.IRawWarnings;
import com.arm.streamline.common.model.warnings.IWarningListener;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.jni.common.WarningType;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class RawWarnings
implements IRawWarnings {
    private static final String ATTR_CATEGORY_ID = "category_id";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_SEVERITY = "severity";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_VARIABLE = "variable";
    private static final String FILENAME = "warnings.xml";
    private static final String TAG_WARNING = "warning";
    private static final String TAG_WARNINGS = "warnings";
    private final @NonNull List<@NonNull WarningItem> mItems = new ArrayList<WarningItem>();
    private final @NonNull List<@NonNull IWarningListener> mListeners = new ArrayList<IWarningListener>();

    private static @NonNull WarningItem parseWarning(XMLParser xml) throws IOException {
        WarningType mType = WarningType.get((String)xml.getAttribute(ATTR_CATEGORY_ID), (WarningType)WarningType.MISC);
        WarningSeverity mSeverity = WarningSeverity.get((String)xml.getAttribute(ATTR_SEVERITY), (WarningSeverity)WarningSeverity.MEDIUM);
        String mTitle = xml.getAttribute(ATTR_TITLE, "");
        if (xml.hasAttribute(ATTR_DESCRIPTION)) {
            String mDescription = xml.getAttribute(ATTR_DESCRIPTION, "");
            xml.skip();
            return new WarningItem(mType, mSeverity, mTitle, mDescription);
        }
        if (xml.hasAttribute(ATTR_VARIABLE)) {
            String mVariableWithinList = (String)NullChecking.neverNullOr((Object)xml.getAttribute(ATTR_VARIABLE), (Object)"");
            String mVariableSubstitutionString = (String)NullChecking.neverNullOr((Object)xml.getText(), (Object)"");
            return new WarningItem(mType, mSeverity, mTitle, mVariableSubstitutionString, mVariableWithinList);
        }
        String mDescription = (String)NullChecking.neverNullOr((Object)xml.getText(), (Object)"");
        return new WarningItem(mType, mSeverity, mTitle, mDescription);
    }

    private static final void save(XMLGenerator xml, String tag, WarningItem item) throws IOException {
        if (item.isPersistant()) {
            xml.startTag(tag);
            xml.addAttribute(ATTR_CATEGORY_ID, item.getType().getXmlKey());
            xml.addAttribute(ATTR_SEVERITY, item.getSeverity().getXmlKey());
            xml.addAttribute(ATTR_TITLE, item.getTitle());
            if (item.getVariableSubstitutionString() == null) {
                xml.addText(item.getDescription());
            } else {
                xml.addAttribute(ATTR_VARIABLE, item.getVariable());
                xml.addText(item.getVariableSubstitutionString());
            }
            xml.endTag();
        }
    }

    public RawWarnings() {
    }

    public RawWarnings(@NonNull IRawWarnings that) {
        this.mItems.addAll(that.getItems());
    }

    @Override
    public void add(@NonNull WarningItem item) {
        if (!this.mItems.contains(item)) {
            this.mItems.add(item);
            this.notifyListeners();
        }
    }

    @Override
    public final synchronized void addListener(@NonNull IWarningListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    @Override
    public void clear() {
        if (!this.mItems.isEmpty()) {
            this.mItems.clear();
            this.notifyListeners();
        }
    }

    @Override
    public @NonNull List<@NonNull WarningItem> getItems() {
        return this.mItems;
    }

    @Override
    public final boolean isEmpty() {
        return this.mItems.isEmpty();
    }

    @Override
    public @NonNull Iterator<@NonNull WarningItem> iterator() {
        return this.mItems.iterator();
    }

    @Override
    public void load(@NonNull File dir) {
        boolean notify = false;
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (XMLParser xml = XMLParser.create(new File(dir, FILENAME));){
                String tag;
                while ((tag = xml.nextTag()) != null) {
                    if (!TAG_WARNINGS.equals(tag)) continue;
                    String marker = xml.getMarker();
                    while ((tag = xml.nextTag(marker)) != null) {
                        if (TAG_WARNING.equals(tag)) {
                            this.mItems.add(RawWarnings.parseWarning(xml));
                            notify = true;
                            continue;
                        }
                        xml.skip();
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception ex) {
            CommonPlugin.error(ex);
        }
        if (notify) {
            this.notifyListeners();
        }
    }

    @Override
    public void remove(WarningItem item) {
        if (this.mItems.contains(item)) {
            this.mItems.remove(item);
            this.notifyListeners();
        }
    }

    @Override
    public final synchronized void removeListener(@NonNull IWarningListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public final void save(@NonNull File dir) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (XMLGenerator xml = XMLGenerator.create(new File(dir, FILENAME));){
                xml.startDocument();
                xml.startTag(TAG_WARNINGS);
                for (WarningItem item : this.mItems) {
                    RawWarnings.save(xml, TAG_WARNING, item);
                }
                xml.endTag();
                xml.endDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            CommonPlugin.error(exception);
        }
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyListeners() {
        IWarningListener[] listeners;
        RawWarnings rawWarnings = this;
        synchronized (rawWarnings) {
            listeners = this.mListeners.toArray(new IWarningListener[this.mListeners.size()]);
        }
        IWarningListener[] iWarningListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IWarningListener listener = iWarningListenerArray[n2];
            listener.warningsUpdated();
            ++n2;
        }
    }
}

