/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.counters;

import com.arm.streamline.common.model.CommonModelMessages;
import org.eclipse.jdt.annotation.NonNull;

public enum GraphRenderingType {
    FILLED(CommonModelMessages.GraphRenderingType_FILL_RENDERING_TYPE_TOOLTIP, true),
    LINE(CommonModelMessages.GraphRenderingType_LINE_RENDERING_TYPE_TOOLTIP, false),
    BAR(CommonModelMessages.GraphRenderingType_BAR_RENDERING_TYPE_TOOLTIP, true),
    HEATMAP(CommonModelMessages.GraphRenderingType_HEATMAP_RENDERING_TYPE_TOOLTIP, true);

    public static final @NonNull GraphRenderingType DEFAULT;
    private final @NonNull String mTooltip;
    private final boolean mDrawSelectionShadow;

    static {
        DEFAULT = FILLED;
    }

    public static final @NonNull GraphRenderingType get(String type) {
        if (type != null) {
            GraphRenderingType[] graphRenderingTypeArray = GraphRenderingType.values();
            int n = graphRenderingTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GraphRenderingType renderingType = graphRenderingTypeArray[n2];
                if (renderingType.name().equalsIgnoreCase(type)) {
                    return renderingType;
                }
                ++n2;
            }
        }
        return DEFAULT;
    }

    private GraphRenderingType(String tooltip, boolean drawSelectionShadow) {
        this.mTooltip = tooltip;
        this.mDrawSelectionShadow = drawSelectionShadow;
    }

    public final @NonNull String getTooltip() {
        return this.mTooltip;
    }

    public final boolean shouldDrawSelectionShadow() {
        return this.mDrawSelectionShadow;
    }

    public final @NonNull String toString() {
        return this.name().toLowerCase();
    }
}

