/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.counters;

import com.arm.streamline.common.xml.counters.BadXmlException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum CounterMode {
    PER_CORE("per-core"),
    SYSTEM_WIDE("system-wide");

    public final @NonNull String xmlValue;

    private CounterMode(String xmlValue) {
        this.xmlValue = xmlValue;
    }

    public static @Nullable CounterMode read(String modeString, boolean isPerCPU) throws BadXmlException {
        if (isPerCPU) {
            if (modeString != null && !CounterMode.PER_CORE.xmlValue.equalsIgnoreCase(modeString)) {
                throw new BadXmlException("PerCPU was given but mode is not " + String.valueOf((Object)PER_CORE));
            }
            return PER_CORE;
        }
        if (modeString == null) {
            return null;
        }
        CounterMode[] counterModeArray = CounterMode.values();
        int n = counterModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CounterMode value = counterModeArray[n2];
            if (value.xmlValue.equalsIgnoreCase(modeString)) {
                return value;
            }
            ++n2;
        }
        throw new BadXmlException("Invalid value for counter mode");
    }

    public final @NonNull String toString() {
        return this.xmlValue;
    }
}

