/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.chart;

import com.arm.streamline.common.model.chart.ActivityChartUtils;
import com.arm.utils.text.NumericStringComparator;
import org.eclipse.jdt.annotation.NonNull;

public final class SeriesComparator {
    private static final @NonNull String GPU_PREFIX = "GPU ";

    public static int compareSeries(int order1, String title1, String name1, boolean isActivity1, int order2, String title2, String name2, boolean isActivity2) {
        if (title1.startsWith("Clock") && title2.startsWith("Clock")) {
            if (name1.startsWith("Frequency") && name2.startsWith("Cycles")) {
                return -1;
            }
            if (name2.startsWith("Frequency") && name1.startsWith("Cycles")) {
                return 1;
            }
        }
        if (ActivityChartUtils.isCPUActivityUser(title1, name1) && ActivityChartUtils.isCPUActivitySystem(title2, name2)) {
            return -1;
        }
        if (ActivityChartUtils.isCPUActivityUser(title2, name2) && ActivityChartUtils.isCPUActivitySystem(title1, name1)) {
            return 1;
        }
        int titleCompare = NumericStringComparator.caselessCompareStrings((String)title1, (String)title2);
        if (titleCompare == 0) {
            int orderCompare = -Integer.compare(order1, order2);
            if (orderCompare != 0) {
                return orderCompare;
            }
            return NumericStringComparator.caselessCompareStrings((String)name1, (String)name2);
        }
        if (isActivity1 && isActivity2) {
            if (title1.startsWith(GPU_PREFIX) && title2.startsWith(GPU_PREFIX)) {
                return titleCompare * -1;
            }
            return titleCompare;
        }
        if (isActivity1) {
            return -1;
        }
        if (isActivity2) {
            return 1;
        }
        return titleCompare;
    }
}

