/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.text.NumberUtils;
import java.text.ParseException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimeUnit {
    public static final @NonNull TimeUnit MILLI_CYCLES = new TimeUnit(1000, "c", "cycle");
    public static final @NonNull TimeUnit NANO_SECONDS = new TimeUnit(1000000000, "s", "second");
    private final @NonNull String baseSymbol;
    private final @NonNull String baseText;
    private final @NonNull String baseTextMany;
    private final boolean isSeconds;
    private final int numberPerBase;

    public TimeUnit(int numberPerBase, @NonNull String baseSymbol, @NonNull String baseText, @NonNull String baseTextMany) {
        this.numberPerBase = numberPerBase;
        this.baseSymbol = baseSymbol;
        this.baseText = baseText;
        this.baseTextMany = baseTextMany;
        this.isSeconds = baseText.equals("second");
    }

    public TimeUnit(int numberPerBase, @NonNull String baseSymbol, @NonNull String baseText) {
        this(numberPerBase, baseSymbol, baseText, baseText + "s");
    }

    public @NonNull String formatBin(long bins, @NonNull ZoomLevel zoomLevel, @NonNull Style style, boolean pad) {
        double value = zoomLevel.convertBinToNanoseconds(bins);
        double precision = zoomLevel.convertBinToNanoseconds(1L);
        return this.formatInBase(value, precision, style, pad);
    }

    public @NonNull String formatTimeNonLocalised(long bins, @NonNull ZoomLevel zoomLevel) {
        double value = zoomLevel.convertBinToNanoseconds(bins);
        double precision = zoomLevel.convertBinToNanoseconds(1L);
        return NumberUtils.formatWithPrecision(value / (double)this.numberPerBase, precision / (double)this.numberPerBase, true);
    }

    public int formatBinMaxWidth(long bins, @NonNull ZoomLevel zoomLevel, @NonNull Style style) {
        double value = zoomLevel.convertBinToNanoseconds(bins);
        double precision = zoomLevel.convertBinToNanoseconds(1L);
        return this.maxWidth(value, precision, style);
    }

    public @NonNull String formatInBase(double value, double precision, @NonNull Style style, boolean pad) {
        boolean longFormat;
        double valueInBase = value / (double)this.numberPerBase;
        double precisionInBase = precision / (double)this.numberPerBase;
        boolean addBase = style != Style.NO_UNIT;
        boolean bl = longFormat = style == Style.TEXT_UNIT;
        if (this.isSeconds) {
            return NumberUtils.formatTime(valueInBase, precisionInBase, addBase, longFormat, pad);
        }
        @NonNull String result = NumberUtils.formatWithPrecision(valueInBase, precisionInBase, pad);
        if (addBase) {
            if (longFormat) {
                if (result.equals("1")) {
                    return result + " " + this.baseText;
                }
                return result + " " + this.baseTextMany;
            }
            return result + this.baseSymbol;
        }
        return result;
    }

    public String formatInBaseSymbolUnits(long timestamp) {
        return this.formatInBase(timestamp, 1.0, Style.SYMBOL_UNIT, false);
    }

    public @NonNull String formatInSi(double value, double precision, @NonNull Style style) {
        double valueInBase = value / (double)this.numberPerBase;
        double precisionInBase = precision / (double)this.numberPerBase;
        @NonNull String result = NumberUtils.formatInSiUnits(valueInBase, precisionInBase, style == Style.TEXT_UNIT);
        if (style == Style.NO_UNIT) {
            return result;
        }
        if (style == Style.TEXT_UNIT) {
            if (result.startsWith("1 ")) {
                return result + this.baseText;
            }
            return result + this.baseTextMany;
        }
        return result + this.baseSymbol;
    }

    public @NonNull String formatZoomLevel(@NonNull ZoomLevel zoomLevel) {
        double value = zoomLevel.convertBinToNanoseconds(1L);
        return this.formatInSi(value, value, Style.SYMBOL_UNIT);
    }

    public @NonNull String getBaseSymbol() {
        return this.baseSymbol;
    }

    public @NonNull String getBaseText() {
        return this.baseText;
    }

    public @NonNull String getBaseTextMany() {
        return this.baseTextMany;
    }

    public int getNumberPerBase() {
        return this.numberPerBase;
    }

    public int maxWidth(double maxValue, double precision, @NonNull Style style) {
        boolean longFormat;
        double valueInBase = maxValue / (double)this.numberPerBase;
        double precisionInBase = precision / (double)this.numberPerBase;
        boolean addBase = style != Style.NO_UNIT;
        boolean bl = longFormat = style == Style.TEXT_UNIT;
        if (this.isSeconds) {
            return NumberUtils.formatTimeMaxLength(valueInBase, precisionInBase, addBase, longFormat);
        }
        int result = NumberUtils.formatWithPrecisionMaxLength(valueInBase, precisionInBase);
        if (addBase) {
            if (longFormat) {
                return result + Math.max(this.baseText.length(), this.baseTextMany.length());
            }
            return result + this.baseSymbol.length();
        }
        return result;
    }

    public double parseInBase(@NonNull String value) throws ParseException {
        if (this.isSeconds) {
            return NumberUtils.parseTime(value);
        }
        return NumberUtils.parse(value);
    }

    public long parseInBaseToBin(@Nullable String value, @NonNull ZoomLevel zoomLevel) {
        if (value == null) {
            return 0L;
        }
        try {
            double valueInUnits = this.parseInBase(value) * (double)this.numberPerBase;
            return zoomLevel.convertNanosecondsToBin((long)valueInUnits);
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public String toString() {
        return "TimeUnit [numberPerBase=" + this.numberPerBase + ", baseSymbol=" + this.baseSymbol + ", baseText=" + this.baseText + ", baseTextMany=" + this.baseTextMany + "]";
    }

    public static enum Style {
        NO_UNIT,
        SYMBOL_UNIT,
        TEXT_UNIT;

    }
}

