/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.analysis.session;

import com.arm.streamline.common.analysis.session.AddressMap;
import com.arm.streamline.common.utility.UnsignedUtil;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class AddressMap64<V>
extends AddressMap<V> {
    @Override
    public void clear(long minAddress, long maxAddress) {
        int index = this.getIndex(minAddress);
        if (index < 0) {
            index = -index - 1;
        }
        int fromIndex = index;
        while (index < this.mSortedKeys.length && UnsignedUtil.greaterOrEqualTo(this.mSortedKeys[index], minAddress) && UnsignedUtil.lessOrEqualTo(this.mSortedKeys[index], maxAddress)) {
            this.mElements.remove(this.mSortedKeys[index++]);
        }
        int toIndex = index;
        int distance = toIndex - fromIndex;
        if (distance > 0) {
            if (distance >= this.mSortedKeys.length) {
                this.clear();
            } else {
                long[] newSortedKeys = new long[this.mSortedKeys.length - distance];
                System.arraycopy(this.mSortedKeys, 0, newSortedKeys, 0, fromIndex);
                System.arraycopy(this.mSortedKeys, toIndex, newSortedKeys, fromIndex, newSortedKeys.length - fromIndex);
            }
        }
    }

    @Override
    protected int binarySearch(long address) {
        this.checkSortedKeys();
        return ArrayUtils.binarySearchUnsigned((long[])((long[])NullChecking.neverNull((Object)this.mSortedKeys)), (long)address);
    }

    @Override
    protected void checkSortedKeys() {
        if (this.mSortedKeys != null) {
            return;
        }
        this.mSortedKeys = this.mElements.keys();
        ArrayList<Long> copy = new ArrayList<Long>(this.mSortedKeys.length);
        long[] lArray = this.mSortedKeys;
        int n = this.mSortedKeys.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            copy.add(l);
            ++n2;
        }
        Collections.sort(copy, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                long v1;
                long v0 = o1;
                if (v0 == (v1 = o2.longValue())) {
                    return 0;
                }
                if (UnsignedUtil.lessThan(v0, v1)) {
                    return -1;
                }
                return 1;
            }
        });
        int i = 0;
        while (i < this.mSortedKeys.length) {
            this.mSortedKeys[i] = (Long)copy.get(i);
            ++i;
        }
    }
}

