/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.analysis.session;

import com.arm.utils.NullChecking;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AddressMap<V>
implements Iterable<Entry<V>> {
    protected final TLongObjectHashMap<V> mElements = new TLongObjectHashMap();
    protected long[] mSortedKeys;

    public void add(long address, V e) {
        if (!this.mElements.contains(address)) {
            this.clearSortedKeys();
        }
        this.mElements.put(address, e);
    }

    public void clear() {
        this.clearSortedKeys();
        this.mElements.clear();
    }

    public abstract void clear(long var1, long var3);

    public V computeIfAbsent(long address, @NonNull LongFunction<V> factory) {
        @Nullable Object result = this.mElements.get(address);
        if (result != null) {
            return (V)result;
        }
        V newItem = factory.apply(address);
        if (newItem != null) {
            this.mElements.put(address, newItem);
        }
        return newItem;
    }

    public @Nullable V findAt(long address) {
        return (V)this.mElements.get(address);
    }

    public @Nullable V findUpto(long address) {
        this.checkSortedKeys();
        int i = this.binarySearch(address);
        if (i >= 0) {
            return (V)this.mElements.get(this.mSortedKeys[i]);
        }
        return (V)((i = -i - 2) < 0 ? null : this.mElements.get(this.mSortedKeys[i]));
    }

    public long getAddress(int index) {
        this.checkSortedKeys();
        return this.mSortedKeys[index];
    }

    public V getElement(int index) {
        this.checkSortedKeys();
        return (V)this.mElements.get(this.mSortedKeys[index]);
    }

    public int getIndex(long address) {
        this.checkSortedKeys();
        return this.binarySearch(address);
    }

    public @NonNull List<V> getList() {
        return new ArrayList(this.mElements.valueCollection());
    }

    @Override
    public Iterator<@NonNull Entry<V>> iterator() {
        this.checkSortedKeys();
        return new IteratorImpl((long[])NullChecking.neverNull((Object)this.mSortedKeys));
    }

    public void removeAt(int index) {
        this.removeAt(this.getAddress(index));
    }

    public void removeAt(long address) {
        this.clearSortedKeys();
        this.mElements.remove(address);
    }

    public int size() {
        return this.mElements.size();
    }

    public String toString() {
        return StreamSupport.stream(this.spliterator(), false).map(e -> e.toString()).collect(Collectors.joining(", ", "{", "}"));
    }

    protected abstract int binarySearch(long var1);

    protected abstract void checkSortedKeys();

    private void clearSortedKeys() {
        this.mSortedKeys = null;
    }

    public static final class Entry<V> {
        public final long address;
        public final V value;

        public Entry(long address, V value) {
            this.address = address;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                Entry that = (Entry)obj;
                return this.address == that.address && NullChecking.equalsNullable(this.value, that.value);
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.address) * 31 + NullChecking.hashNullable(this.value);
        }

        public String toString() {
            return String.format("{0x%016x : %s}", this.address, this.value);
        }
    }

    private final class IteratorImpl
    implements Iterator<Entry<V>> {
        private int index;
        private final long @NonNull [] sortedKeys;

        public IteratorImpl(long[] sortedKeys) {
            this.sortedKeys = sortedKeys;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.sortedKeys.length;
        }

        @Override
        public @NonNull Entry<V> next() {
            if (this.sortedKeys != AddressMap.this.mSortedKeys) {
                throw new ConcurrentModificationException();
            }
            long address = this.sortedKeys[this.index++];
            return new Entry<Object>(address, AddressMap.this.mElements.get(address));
        }
    }
}

