/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.pass_two;

import com.arm.streamline.barman.pass_two.BarmanUniqueProcessThread;
import com.arm.streamline.barman.pass_two.IBarmanUniqueThread;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class BarmanUniqueThread
implements IBarmanUniqueThread {
    private final long earliestSeenTimestamp;
    private final boolean idle;
    private boolean ignored = true;
    private long lastSeenTimestamp;
    private final @Nullable String name;
    private final int taskId;
    private final int uid;

    protected BarmanUniqueThread(int uid, long timestamp, int taskId, @Nullable String name, boolean idle) {
        this.uid = uid;
        this.taskId = taskId;
        this.name = name;
        this.idle = idle;
        this.earliestSeenTimestamp = this.lastSeenTimestamp = timestamp;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BarmanUniqueThread) {
            boolean thatProcess;
            BarmanUniqueThread that = (BarmanUniqueThread)obj;
            boolean thisProcess = this.isProcessThread();
            if (thisProcess != (thatProcess = that.isProcessThread())) {
                return false;
            }
            return this.taskId == that.taskId && this.earliestSeenTimestamp == that.earliestSeenTimestamp && this.lastSeenTimestamp == that.lastSeenTimestamp && NullChecking.equalsNullable((Object)this.name, (Object)that.name) && this.equalsChild(that);
        }
        return false;
    }

    public final long getEarliestSeenTimestamp() {
        return this.earliestSeenTimestamp;
    }

    public final @Nullable Long getEndTimestamp() {
        return null;
    }

    public final long getLastSeenTimestamp() {
        return this.lastSeenTimestamp;
    }

    public final @Nullable String getName() {
        return this.name;
    }

    public final int getOriginalID() {
        return this.taskId;
    }

    public abstract @NonNull BarmanUniqueProcessThread getProcessThread();

    public final @Nullable Long getStartTimestamp() {
        return this.earliestSeenTimestamp;
    }

    public final int getUID() {
        return this.uid;
    }

    public final int hashCode() {
        return this.taskId;
    }

    public final boolean isIdle() {
        return this.idle;
    }

    public final boolean isIgnored() {
        return this.ignored;
    }

    public abstract String toString();

    public final void updateLastSeenTimestamp(long timestamp) {
        assert (timestamp >= this.lastSeenTimestamp);
        this.ignored = false;
        this.lastSeenTimestamp = timestamp;
    }

    protected abstract boolean equalsChild(@NonNull BarmanUniqueThread var1);
}

