/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.v22;

import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.ReadFormat;
import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.GatorStringProperty;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.ILongProperty;
import com.arm.streamline.protocol.gator.messages.IMessage;
import com.arm.streamline.protocol.gator.messages.IMessageCodec;
import com.arm.streamline.protocol.gator.messages.IObjectProperty;
import com.arm.streamline.protocol.gator.messages.ITaggedMessageRecord;
import com.arm.streamline.protocol.gator.messages.ITaggedMessageRecordCodec;
import com.arm.streamline.protocol.gator.messages.ITaggedRecordListProperty;
import com.arm.streamline.protocol.gator.messages.NullTerminatedStringProperty;
import com.arm.streamline.protocol.gator.messages.PackedIntProperty;
import com.arm.streamline.protocol.gator.messages.PackedLongProperty;
import com.arm.streamline.protocol.gator.messages.PerfEventAttributeProperty;
import com.arm.streamline.protocol.gator.messages.TaggedRecordListProperty;
import com.arm.streamline.protocol.gator.v22.AbstractFrameWithCore;
import com.arm.streamline.protocol.gator.v22.IMessageCodecContextV22;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.set.hash.TLongHashSet;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ProcFrame
extends AbstractFrameWithCore
implements IMessage<Codec> {
    public static final int TOKEN_COMM = 5;
    public static final int TOKEN_COUNTERS = 10;
    public static final int TOKEN_FORMAT = 3;
    public static final int TOKEN_HEADER_EVENT = 12;
    public static final int TOKEN_HEADER_PAGE = 11;
    public static final int TOKEN_KALLSYMS = 9;
    public static final int TOKEN_KEYS = 2;
    public static final int TOKEN_KEYS_OLD = 6;
    public static final int TOKEN_MAPS = 4;
    public static final int TOKEN_METRIC_KEY = 13;
    public static final int TOKEN_OFFLINE_CPU = 8;
    public static final int TOKEN_ONLINE_CPU = 7;
    public static final int TOKEN_PEA = 1;
    public static final int TOKEN_KERNEL_BUILD_ID = 14;
    public static final int TOKEN_KERNEL_MODULE_BUILD_ID = 15;
    public final @NonNull List<@NonNull IProcFrameRecord<?>> records;

    public ProcFrame(int cpu, @NonNull List<@NonNull IProcFrameRecord<?>> records) {
        super(cpu);
        this.records = Collections.unmodifiableList(records);
    }

    @Override
    public @NonNull Codec getCodec() {
        return Codec.INSTANCE;
    }

    @Override
    public @NonNull String toString() {
        return String.format("ProcFrame(%d, %d)", this.cpu, this.records.size());
    }

    public static abstract class AbstractStringMessage<T extends AbstractStringMessage<T>>
    implements IProcFrameRecord<T> {
        public final @NonNull String string;

        public AbstractStringMessage(@NonNull String string) {
            this.string = string;
        }

        public @NonNull String toString() {
            return String.format("%s(%s)", this.getClass().getSimpleName(), this.string);
        }

        public static final class Codec<T extends AbstractStringMessage<T>>
        implements ITaggedMessageRecordCodec<T, IMessageCodecContextV22> {
            public static final @NonNull IObjectProperty<String> PROPERTY_STRING = new NullTerminatedStringProperty("string", StandardCharsets.US_ASCII);
            private final @NonNull Function<@NonNull String, @NonNull T> constructor;
            private final int token;

            public Codec(int token, @NonNull Function<@NonNull String, @NonNull T> constructor) {
                this.token = token;
                this.constructor = constructor;
            }

            @Override
            public @NonNull T decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                @NonNull String string = PROPERTY_STRING.read(stream);
                return (T)((AbstractStringMessage)this.constructor.apply(string));
            }

            @Override
            public int encode(@NonNull T message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_STRING.write(stream, ((AbstractStringMessage)message).string);
                return this.token();
            }

            @Override
            public int token() {
                return this.token;
            }
        }
    }

    public static final class Codec
    extends Enum<Codec>
    implements IMessageCodec<ProcFrame, IProcFrameConsumer, IMessageCodecContextV22> {
        public static final /* enum */ Codec INSTANCE = new Codec();
        public static final @NonNull ITaggedRecordListProperty<IProcFrameRecord<?>, @NonNull IMessageCodecContextV22> PROPERTY_RECORDS;
        private static final /* synthetic */ Codec[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Codec[]{INSTANCE};
            PROPERTY_RECORDS = new TaggedRecordListProperty("records", FormatMessage.CODEC, HeaderPageMessage.CODEC, HeaderEventMessage.CODEC, CommMessage.Codec.INSTANCE, PerfEventAttributeMessage.Codec.INSTANCE, PerfKeysMessage.Codec.INSTANCE, PerfLegacyKeysMessage.Codec.INSTANCE, MapsMessage.Codec.INSTANCE, OnlineOfflineCpuMessage.Codec.ONLINE, OnlineOfflineCpuMessage.Codec.OFFLINE, KAllSymsMessage.CODEC, CountersMessage.Codec.INSTANCE, MetricKeyMessage.Codec.INSTANCE, KernelBuildIdMessage.Codec.INSTANCE, KernelModuleBuildIdMessage.Codec.INSTANCE);
        }

        @Override
        public void decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream, @NonNull IProcFrameConsumer consumer) throws IOException {
            assert (token == this.token());
            int cpu = PROPERTY_CPU.read(stream);
            ProcFrame message = new ProcFrame(cpu, Collections.emptyList());
            Throwable throwable = null;
            Object var8_9 = null;
            try (IProcFrameMessageConsumer recordConsumer = consumer.consume(message);){
                PROPERTY_RECORDS.stream(context, stream, record -> record.consume(message, recordConsumer));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public int encode(@NonNull ProcFrame message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            PROPERTY_CPU.write(stream, message.cpu);
            PROPERTY_RECORDS.write(context, stream, message.records);
            return this.token();
        }

        @Override
        public int token() {
            return 11;
        }

        public static Codec[] values() {
            Codec[] codecArray = ENUM$VALUES;
            int n = codecArray.length;
            Codec[] codecArray2 = new Codec[n];
            System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
            return codecArray2;
        }

        public static Codec valueOf(String string) {
            return Enum.valueOf(Codec.class, string);
        }
    }

    public static final class CommMessage
    implements IProcFrameRecord<CommMessage> {
        public final @NonNull String comm;
        public final @NonNull String image;
        public final int pid;
        public final int tid;

        public CommMessage(int pid, int tid, @NonNull String image, @NonNull String comm) {
            this.pid = pid;
            this.tid = tid;
            this.image = image;
            this.comm = comm;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<CommMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("CommMessage(%d, %d, %s, %s)", this.pid, this.tid, this.image, this.comm);
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<CommMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull IObjectProperty<String> PROPERTY_COMM;
            public static final @NonNull IObjectProperty<String> PROPERTY_IMAGE;
            public static final @NonNull IIntProperty PROPERTY_PID;
            public static final @NonNull IIntProperty PROPERTY_TID;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_COMM = new NullTerminatedStringProperty("comm", StandardCharsets.US_ASCII);
                PROPERTY_IMAGE = new NullTerminatedStringProperty("image", StandardCharsets.US_ASCII);
                PROPERTY_PID = new PackedIntProperty("pid");
                PROPERTY_TID = new PackedIntProperty("tid");
            }

            @Override
            public @NonNull CommMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                boolean isBroken;
                assert (token == this.token());
                int protocolVersion = context.getProtocolVersionNo();
                boolean isPossiblyBroken = protocolVersion >= 810 && protocolVersion < 830;
                int pid = PROPERTY_PID.read(stream);
                int tid = PROPERTY_TID.read(stream);
                @NonNull String image = PROPERTY_IMAGE.read(stream);
                @NonNull String comm = PROPERTY_COMM.read(stream);
                boolean bl = isBroken = isPossiblyBroken && comm.isEmpty() && !image.isEmpty();
                if (isBroken) {
                    return new CommMessage(pid, tid, "", image);
                }
                return new CommMessage(pid, tid, image, comm);
            }

            @Override
            public int encode(@NonNull CommMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_PID.write(stream, message.pid);
                PROPERTY_TID.write(stream, message.tid);
                PROPERTY_IMAGE.write(stream, message.image);
                PROPERTY_COMM.write(stream, message.comm);
                return this.token();
            }

            @Override
            public int token() {
                return 5;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }

    public static final class CountersMessage
    implements IProcFrameRecord<CountersMessage> {
        public final int @NonNull [] cpus;
        public final int @NonNull [] keys;
        public final long timestamp;
        public final long @NonNull [] values;

        public CountersMessage(long timestamp, int @NonNull [] cpus, int @NonNull [] keys, long @NonNull [] values) {
            if (cpus.length != keys.length || cpus.length != values.length) {
                throw new IllegalArgumentException();
            }
            this.timestamp = timestamp;
            this.cpus = cpus;
            this.keys = keys;
            this.values = values;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<CountersMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("CountersMessage(%d, %d)", this.timestamp, this.cpus.length);
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<CountersMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull IIntProperty PROPERTY_CPU;
            public static final @NonNull IIntProperty PROPERTY_KEY;
            public static final @NonNull ILongProperty PROPERTY_TIMESTAMP;
            public static final @NonNull ILongProperty PROPERTY_VALUE;
            private static final int MAGIC_CPU_END_OF_LIST = -1;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_CPU = new PackedIntProperty("cpu");
                PROPERTY_KEY = new PackedIntProperty("key");
                PROPERTY_TIMESTAMP = new PackedLongProperty("timestamp");
                PROPERTY_VALUE = new PackedLongProperty("value");
            }

            @Override
            public @NonNull CountersMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                TIntArrayList cpus = new TIntArrayList();
                TIntArrayList keys = new TIntArrayList();
                TLongArrayList values = new TLongArrayList();
                long timestamp = PROPERTY_TIMESTAMP.read(stream);
                while (stream.hasRemaining()) {
                    int cpu = PROPERTY_CPU.read(stream);
                    if (cpu == -1) break;
                    int key = PROPERTY_KEY.read(stream);
                    long value = PROPERTY_VALUE.read(stream);
                    cpus.add(cpu);
                    keys.add(key);
                    values.add(value);
                }
                return new CountersMessage(timestamp, (int[])NullChecking.neverNull((Object)cpus.toArray()), (int[])NullChecking.neverNull((Object)keys.toArray()), (long[])NullChecking.neverNull((Object)values.toArray()));
            }

            @Override
            public int encode(@NonNull CountersMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_TIMESTAMP.write(stream, message.timestamp);
                int i = 0;
                while (i < message.cpus.length) {
                    assert (message.cpus[i] != -1);
                    PROPERTY_CPU.write(stream, message.cpus[i]);
                    PROPERTY_KEY.write(stream, message.keys[i]);
                    PROPERTY_VALUE.write(stream, message.values[i]);
                    ++i;
                }
                PROPERTY_CPU.write(stream, -1);
                return this.token();
            }

            @Override
            public int token() {
                return 10;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }

    public static final class FormatMessage
    extends AbstractStringMessage<FormatMessage> {
        public static final @NonNull AbstractStringMessage.Codec<FormatMessage> CODEC = new AbstractStringMessage.Codec<FormatMessage>(3, FormatMessage::new);

        public FormatMessage(@NonNull String string) {
            super(string);
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<FormatMessage, @NonNull IMessageCodecContextV22> getCodec() {
            return CODEC;
        }
    }

    public static final class HeaderEventMessage
    extends AbstractStringMessage<HeaderEventMessage> {
        public static final @NonNull AbstractStringMessage.Codec<HeaderEventMessage> CODEC = new AbstractStringMessage.Codec<HeaderEventMessage>(12, HeaderEventMessage::new);

        public HeaderEventMessage(@NonNull String string) {
            super(string);
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<HeaderEventMessage, @NonNull IMessageCodecContextV22> getCodec() {
            return CODEC;
        }
    }

    public static final class HeaderPageMessage
    extends AbstractStringMessage<HeaderPageMessage> {
        public static final @NonNull AbstractStringMessage.Codec<HeaderPageMessage> CODEC = new AbstractStringMessage.Codec<HeaderPageMessage>(11, HeaderPageMessage::new);

        public HeaderPageMessage(@NonNull String string) {
            super(string);
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<HeaderPageMessage, @NonNull IMessageCodecContextV22> getCodec() {
            return CODEC;
        }
    }

    public static interface IProcFrameConsumer {
        public @NonNull IProcFrameMessageConsumer consume(@NonNull ProcFrame var1) throws IOException;
    }

    public static interface IProcFrameMessageConsumer
    extends Closeable {
        public void consume(@NonNull ProcFrame var1, @NonNull CommMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull CountersMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull FormatMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull HeaderEventMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull HeaderPageMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull KAllSymsMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull MapsMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull MetricKeyMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull OnlineOfflineCpuMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull PerfEventAttributeMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull PerfKeysMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull PerfLegacyKeysMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull KernelBuildIdMessage var2) throws IOException;

        public void consume(@NonNull ProcFrame var1, @NonNull KernelModuleBuildIdMessage var2) throws IOException;
    }

    public static interface IProcFrameRecord<T extends IProcFrameRecord<? extends T>>
    extends ITaggedMessageRecord<T, IMessageCodecContextV22> {
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> var1, U var2) throws E;

        public void consume(@NonNull ProcFrame var1, @NonNull IProcFrameMessageConsumer var2) throws IOException;
    }

    public static interface IProcFrameRecordVisitor<U, R, E extends Throwable> {
        public R visit(@NonNull CommMessage var1, U var2) throws E;

        public R visit(@NonNull CountersMessage var1, U var2) throws E;

        public R visit(@NonNull FormatMessage var1, U var2) throws E;

        public R visit(@NonNull HeaderEventMessage var1, U var2) throws E;

        public R visit(@NonNull HeaderPageMessage var1, U var2) throws E;

        public R visit(@NonNull KAllSymsMessage var1, U var2) throws E;

        public R visit(@NonNull MapsMessage var1, U var2) throws E;

        public R visit(@NonNull MetricKeyMessage var1, U var2) throws E;

        public R visit(@NonNull OnlineOfflineCpuMessage var1, U var2) throws E;

        public R visit(@NonNull PerfEventAttributeMessage var1, U var2) throws E;

        public R visit(@NonNull PerfKeysMessage var1, U var2) throws E;

        public R visit(@NonNull PerfLegacyKeysMessage var1, U var2) throws E;

        public R visit(@NonNull KernelBuildIdMessage var1, U var2) throws E;

        public R visit(@NonNull KernelModuleBuildIdMessage var1, U var2) throws E;
    }

    public static final class KAllSymsMessage
    extends AbstractStringMessage<KAllSymsMessage> {
        public static final @NonNull AbstractStringMessage.Codec<KAllSymsMessage> CODEC = new AbstractStringMessage.Codec<KAllSymsMessage>(9, KAllSymsMessage::new);

        public KAllSymsMessage(@NonNull String string) {
            super(string);
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<KAllSymsMessage, @NonNull IMessageCodecContextV22> getCodec() {
            return CODEC;
        }
    }

    public static final class KernelBuildIdMessage
    implements IProcFrameRecord<KernelBuildIdMessage> {
        public final byte @NonNull [] data;

        public KernelBuildIdMessage(byte @NonNull [] data) {
            this.data = data;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<KernelBuildIdMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("KernelBuildIdMessage(%s)", ArrayUtils.toString((byte[])this.data, b -> String.format("0x%02x", b)));
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<KernelBuildIdMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull IIntProperty PROPERTY_SIZE;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_SIZE = new PackedIntProperty("size");
            }

            @Override
            public @NonNull KernelBuildIdMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                int size = PROPERTY_SIZE.read(stream);
                if (size < 0) {
                    throw new IOException("Protocol error - invalid size");
                }
                byte[] buffer = new byte[size];
                stream.get(buffer);
                return new KernelBuildIdMessage(buffer);
            }

            @Override
            public int encode(@NonNull KernelBuildIdMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                stream.writePackedInt(message.data.length);
                stream.write(message.data);
                return this.token();
            }

            @Override
            public int token() {
                return 14;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }

    public static final class KernelModuleBuildIdMessage
    implements IProcFrameRecord<KernelModuleBuildIdMessage> {
        public final byte @NonNull [] data;
        public final @NonNull String name;

        public KernelModuleBuildIdMessage(@NonNull String name, byte @NonNull [] data) {
            this.name = name;
            this.data = data;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<KernelModuleBuildIdMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("KernelModuleBuildIdMessage(%s, %s)", this.name, ArrayUtils.toString((byte[])this.data, b -> String.format("0x%02x", b)));
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<KernelModuleBuildIdMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull IObjectProperty<String> PROPERTY_NAME;
            public static final @NonNull IIntProperty PROPERTY_SIZE;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_NAME = new GatorStringProperty("name");
                PROPERTY_SIZE = new PackedIntProperty("size");
            }

            @Override
            public @NonNull KernelModuleBuildIdMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                String name = PROPERTY_NAME.read(stream);
                int size = PROPERTY_SIZE.read(stream);
                if (size < 0) {
                    throw new IOException("Protocol error - invalid size");
                }
                byte[] buffer = new byte[size];
                stream.get(buffer);
                return new KernelModuleBuildIdMessage(name, buffer);
            }

            @Override
            public int encode(@NonNull KernelModuleBuildIdMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                stream.writePackedInt(message.data.length);
                stream.write(message.data);
                return this.token();
            }

            @Override
            public int token() {
                return 15;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }

    public static final class MapsMessage
    implements IProcFrameRecord<MapsMessage> {
        public final @NonNull String maps;
        public final int pid;
        public final int tid;

        public MapsMessage(int pid, int tid, @NonNull String maps) {
            this.pid = pid;
            this.tid = tid;
            this.maps = maps;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<MapsMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("MapsMessage(%d, %d, %s)", this.pid, this.tid, this.maps);
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<MapsMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull IObjectProperty<String> PROPERTY_MAPS;
            public static final @NonNull IIntProperty PROPERTY_PID;
            public static final @NonNull IIntProperty PROPERTY_TID;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_MAPS = new NullTerminatedStringProperty("maps", StandardCharsets.US_ASCII);
                PROPERTY_PID = new PackedIntProperty("pid");
                PROPERTY_TID = new PackedIntProperty("tid");
            }

            @Override
            public @NonNull MapsMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                int pid = PROPERTY_PID.read(stream);
                int tid = PROPERTY_TID.read(stream);
                @NonNull String maps = PROPERTY_MAPS.read(stream);
                return new MapsMessage(pid, tid, maps);
            }

            @Override
            public int encode(@NonNull MapsMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_PID.write(stream, message.pid);
                PROPERTY_TID.write(stream, message.tid);
                PROPERTY_MAPS.write(stream, message.maps);
                return this.token();
            }

            @Override
            public int token() {
                return 4;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }

    public static final class MetricKeyMessage
    implements IProcFrameRecord<MetricKeyMessage> {
        public final int eventCode;
        public final int eventKey;
        public final int metricKey;
        public final @NonNull Type type;

        public MetricKeyMessage(int metricKey, int eventCode, int eventKey, @NonNull Type type) {
            this.metricKey = metricKey;
            this.eventCode = eventCode;
            this.eventKey = eventKey;
            this.type = type;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<MetricKeyMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<MetricKeyMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull IIntProperty PROPERTY_EVENT_CODE;
            public static final @NonNull IIntProperty PROPERTY_EVENT_KEY;
            public static final @NonNull IIntProperty PROPERTY_METRIC_KEY;
            public static final @NonNull IIntProperty PROPERTY_TYPE;
            private static final int TYPE_CODE_CYCLE_COUNTER = 1;
            private static final int TYPE_CODE_EVENT = 0;
            private static final int TYPE_CODE_RETURN_EVENT = 2;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_EVENT_CODE = new PackedIntProperty("event_code");
                PROPERTY_EVENT_KEY = new PackedIntProperty("event_key");
                PROPERTY_METRIC_KEY = new PackedIntProperty("metric_key");
                PROPERTY_TYPE = new PackedIntProperty("type");
            }

            @Override
            public @NonNull MetricKeyMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                int metricKey = PROPERTY_METRIC_KEY.read(stream);
                int eventCode = PROPERTY_EVENT_CODE.read(stream);
                int eventKey = PROPERTY_EVENT_KEY.read(stream);
                int typeCode = PROPERTY_TYPE.read(stream);
                return new MetricKeyMessage(metricKey, eventCode, eventKey, switch (typeCode) {
                    case 0 -> Type.EVENT;
                    case 1 -> Type.CYCLE_COUNTER;
                    case 2 -> Type.RETURN_EVENT;
                    default -> throw new IOException("Unexpected metric key message type code value");
                });
            }

            @Override
            public int encode(@NonNull MetricKeyMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_METRIC_KEY.write(stream, message.metricKey);
                PROPERTY_EVENT_CODE.write(stream, message.eventCode);
                PROPERTY_EVENT_KEY.write(stream, message.eventKey);
                switch (message.type) {
                    case EVENT: {
                        PROPERTY_TYPE.write(stream, 0);
                        break;
                    }
                    case CYCLE_COUNTER: {
                        PROPERTY_TYPE.write(stream, 1);
                        break;
                    }
                    case RETURN_EVENT: {
                        PROPERTY_TYPE.write(stream, 2);
                        break;
                    }
                }
                return this.token();
            }

            @Override
            public int token() {
                return 13;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }

        public static enum Type {
            CYCLE_COUNTER,
            EVENT,
            RETURN_EVENT;

        }
    }

    public static final class OnlineOfflineCpuMessage
    implements IProcFrameRecord<OnlineOfflineCpuMessage> {
        public final int cpu;
        public final boolean online;
        public final long timestamp;

        public OnlineOfflineCpuMessage(long timestamp, int cpu, boolean online) {
            this.timestamp = timestamp;
            this.cpu = cpu;
            this.online = online;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<OnlineOfflineCpuMessage, IMessageCodecContextV22> getCodec() {
            return this.online ? Codec.ONLINE : Codec.OFFLINE;
        }

        public @NonNull String toString() {
            return String.format("OnlineOfflineCpuMessage(%d, %d, %s)", this.timestamp, this.cpu, this.online);
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<OnlineOfflineCpuMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec OFFLINE = new Codec(8);
            public static final /* enum */ Codec ONLINE = new Codec(7);
            public static final @NonNull IIntProperty PROPERTY_CPU;
            public static final @NonNull ILongProperty PROPERTY_TIMESTAMP;
            private final int token;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{OFFLINE, ONLINE};
                PROPERTY_CPU = new PackedIntProperty("cpu");
                PROPERTY_TIMESTAMP = new PackedLongProperty("timestamp");
            }

            private Codec(int token) {
                this.token = token;
            }

            @Override
            public @NonNull OnlineOfflineCpuMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                long timestamp = PROPERTY_TIMESTAMP.read(stream);
                int cpu = PROPERTY_CPU.read(stream);
                return new OnlineOfflineCpuMessage(timestamp, cpu, this == ONLINE);
            }

            @Override
            public int encode(@NonNull OnlineOfflineCpuMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                if (message.online != (this == ONLINE)) {
                    throw new AssertionError(this);
                }
                PROPERTY_TIMESTAMP.write(stream, message.timestamp);
                PROPERTY_CPU.write(stream, message.cpu);
                return this.token();
            }

            @Override
            public int token() {
                return this.token;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }

    public static final class PerfEventAttributeMessage
    implements IProcFrameRecord<PerfEventAttributeMessage> {
        public final @NonNull EventAttribute attribute;
        public final int key;

        public PerfEventAttributeMessage(int key, @NonNull EventAttribute attribute) {
            this.key = key;
            this.attribute = attribute;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<PerfEventAttributeMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("PerfEventAttributeMessage(%d, %s)", this.key, this.attribute);
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<PerfEventAttributeMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull PerfEventAttributeProperty PROPERTY_EVENT_ATTRIBUTE;
            public static final @NonNull IIntProperty PROPERTY_KEY;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_EVENT_ATTRIBUTE = new PerfEventAttributeProperty("event_attribute");
                PROPERTY_KEY = new PackedIntProperty("key");
            }

            @Override
            public @NonNull PerfEventAttributeMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                @NonNull EventAttribute attribute = PROPERTY_EVENT_ATTRIBUTE.read(stream);
                int key = PROPERTY_KEY.read(stream);
                return new PerfEventAttributeMessage(key, attribute);
            }

            @Override
            public int encode(@NonNull PerfEventAttributeMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_EVENT_ATTRIBUTE.write(stream, message.attribute);
                PROPERTY_KEY.write(stream, message.key);
                return this.token();
            }

            @Override
            public int token() {
                return 1;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }

    public static final class PerfKeysMessage
    implements IProcFrameRecord<PerfKeysMessage> {
        public final long @NonNull [] ids;
        public final int @NonNull [] keys;

        public PerfKeysMessage(long @NonNull [] ids, int @NonNull [] keys) {
            if (ids.length != keys.length) {
                throw new IllegalArgumentException("ids and keys must be same length");
            }
            this.ids = ids;
            this.keys = keys;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<PerfKeysMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("PerfKeysMessage(%s, %s)", Arrays.toString(this.ids), Arrays.toString(this.keys));
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<PerfKeysMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull IIntProperty PROPERTY_COUNT;
            public static final @NonNull ILongProperty PROPERTY_ID;
            public static final @NonNull IIntProperty PROPERTY_KEY;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_COUNT = new PackedIntProperty("count");
                PROPERTY_ID = new PackedLongProperty("id");
                PROPERTY_KEY = new PackedIntProperty("key");
            }

            @Override
            public @NonNull PerfKeysMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                int count = PROPERTY_COUNT.read(stream);
                long[] ids = new long[count];
                int[] keys = new int[count];
                TLongHashSet idsSet = new TLongHashSet();
                int i = 0;
                while (i < count) {
                    long id = PROPERTY_ID.read(stream);
                    int key = PROPERTY_KEY.read(stream);
                    assert (idsSet.add(id));
                    ids[i] = id;
                    keys[i] = key;
                    ++i;
                }
                return new PerfKeysMessage(ids, keys);
            }

            @Override
            public int encode(@NonNull PerfKeysMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                assert (message.ids.length == message.keys.length);
                int count = message.ids.length;
                PROPERTY_COUNT.write(stream, count);
                int i = 0;
                while (i < count) {
                    PROPERTY_ID.write(stream, message.ids[i]);
                    PROPERTY_KEY.write(stream, message.keys[i]);
                    ++i;
                }
                return this.token();
            }

            @Override
            public int token() {
                return 2;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }

    public static final class PerfLegacyKeysMessage
    implements IProcFrameRecord<PerfLegacyKeysMessage> {
        public final long @NonNull [] ids;
        public final int @NonNull [] keys;
        public final long readFormat;

        public PerfLegacyKeysMessage(long readFormat, long @NonNull [] ids, int @NonNull [] keys) {
            if (ids.length != keys.length) {
                throw new IllegalArgumentException("ids and keys must be same length");
            }
            this.readFormat = readFormat;
            this.ids = ids;
            this.keys = keys;
        }

        @Override
        public <U, R, E extends Throwable> R accept(@NonNull IProcFrameRecordVisitor<U, R, E> visitor, U data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public void consume(@NonNull ProcFrame message, @NonNull IProcFrameMessageConsumer consumer) throws IOException {
            consumer.consume(message, this);
        }

        @Override
        public @NonNull ITaggedMessageRecordCodec<PerfLegacyKeysMessage, IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public @NonNull String toString() {
            return String.format("PerfLegacyKeysMessage(0x%x, %s, %s)", this.readFormat, Arrays.toString(this.ids), Arrays.toString(this.keys));
        }

        public static final class Codec
        extends Enum<Codec>
        implements ITaggedMessageRecordCodec<PerfLegacyKeysMessage, IMessageCodecContextV22> {
            public static final /* enum */ Codec INSTANCE = new Codec();
            public static final @NonNull IIntProperty PROPERTY_COUNT;
            public static final @NonNull IIntProperty PROPERTY_KEY;
            private static final /* synthetic */ Codec[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Codec[]{INSTANCE};
                PROPERTY_COUNT = new PackedIntProperty("count");
                PROPERTY_KEY = new PackedIntProperty("key");
            }

            @Override
            public @NonNull PerfLegacyKeysMessage decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                assert (token == this.token());
                int count = PROPERTY_COUNT.read(stream);
                if (count < 1) {
                    throw new IOException("Protocol error - invalid key count");
                }
                int @NonNull [] keys = new int[count];
                int i = 0;
                while (i < count) {
                    keys[i] = PROPERTY_COUNT.read(stream);
                    ++i;
                }
                @Nullable EventAttribute eventAttribute = context.getPerfEventAttributeByKey(keys[0]);
                if (eventAttribute == null) {
                    throw new IOException("Protocol error - cannot decode perf readformat without perf_event_attr");
                }
                @NonNull ReadFormat readFormat = new ReadFormat(null, eventAttribute.getReadFormat(), stream::getLELong);
                long @NonNull [] ids = readFormat.getIds();
                if (keys.length != ids.length) {
                    throw new IOException("Protocol error - key vs. id length mismatch");
                }
                return new PerfLegacyKeysMessage(eventAttribute.getReadFormat(), ids, keys);
            }

            @Override
            public int encode(@NonNull PerfLegacyKeysMessage message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                assert (message.ids.length == message.keys.length);
                int count = message.ids.length;
                PROPERTY_COUNT.write(stream, count);
                int[] nArray = message.keys;
                int n = message.keys.length;
                int n2 = 0;
                while (n2 < n) {
                    int key = nArray[n2];
                    PROPERTY_KEY.write(stream, key);
                    ++n2;
                }
                @Nullable EventAttribute eventAttribute = context.getPerfEventAttributeByKey(message.keys[0]);
                if (eventAttribute == null) {
                    throw new IOException("Protocol error - cannot decode perf readformat without perf_event_attr");
                }
                if (eventAttribute.getReadFormat() != message.readFormat) {
                    throw new AssertionError();
                }
                ReadFormat.write(message.readFormat, message.ids, new long[count], stream::writeLELong);
                return this.token();
            }

            @Override
            public int token() {
                return 6;
            }

            public static Codec[] values() {
                Codec[] codecArray = ENUM$VALUES;
                int n = codecArray.length;
                Codec[] codecArray2 = new Codec[n];
                System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
                return codecArray2;
            }

            public static Codec valueOf(String string) {
                return Enum.valueOf(Codec.class, string);
            }
        }
    }
}

