/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IMessageRecord;
import com.arm.streamline.protocol.gator.messages.IMessageRecordCodec;
import com.arm.streamline.protocol.gator.messages.IRecordListProperty;
import com.arm.utils.function.IThrowingConsumer;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class SingleRecordListProperty<T extends IMessageRecord<T, C>, C>
implements IRecordListProperty<T, C> {
    private final @NonNull IMessageRecordCodec<T, C> codec;
    private final @NonNull String name;

    public SingleRecordListProperty(@NonNull String name, @NonNull IMessageRecordCodec<T, C> codec) {
        this.name = name;
        this.codec = codec;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull T readOne(C context, @NonNull IAPCByteReader stream) throws IOException {
        return (T)((IMessageRecord)this.codec.decode(context, stream));
    }

    @Override
    public <E extends Throwable> void stream(C context, @NonNull IAPCByteReader stream, @NonNull IThrowingConsumer<@NonNull T, E> consumer) throws IOException, E {
        while (stream.hasRemaining()) {
            @NonNull T record = this.readOne(context, stream);
            consumer.accept(record);
        }
    }

    @Override
    public void write(C context, @NonNull IAPCByteWriter stream, @NonNull Iterable<@NonNull T> values) throws IOException {
        for (IMessageRecord value : values) {
            this.writeOne(context, stream, value);
        }
    }

    private void writeOne(C context, @NonNull IAPCByteWriter stream, @NonNull T value) throws IOException {
        this.codec.encode(value, context, stream);
    }
}

