/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IObjectProperty;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.jdt.annotation.NonNull;

public final class NullTerminatedStringProperty
implements IObjectProperty<String> {
    private final @NonNull Charset characterSet;
    private final @NonNull String name;

    public NullTerminatedStringProperty(@NonNull String name, @NonNull Charset characterSet) {
        this.name = name;
        this.characterSet = characterSet;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String read(@NonNull IAPCByteReader stream) throws IOException {
        return stream.readNullTerminatedString(this.characterSet);
    }

    @Override
    public void write(@NonNull IAPCByteWriter stream, @NonNull String value) throws IOException {
        stream.writeNullTerminatedString(value, this.characterSet);
    }
}

