/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IFrameMessageDecoder;
import com.arm.streamline.protocol.gator.messages.IFrameMessageEncoder;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.IMessage;
import com.arm.streamline.protocol.gator.messages.IMessageDecoder;
import com.arm.streamline.protocol.gator.messages.IMessageEncoder;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractFrameCodec<C, X>
implements IFrameMessageDecoder<C, X>,
IFrameMessageEncoder<X> {
    protected final @NonNull TIntObjectMap<IMessageDecoder<? super C, ? super X>> decoders = new TIntObjectHashMap();
    protected final @NonNull IIntProperty tokenProperty;

    protected AbstractFrameCodec(@NonNull IIntProperty tokenProperty, @NonNull List<@NonNull ? extends IMessageDecoder<? super C, ? super X>> decoders) {
        assert (!decoders.isEmpty());
        this.tokenProperty = tokenProperty;
        for (IMessageDecoder<C, X> decoder : decoders) {
            this.decoders.put(decoder.token(), decoder);
        }
    }

    @Override
    public void decode(X context, @NonNull IAPCByteReader stream, @NonNull C consumer) throws IOException {
        int token = this.tokenProperty.read(stream);
        @Nullable IMessageDecoder codec = (IMessageDecoder)this.decoders.get(token);
        if (codec == null) {
            throw new IOException(String.format("Invalid message token %d", token));
        }
        codec.decode(token, context, stream, consumer);
    }

    @Override
    public <E extends IMessageEncoder<T, ? super X>, T extends IMessage<E>> void encode(@NonNull T message, X context, @NonNull IAPCByteWriter stream) throws IOException {
        @NonNull IMessageEncoder codec = (IMessageEncoder)message.getCodec();
        assert (this.decoders.containsValue((Object)codec));
        int token = codec.token();
        this.tokenProperty.write(stream, token);
        int outputToken = codec.encode(message, context, stream);
        if (token != outputToken) {
            throw new AssertionError();
        }
    }
}

