/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.perf;

import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferReader;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferWriter;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfProtocolStateTracker;
import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PerfAttributesTracker
implements IPerfProtocolStateTracker {
    protected final @NonNull TIntObjectMap<EventAttribute> attributesByKey = new TIntObjectHashMap();
    protected final @NonNull TLongIntMap idToKeyMap = new TLongIntHashMap();
    private @Nullable Long attributeSampleTypeSharedIdBits;
    private final @NonNull IPerfAuxDataBufferTracker auxBufferTracker;
    private boolean contextSwitchEventsSeen;
    private @Nullable Integer singleIdlessAttributeKey = null;
    private boolean supportsSchedulerTrace = true;
    private final @NonNull TLongObjectMap<TracepointFormat> tracepointFormats = new TLongObjectHashMap();
    private final long vmUID;

    public PerfAttributesTracker(long vmUID, @NonNull IPerfAuxDataBufferTracker auxBufferTracker) {
        this.vmUID = vmUID;
        this.auxBufferTracker = auxBufferTracker;
    }

    @Override
    public void addPerfEventAttributeByKey(int key, @NonNull EventAttribute attribute) throws InvalidPerfDataException, IOException {
        if (!attribute.isFlagSet(EventAttribute.Flags.SAMPLE_ID_ALL) && (attribute.isFlagSet(EventAttribute.Flags.MMAP) || attribute.isFlagSet(EventAttribute.Flags.COMM) || attribute.isFlagSet(EventAttribute.Flags.TASK) || attribute.isFlagSet(EventAttribute.Flags.MMAP_DATA) || attribute.isFlagSet(EventAttribute.Flags.MMAP2) || attribute.isFlagSet(EventAttribute.Flags.CONTEXT_SWITCH) || attribute.getAuxWatermark() != 0)) {
            throw new InvalidPerfDataException(InvalidPerfDataException.Reason.NO_SAMPLE_ID_ALL);
        }
        @Nullable EventAttribute prev = (EventAttribute)this.attributesByKey.get(key);
        if (prev != null) {
            if (prev.equals(attribute)) {
                return;
            }
            throw new IOException("Duplicate attribute key");
        }
        @Nullable Long attributeSampleTypeSharedIdBits = this.attributeSampleTypeSharedIdBits;
        if (attributeSampleTypeSharedIdBits == null) {
            boolean attributeUsesId;
            this.attributeSampleTypeSharedIdBits = attribute.getSampleType();
            boolean attributeUsesIdentifier = (attribute.getSampleType() & 0x10000L) != 0L;
            boolean bl = attributeUsesId = (attribute.getSampleType() & 0x40L) != 0L;
            if (!attributeUsesIdentifier && !attributeUsesId) {
                this.singleIdlessAttributeKey = key;
            }
        } else {
            long globalSampleType = attributeSampleTypeSharedIdBits;
            boolean globalUsesIdentifier = (globalSampleType & 0x10000L) != 0L;
            boolean attributeUsesIdentifier = (attribute.getSampleType() & 0x10000L) != 0L;
            boolean globalUsesId = (globalSampleType & 0x40L) != 0L;
            boolean attributeUsesId = (attribute.getSampleType() & 0x40L) != 0L;
            long globalNonSampleIdBits = globalSampleType & 0xC0L;
            long attributeNonSampleIdBits = attribute.getSampleType() & 0xC0L;
            long globalSampleIdBits = globalSampleType & 0x4FL;
            long attributeSampleIdBits = attribute.getSampleType() & 0x4FL;
            if (!(globalUsesIdentifier && attributeUsesIdentifier || globalUsesId && attributeUsesId && globalNonSampleIdBits == attributeNonSampleIdBits && globalSampleIdBits == attributeSampleIdBits)) {
                throw new InvalidPerfDataException(InvalidPerfDataException.Reason.CANNOT_DECODE_ID);
            }
        }
        this.attributesByKey.put(key, (Object)attribute);
        this.contextSwitchEventsSeen |= attribute.isFlagSet(EventAttribute.Flags.CONTEXT_SWITCH);
    }

    @Override
    public void addPerfEventAttributeIdToKeyMapping(long id, int key) {
        this.idToKeyMap.put(id, key);
    }

    @Override
    public void addTracepointFormat(@NonNull TracepointFormat tracepointFormat) {
        this.tracepointFormats.put(tracepointFormat.getId(), (Object)tracepointFormat);
    }

    @Override
    public @NonNull TIntObjectMap<EventAttribute> getAllPerfEventAttributesByKey() {
        return TCollections.unmodifiableMap(this.attributesByKey);
    }

    @Override
    public @Nullable Long getAttributeSampleTypeSharedIdBits() {
        return this.attributeSampleTypeSharedIdBits;
    }

    @Override
    public @NonNull EventAttribute getEventAttributeById(@Nullable Long id) throws InvalidPerfDataException {
        EventAttribute attribute;
        @Nullable Integer key = this.getKeyByAttributeId(id);
        EventAttribute eventAttribute = attribute = key != null ? (EventAttribute)this.attributesByKey.get(key.intValue()) : null;
        if (attribute == null) {
            throw new InvalidPerfDataException(InvalidPerfDataException.Reason.MISSING_ID);
        }
        return attribute;
    }

    @Override
    public @Nullable Integer getKeyByAttributeId(@Nullable Long id) {
        if (id != null) {
            long mapId = id;
            if (this.idToKeyMap.containsKey(mapId)) {
                return this.idToKeyMap.get(mapId);
            }
            return null;
        }
        return this.singleIdlessAttributeKey;
    }

    @Override
    public @NonNull IPerfAuxDataBufferReader getPerfAuxBufferReader(int cpu) throws IOException {
        return this.auxBufferTracker.getPerfAuxBufferReader(this.vmUID, cpu);
    }

    @Override
    public @NonNull IPerfAuxDataBufferWriter getPerfAuxBufferWriter(int cpu) throws IOException {
        return this.auxBufferTracker.getPerfAuxBufferWriter(this.vmUID, cpu);
    }

    @Override
    public @Nullable EventAttribute getPerfEventAttributeByKey(int key) {
        return (EventAttribute)this.attributesByKey.get(key);
    }

    @Override
    public @Nullable TracepointFormat getTracepointFormat(long id) {
        return (TracepointFormat)this.tracepointFormats.get(id);
    }

    @Override
    public boolean hasContextSwitchEvents() {
        return this.contextSwitchEventsSeen;
    }

    @Override
    public boolean isSupportsSchedulerTrace() {
        return this.supportsSchedulerTrace;
    }

    @Override
    public void setSupportsSchedulerTrace(boolean supportsSchedulerTrace) {
        this.supportsSchedulerTrace = supportsSchedulerTrace;
    }
}

