/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.mipe;

import com.arm.streamline.protocol.ProtocolException;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeHeader;
import gnu.trove.TCollections;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MipePacket_HW_Counter_Values {
    public final @NonNull TIntIntMap counterValues;
    public final @NonNull MipeHeader header;
    public final long timestamp;

    public static @Nullable MipePacket_HW_Counter_Values create(@NonNull MipeHeader header, byte @NonNull [] data) throws ProtocolException {
        if (header.getPacketFamily() != 3 || header.getPacketClass() != 0 || header.getPacketType() != 0) {
            throw new IllegalArgumentException();
        }
        int dataLength = header.getDataLength();
        if (dataLength == 0) {
            return null;
        }
        if (dataLength > data.length) {
            throw new IllegalArgumentException();
        }
        if (dataLength < 8) {
            throw new ProtocolException(ProtocolException.Reason.INVALID_MALI_ENCAPSULATED_DATA);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, dataLength);
        byteBuffer.order(header.getByteOrder());
        long timestamp = byteBuffer.getLong();
        TIntIntHashMap counterValues = new TIntIntHashMap(10, 0.5f, -1, 0);
        while (byteBuffer.remaining() >= 6) {
            int counterIndex = byteBuffer.getShort() & 0xFFFF;
            int counterValue = byteBuffer.getInt();
            assert (!counterValues.containsKey(counterIndex));
            counterValues.put(counterIndex, counterValue);
        }
        return new MipePacket_HW_Counter_Values(header, timestamp, (TIntIntMap)counterValues);
    }

    protected MipePacket_HW_Counter_Values(@NonNull MipeHeader header, long timestamp, @NonNull TIntIntMap counterValues) {
        this.header = header;
        this.timestamp = timestamp;
        this.counterValues = TCollections.unmodifiableMap((TIntIntMap)counterValues);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MipePacket_HW_Counter_Values) {
            MipePacket_HW_Counter_Values that = (MipePacket_HW_Counter_Values)obj;
            return this.header.equals(that.header) && this.timestamp == that.timestamp && this.counterValues.equals(that.counterValues);
        }
        return false;
    }

    public int hashCode() {
        return (this.header.hashCode() * 31 + this.counterValues.hashCode()) * 31 + Long.hashCode(this.timestamp);
    }

    public String toString() {
        return String.format("MipePacket_Control_HW_Counter_Directory [header=%s, timestamp=%s, counterValues=%s]", this.header, this.timestamp, this.counterValues);
    }
}

